/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.analyzer.label;

import com.carrotsearch.hppc.ObjectLongOpenHashMap;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.simba.tapioca.data.DatasetClassInfo;
import org.aksw.simba.tapioca.data.DatasetPropertyInfo;
import org.aksw.simba.tapioca.data.vocabularies.VOID;
import org.aksw.simba.tapioca.preprocessing.JenaBasedVoidParsingSupplierDecorator;
import org.aksw.simba.tapioca.preprocessing.labelretrieving.LabelTokenizerHelper;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.dice_research.topicmodeling.io.SimpleDocSupplierFromFile;
import org.dice_research.topicmodeling.preprocessing.docsupplier.DocumentSupplier;
import org.dice_research.topicmodeling.preprocessing.docsupplier.decorator.DocumentTextCreatingSupplierDecorator;
import org.dice_research.topicmodeling.utils.doc.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelExtractionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LabelExtractionUtils.class);

    public static Set<String> readUris(File voidFile) {
        ObjectLongOpenHashMap countedURIs;
        SimpleDocSupplierFromFile reader = new SimpleDocSupplierFromFile();
        reader.createRawDocumentAdHoc(voidFile);
        DocumentTextCreatingSupplierDecorator supplier = new DocumentTextCreatingSupplierDecorator((DocumentSupplier)reader);
        supplier = new JenaBasedVoidParsingSupplierDecorator((DocumentSupplier)supplier);
        Document document = supplier.getNextDocument();
        DatasetClassInfo classInfo = (DatasetClassInfo)document.getProperty(DatasetClassInfo.class);
        HashSet<String> uris = new HashSet<String>();
        if (classInfo != null) {
            countedURIs = (ObjectLongOpenHashMap)classInfo.get();
            int i = 0;
            while (i < countedURIs.allocated.length) {
                if (countedURIs.allocated[i]) {
                    uris.add((String)countedURIs.keys[i]);
                }
                ++i;
            }
        } else {
            LOGGER.error("Document doesn't contain class information. Returning null.");
            return null;
        }
        DatasetPropertyInfo propInfo = (DatasetPropertyInfo)document.getProperty(DatasetPropertyInfo.class);
        if (propInfo != null) {
            countedURIs = (ObjectLongOpenHashMap)propInfo.get();
            int i = 0;
            while (i < countedURIs.allocated.length) {
                if (countedURIs.allocated[i]) {
                    uris.add((String)countedURIs.keys[i]);
                }
                ++i;
            }
        } else {
            LOGGER.error("Document doesn't contain property information. Returning null.");
            return null;
        }
        return uris;
    }

    public static Set<String> readUris(Model voidModel) {
        HashSet<String> uris = new HashSet<String>();
        Property[] properties = new Property[]{VOID.clazz, VOID.property};
        int i = 0;
        while (i < properties.length) {
            NodeIterator iterator = voidModel.listObjectsOfProperty(properties[i]);
            while (iterator.hasNext()) {
                RDFNode n = iterator.next();
                if (!n.isURIResource()) continue;
                uris.add(n.asResource().getURI());
            }
            ++i;
        }
        return uris;
    }

    public static String[][] generateArray(Map<String, Set<String>> labels) {
        String[][] uriToLabel = new String[labels.size()][];
        int pos = 0;
        for (Map.Entry<String, Set<String>> labelsOfUri : labels.entrySet()) {
            String[] tokenizedLabel = LabelExtractionUtils.tokenize(labelsOfUri.getValue());
            if (tokenizedLabel != null) {
                uriToLabel[pos] = new String[tokenizedLabel.length + 1];
                System.arraycopy(tokenizedLabel, 0, uriToLabel[pos], 1, tokenizedLabel.length);
            } else {
                uriToLabel[pos] = new String[1];
            }
            uriToLabel[pos][0] = labelsOfUri.getKey();
            ++pos;
        }
        return uriToLabel;
    }

    public static String[] tokenize(Set<String> names) {
        HashSet uniqueLabels = new HashSet();
        for (String label : names) {
            uniqueLabels.addAll(LabelTokenizerHelper.getSeparatedText((String)label));
        }
        return uniqueLabels.toArray(new String[uniqueLabels.size()]);
    }
}

