/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.analyzer.hdt;

import java.io.Closeable;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.aksw.simba.tapioca.analyzer.hdt.HdtDumpFileAnalyzer;
import org.aksw.simba.tapioca.analyzer.label.LabelExtractionUtils;
import org.aksw.simba.tapioca.preprocessing.labelretrieving.RDFClientLabelRetriever;
import org.apache.commons.io.IOUtils;
import org.apache.jena.rdf.model.Model;
import org.rdfhdt.hdt.exceptions.NotFoundException;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdt.triples.IteratorTripleString;
import org.rdfhdt.hdt.triples.TripleString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdtLabelExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HdtLabelExtractor.class);

    public static void main(String[] args) {
        String[][] labels;
        HdtLabelExtractor extr = new HdtLabelExtractor();
        HdtDumpFileAnalyzer analyzer = new HdtDumpFileAnalyzer();
        String[][] stringArray = labels = extr.extractLabels(new File("test.hdt"), analyzer.extractVoidInfo("http://test.com", "test.hdt"));
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String[] labelArr;
            String[] stringArray2 = labelArr = stringArray[n2];
            int n3 = labelArr.length;
            int n4 = 0;
            while (n4 < n3) {
                String label = stringArray2[n4];
                System.out.print(String.valueOf(label) + "  ");
                ++n4;
            }
            System.out.println();
            ++n2;
        }
    }

    public String[][] extractLabels(File hdtDumpFile, Model voidModel) {
        return this.extractLabels(hdtDumpFile, LabelExtractionUtils.readUris(voidModel));
    }

    public String[][] extractLabels(File hdtDumpFile, Set<String> uris) {
        String[][] stringArray;
        HDT hdt = null;
        try {
            hdt = HDTManager.loadIndexedHDT((String)hdtDumpFile.getAbsolutePath(), null);
            IteratorTripleString it = hdt.search(null, null, null);
            HashMap<String, Set<String>> labels = new HashMap<String, Set<String>>();
            for (String uri : uris) {
                Set<String> labelsOfUri = new HashSet();
                if (labels.containsKey(uri)) {
                    labelsOfUri = (Set)labels.get(uri);
                }
                int i = 0;
                while (i < RDFClientLabelRetriever.NAMING_PROPERTIES.length) {
                    try {
                        IteratorTripleString iterator = hdt.search((CharSequence)uri, (CharSequence)RDFClientLabelRetriever.NAMING_PROPERTIES[i], null);
                        while (iterator.hasNext()) {
                            TripleString triple = (TripleString)iterator.next();
                            if (!labels.containsKey(uri)) {
                                labels.put(uri, labelsOfUri);
                            }
                            labelsOfUri.add(triple.getObject().toString());
                        }
                    }
                    catch (NotFoundException e) {
                        LOGGER.debug("Did not found property {}", (Object)RDFClientLabelRetriever.NAMING_PROPERTIES[i]);
                    }
                    ++i;
                }
            }
            stringArray = LabelExtractionUtils.generateArray(labels);
        }
        catch (Exception e) {
            try {
                LOGGER.error("Couldn't read dump file \"" + hdtDumpFile + "\". Ignoring this dump.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(hdt);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)hdt);
            return null;
        }
        IOUtils.closeQuietly((Closeable)hdt);
        return stringArray;
    }
}

