/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.analyzer.hdt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import org.aksw.simba.tapioca.analyzer.hdt.HdtDumpFileAnalyzer;
import org.aksw.simba.tapioca.analyzer.hdt.HdtLabelExtractor;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdtExecution {
    private static final Logger LOGGER = LoggerFactory.getLogger(HdtExecution.class);
    private HdtDumpFileAnalyzer voidCreator = new HdtDumpFileAnalyzer();
    private HdtLabelExtractor labelExtractor = new HdtLabelExtractor();
    private String prefix;

    public HdtExecution() {
        this("");
    }

    public HdtExecution(String prefix) {
        this.prefix = prefix;
        File f = new File("void");
        f.mkdir();
    }

    public static void main(String[] args) {
        String prefix = "";
        if (args.length == 0) {
            System.out.println("Usage: hdt-laundromat-exec laundromat.tsv [folder of hdt files]");
            return;
        }
        if (args.length > 1) {
            prefix = args[1];
        }
        HdtExecution exec = new HdtExecution(prefix);
        exec.executeLaundromatTSV(args[0]);
    }

    public void executeLaundromatTSV(String fileName) {
        this.executeLaundromatTSV(new File(fileName));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeLaundromatTSV(File file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                try {
                    try (PrintWriter pw = new PrintWriter("tmp_laundromat.tsv");){
                        String line;
                        pw.print(reader.readLine().replaceAll("\\s+", "\t"));
                        pw.println("\tvoid file\tlabels file");
                        while ((line = reader.readLine()) != null) {
                            if (line.isEmpty()) continue;
                            String[] row = line.split("\t");
                            String hdtId = row[1];
                            String namespace = row[0];
                            Integer size = Integer.parseInt(row[3].replace("^^http://www.w3.org/2001/XMLSchema#integer", ""));
                            if (size == 0) {
                                LOGGER.warn("Size of HDT file with ID {} is empty. Will ignore it.", (Object)hdtId);
                                pw.println(line);
                                continue;
                            }
                            LOGGER.info("Will process HDT file {} ({})", (Object)hdtId, (Object)size);
                            try {
                                File voidFile = this.createVoid(hdtId, namespace);
                                Model voidModel = ModelFactory.createDefaultModel().read((Reader)new FileReader(voidFile), namespace, "TTL");
                                File labels = this.createLabel(hdtId, new File(String.valueOf(this.prefix) + hdtId + "?type=hdt"), voidModel);
                                pw.print(line);
                                StringBuilder b = new StringBuilder("\t");
                                b.append(voidFile.getAbsolutePath()).append("\t");
                                if (labels != null) {
                                    b.append(labels.getAbsolutePath());
                                }
                                pw.println(b.toString());
                            }
                            catch (IOException e) {
                                LOGGER.error("Could not read/write void model", (Throwable)e);
                            }
                            LOGGER.info("\rProccessed HDT file {} ({})", (Object)hdtId, (Object)size);
                        }
                        file.delete();
                        File newFile = new File("tmp_laundromat.tsv");
                        newFile.renameTo(file);
                    }
                    if (reader == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (reader == null) throw throwable;
                    reader.close();
                    throw throwable;
                }
                reader.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not read laundromat tsv file", (Throwable)e);
        }
    }

    public File createVoid(String id, String namespace) throws IOException {
        StringBuilder idBuilder = new StringBuilder(this.prefix).append(id).append("?type=hdt");
        File f = new File("void/" + id + ".ttl");
        if (f.exists()) {
            LOGGER.info("HDT {} void already exists. Will use old one.", (Object)id);
            return f;
        }
        Model voidModel = this.voidCreator.extractVoidInfo(namespace, idBuilder.toString());
        voidModel.write((Writer)new FileWriter(f), "TTL");
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File createLabel(String id, File hdtDumpFile, Model voidModel) {
        String outName = "void/" + id + "_labels.out";
        String[][] labels = this.labelExtractor.extractLabels(hdtDumpFile, voidModel);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try {
                FileOutputStream fileOut = new FileOutputStream(outName);
                try {
                    try (ObjectOutputStream out = new ObjectOutputStream(fileOut);){
                        out.writeObject(labels);
                    }
                    if (fileOut == null) return new File(outName);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fileOut == null) throw throwable;
                    fileOut.close();
                    throw throwable;
                }
                fileOut.close();
                return new File(outName);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return null;
        }
    }
}

