/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.analyzer.hdt;

import com.carrotsearch.hppc.ObjectIntOpenHashMap;
import com.carrotsearch.hppc.ObjectObjectOpenHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.aksw.simba.tapioca.analyzer.dump.AbstractDumpExtractorApplier;
import org.aksw.simba.tapioca.data.vocabularies.EVOID;
import org.aksw.simba.tapioca.data.vocabularies.VOID;
import org.aksw.simba.tapioca.extraction.Extractor;
import org.aksw.simba.tapioca.extraction.voidex.SpecialClassExtractor;
import org.aksw.simba.tapioca.extraction.voidex.VoidExtractor;
import org.aksw.simba.tapioca.extraction.voidex.VoidInformation;
import org.aksw.simba.tapioca.extraction.voidex.VoidParsingExtractor;
import org.apache.commons.io.IOUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdt.triples.IteratorTripleString;
import org.rdfhdt.hdt.triples.TripleString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdtDumpFileAnalyzer
extends AbstractDumpExtractorApplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(HdtDumpFileAnalyzer.class);

    public HdtDumpFileAnalyzer() {
        super(null);
    }

    public static void main(String[] args) throws IOException {
        HdtDumpFileAnalyzer analyzer = new HdtDumpFileAnalyzer();
        Model m = analyzer.extractVoidInfo("http://test.com/", "test.hdt");
        new File("out").createNewFile();
        m.write((OutputStream)new FileOutputStream("out.ttl"), "TTL");
    }

    public Model extractVoidInfo(String datsetUri, String ... dumps) {
        VoidExtractor extractor = new VoidExtractor();
        SpecialClassExtractor sExtractor = new SpecialClassExtractor();
        VoidParsingExtractor vpExtractor = new VoidParsingExtractor();
        int i = 0;
        while (i < dumps.length) {
            if (!this.extractFromDump(dumps[i], new Extractor[]{extractor, sExtractor, vpExtractor})) {
                LOGGER.error("Couldn't extract information from dump \"" + dumps[i] + "\". Returning null.");
                return null;
            }
            ++i;
        }
        this.addParsedVoidToCounts(extractor, vpExtractor);
        return this.generateVoidModel(datsetUri, extractor, sExtractor);
    }

    @Override
    protected boolean extractFromDump(String dump, Extractor ... extractors) {
        HDT hdt = null;
        try {
            hdt = HDTManager.loadIndexedHDT((String)dump, null);
            IteratorTripleString iterator = hdt.search(null, null, null);
            while (iterator.hasNext()) {
                Triple triple = this.transform((TripleString)iterator.next());
                if (triple == null) continue;
                int i = 0;
                while (i < extractors.length) {
                    extractors[i].handleTriple(triple);
                    ++i;
                }
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Couldn't read dump file \"" + dump + "\". Ignoring this dump.", (Throwable)e);
            return false;
        }
        finally {
            IOUtils.closeQuietly((Closeable)hdt);
        }
    }

    private Triple transform(TripleString t) {
        String temp = t.getSubject().toString();
        Node s = this.createUriNode(temp);
        if (s == null && (s = this.createAnonNode(temp)) == null) {
            LOGGER.error("Couldn't parse subject of \"" + t.toString() + "\". Returning null.");
            return null;
        }
        temp = t.getPredicate().toString();
        Node p = this.createUriNode(temp);
        if (p == null) {
            LOGGER.error("Couldn't parse predicate of \"" + t.toString() + "\". Returning null.");
            return null;
        }
        temp = t.getSubject().toString();
        Node o = this.createUriNode(temp);
        if (o == null && (o = this.createAnonNode(temp)) == null && (o = this.createLiteralNode(temp)) == null) {
            LOGGER.error("Couldn't parse object of \"" + t.toString() + "\". Returning null.");
            return null;
        }
        return new Triple(s, p, o);
    }

    private Node createUriNode(String n) {
        try {
            return NodeFactory.createURI((String)n);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Node createAnonNode(String n) {
        try {
            return NodeFactory.createBlankNode((String)n);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Node createLiteralNode(String n) {
        try {
            return NodeFactory.createLiteral((String)n);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Model generateVoidModel(String datsetUri, VoidExtractor extractor, SpecialClassExtractor sExtractor) {
        Model voidModel = ModelFactory.createDefaultModel();
        Resource datasetResource = voidModel.createResource(datsetUri);
        voidModel.add(datasetResource, RDF.type, (RDFNode)VOID.Dataset);
        long entities = this.addCountedUris((ObjectIntOpenHashMap<String>)extractor.getCountedClasses(), voidModel, datasetResource, VOID.classPartition, VOID.clazz, VOID.entities);
        this.addCountedUris((ObjectIntOpenHashMap<String>)sExtractor.getCountedSpecialClasses(), voidModel, datasetResource, EVOID.classPartition, EVOID.specialClass, EVOID.entities);
        voidModel.addLiteral(datasetResource, VOID.classes, extractor.getCountedClasses().assigned + sExtractor.getCountedSpecialClasses().assigned);
        voidModel.addLiteral(datasetResource, VOID.entities, entities);
        long triples = this.addCountedUris((ObjectIntOpenHashMap<String>)extractor.getCountedProperties(), voidModel, datasetResource, VOID.propertyPartition, VOID.property, VOID.triples);
        voidModel.addLiteral(datasetResource, VOID.properties, extractor.getCountedProperties().assigned);
        voidModel.addLiteral(datasetResource, VOID.triples, triples);
        if (entities == 0L && triples == 0L) {
            LOGGER.error("Got an empty VOID model without an entity and a triple. Returning null.");
            return null;
        }
        return voidModel;
    }

    protected long addCountedUris(ObjectIntOpenHashMap<String> countedUris, Model voidModel, Resource datasetResource, Property partitionProperty, Property uriProperty, Property countProperty) {
        long sum = 0L;
        int i = 0;
        while (i < countedUris.allocated.length) {
            if (countedUris.allocated[i]) {
                Resource blank = voidModel.createResource();
                voidModel.add(datasetResource, partitionProperty, (RDFNode)blank);
                voidModel.add(blank, uriProperty, (RDFNode)voidModel.createResource((String)countedUris.keys[i]));
                voidModel.add(blank, uriProperty, (RDFNode)voidModel.createResource((String)countedUris.keys[i]));
                voidModel.addLiteral(blank, countProperty, countedUris.values[i]);
                sum += (long)countedUris.values[i];
            }
            ++i;
        }
        return sum;
    }

    protected void addParsedVoidToCounts(VoidExtractor extractor, VoidParsingExtractor vpExtractor) {
        ObjectObjectOpenHashMap voidInfo = vpExtractor.getVoidInformation();
        ObjectIntOpenHashMap countedClasses = extractor.getCountedClasses();
        ObjectIntOpenHashMap countedProperties = extractor.getCountedProperties();
        int i = 0;
        while (i < voidInfo.allocated.length) {
            if (voidInfo.allocated[i]) {
                ((VoidInformation)voidInfo.values[i]).addToCount(countedClasses, countedProperties);
            }
            ++i;
        }
    }
}

