/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.analyzer.dump;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.aksw.simba.tapioca.analyzer.dump.DumpAnalyzingTask;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpLoadingTask
extends DumpAnalyzingTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(DumpLoadingTask.class);
    private static final String DOWNLOAD_FOLDER = "temp";
    private static final boolean ADD_FILE_ENDING_IF_MISSING = true;
    private static final String XML_CONTENT_TYPE = "application/xml";
    protected File downloadFolder;
    protected boolean loadingFinished = false;
    protected boolean addFileEndingIfMissing = true;

    public DumpLoadingTask(String datasetURI, File outputFolder, String[] dumps) {
        this(datasetURI, outputFolder, dumps, null);
    }

    public DumpLoadingTask(String datasetURI, File outputFolder, String[] dumps, ExecutorService executor) {
        super(datasetURI, outputFolder, dumps, executor);
        this.downloadFolder = DumpLoadingTask.generateDownloadFolder(outputFolder);
    }

    @Override
    public void run() {
        this.loadingFinished = false;
        this.loadDumps();
        this.loadingFinished = true;
        super.run();
    }

    protected void loadDumps() {
        DefaultHttpClient client = new DefaultHttpClient();
        if (!this.downloadFolder.exists()) {
            this.downloadFolder.mkdirs();
        }
        try {
            int i = 0;
            while (i < this.dumps.length) {
                File dumpFile = new File(String.valueOf(this.downloadFolder.getAbsolutePath()) + File.separator + DumpLoadingTask.extractFileName(this.dumps[i]));
                if (!dumpFile.exists()) {
                    LOGGER.info("Start loading dump \"" + this.dumps[i] + "\".");
                    try {
                        dumpFile = this.loadDump(this.dumps[i], dumpFile, (HttpClient)client);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Exception while trying to download dump from \"" + this.dumps[i] + "\".", e);
                    }
                } else {
                    LOGGER.info(String.valueOf(dumpFile.getAbsolutePath()) + " is already existing. It won't be downloaded.");
                }
                this.dumps[i] = dumpFile.getAbsolutePath();
                ++i;
            }
        }
        finally {
            HttpClientUtils.closeQuietly((HttpClient)client);
        }
    }

    protected File loadDump(String uri, File dumpFile, HttpClient client) throws ClientProtocolException, IOException {
        HttpGet hget = new HttpGet(uri);
        HttpResponse hres = client.execute((HttpUriRequest)hget);
        if (hres.getStatusLine().getStatusCode() >= 300) {
            throw new RuntimeException("Wrong HTTP status: " + hres.getStatusLine().toString());
        }
        HttpEntity hen = hres.getEntity();
        if (this.addFileEndingIfMissing) {
            dumpFile = this.checkDumpFileEnding(hres, dumpFile);
        }
        InputStream is = null;
        FileOutputStream fout = null;
        try {
            is = hen.getContent();
            fout = new FileOutputStream(dumpFile);
            IOUtils.copy((InputStream)is, (OutputStream)fout);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly(fout);
            EntityUtils.consume((HttpEntity)hen);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)fout);
        EntityUtils.consume((HttpEntity)hen);
        return dumpFile;
    }

    private File checkDumpFileEnding(HttpResponse hres, File dumpFile) {
        List fileExtensions;
        String filename = dumpFile.getName();
        boolean gzipped = false;
        if (filename.endsWith(".gz")) {
            filename = filename.substring(0, filename.length() - 3);
            gzipped = true;
        }
        Lang fileLanguage = RDFLanguages.resourceNameToLang((String)filename);
        Header header = hres.getFirstHeader("Content-Type");
        if (header == null) {
            LOGGER.warn("Couldn't get content type header from the response. Can't check dump file ending.");
            return dumpFile;
        }
        String contentType = header.getValue().split(";")[0];
        Lang responseLanguage = null;
        responseLanguage = XML_CONTENT_TYPE.equalsIgnoreCase(contentType) ? Lang.RDFXML : RDFLanguages.contentTypeToLang((String)header.getValue().split(";")[0]);
        if (responseLanguage == null) {
            LOGGER.info("Got an unknown content type inside the response. Can't check dump file ending.");
            return dumpFile;
        }
        if ((fileLanguage == null || responseLanguage != fileLanguage) && (fileExtensions = responseLanguage.getFileExtensions()) != null && fileExtensions.size() > 0) {
            filename = String.valueOf(filename) + '.' + (String)fileExtensions.get(0);
            LOGGER.info("Extended the dump file name from \"" + dumpFile.getName() + "\" to \"" + filename + "\".");
            return new File(String.valueOf(dumpFile.getParentFile().getAbsolutePath()) + File.separator + (gzipped ? String.valueOf(filename) + ".gz" : filename));
        }
        return dumpFile;
    }

    @Override
    public String getId() {
        return "Loading/Analyzing(" + this.datasetURI + ' ' + Arrays.toString(this.dumps) + ")";
    }

    @Override
    public String getProgress() {
        if (this.loadingFinished) {
            return "Analyzing dumps...";
        }
        return "Loading dumps...";
    }

    public static String extractFileName(String uri) {
        String[] splits = uri.split("[/#]");
        String uriEnding = null;
        int i = splits.length - 1;
        while (i >= 0 & uriEnding == null) {
            if (splits[i].length() > 0) {
                uriEnding = splits[i];
            }
            --i;
        }
        if (uriEnding == null) {
            LOGGER.warn("Couldn't extract file name from \"" + uri + "\".");
            return "TEMP";
        }
        if (uriEnding.contains("?")) {
            if (uri.startsWith("?")) {
                return DumpLoadingTask.extractFileName(uri.substring(0, uri.length() - uriEnding.length()));
            }
            uriEnding = uriEnding.split("\\?")[0];
        }
        return uriEnding;
    }

    public static File generateDownloadFolder(File outputFolder) {
        return new File(String.valueOf(outputFolder.getAbsolutePath()) + File.separator + DOWNLOAD_FOLDER);
    }
}

