/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.analyzer.dump;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.aksw.simba.tapioca.analyzer.dump.DumpFileLabelExtractor;
import org.aksw.simba.tapioca.analyzer.label.LabelExtractionUtils;
import org.dice_research.topicmodeling.commons.io.StorageHelper;
import org.dice_research.topicmodeling.concurrent.tasks.Task;

public class DumpLabelExtractionTask
implements Task {
    protected String[] dumps;
    protected File voidFile;
    protected File outputFile;
    protected DumpFileLabelExtractor extractor;

    public DumpLabelExtractionTask(String[] dumps, File voidFile, File outputFile) {
        this(dumps, voidFile, outputFile, null);
    }

    public DumpLabelExtractionTask(String[] dumps, File voidFile, File outputFile, ExecutorService executor) {
        this.dumps = dumps;
        this.voidFile = voidFile;
        this.outputFile = outputFile;
        this.extractor = executor != null ? new DumpFileLabelExtractor(executor) : new DumpFileLabelExtractor();
    }

    public void run() {
        Set<String> uris = LabelExtractionUtils.readUris(this.voidFile);
        if (uris == null) {
            return;
        }
        String[][] labels = this.extractor.extractLabels(uris, this.dumps);
        if (labels != null) {
            StorageHelper.storeToFileSavely((Serializable)labels, (String)this.outputFile.getAbsolutePath());
            labels = null;
        }
    }

    public String getId() {
        return "LabelExtraction" + Arrays.toString(this.dumps);
    }

    public String getProgress() {
        return "";
    }
}

