/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.analyzer.dump;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Writer;
import org.aksw.simba.tapioca.analyzer.dump.DumpFileAnalyzer;
import org.aksw.simba.tapioca.analyzer.dump.DumpFileLabelExtractor;
import org.aksw.simba.tapioca.analyzer.label.LabelExtractionUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpFileExecution {
    private static final Logger LOGGER = LoggerFactory.getLogger(DumpFileExecution.class);
    private DumpFileAnalyzer voidCreator = new DumpFileAnalyzer();
    private DumpFileLabelExtractor labelExtractor = new DumpFileLabelExtractor();

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: DumpFileExecution input-directory output-directory label-directory");
            return;
        }
        File outputDir = new File(args[1]);
        outputDir.mkdir();
        File labelDir = new File(args[2]);
        labelDir.mkdir();
        DumpFileExecution exec = new DumpFileExecution();
        exec.analyze(args[0], outputDir, labelDir);
    }

    public void analyze(String fileName, File outputDir, File labelDir) {
        this.analyze(new File(fileName), outputDir, labelDir);
    }

    public void analyze(File file, File outputDir, File labelDir) {
        if (!file.exists()) {
            LOGGER.error("The given file \"" + file.getAbsolutePath() + "\" does not exist. Aborting.");
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.analyze(f, outputDir, labelDir);
                ++n2;
            }
        } else {
            LOGGER.info("Will process file {}", (Object)file);
            try {
                Model voidModel = this.createVoid(file.getAbsolutePath(), new File(String.valueOf(outputDir.getAbsolutePath()) + File.separator + file.getName() + ".ttl"));
                this.createLabel(String.valueOf(labelDir.getAbsolutePath()) + File.separator + file.getName() + ".object", file, voidModel);
            }
            catch (IOException e) {
                LOGGER.error("Could not read/write void model", (Throwable)e);
            }
            LOGGER.info("Proccessed file {}", (Object)file);
        }
    }

    public Model createVoid(String dumpFile, File outputFile) throws IOException {
        if (outputFile.exists()) {
            LOGGER.info("{} void already exists. Will use old one.", (Object)outputFile);
            return ModelFactory.createDefaultModel().read((Reader)new FileReader(outputFile), "", "TTL");
        }
        Model voidModel = this.voidCreator.extractVoidInfo(dumpFile, dumpFile);
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileWriter writer = new FileWriter(outputFile);){
            voidModel.write((Writer)writer, "TTL");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return voidModel;
    }

    public File createLabel(String labelOutName, File dumpFile, Model voidModel) {
        String[][] labels = this.labelExtractor.extractLabels(LabelExtractionUtils.readUris(voidModel), dumpFile.getAbsolutePath());
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(labelOutName));){
                out.writeObject(labels);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return null;
        }
        return new File(labelOutName);
    }
}

