/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.analyzer.dump;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import org.aksw.simba.tapioca.analyzer.dump.DumpFileAnalyzer;
import org.apache.commons.io.IOUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.dice_research.topicmodeling.concurrent.tasks.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpAnalyzingTask
implements Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(DumpAnalyzingTask.class);
    protected String datasetURI;
    protected File outputFolder;
    protected String[] dumps;
    protected DumpFileAnalyzer analyzer;

    public DumpAnalyzingTask(String datasetURI, File outputFolder, String[] dumps) {
        this(datasetURI, outputFolder, dumps, null);
    }

    public DumpAnalyzingTask(String datasetURI, File outputFolder, String[] dumps, ExecutorService executor) {
        this.datasetURI = datasetURI;
        this.outputFolder = outputFolder;
        this.dumps = dumps;
        this.analyzer = executor != null ? new DumpFileAnalyzer(executor) : new DumpFileAnalyzer();
    }

    public void run() {
        Model model = this.analyzer.extractVoidInfo(this.datasetURI, this.dumps);
        if (model != null) {
            this.writeModel(model);
        }
    }

    public String getId() {
        return "Analyzing(" + this.datasetURI + ' ' + Arrays.toString(this.dumps) + ")";
    }

    public String getProgress() {
        return "Analyzing dumps...";
    }

    private void writeModel(Model voidModel) {
        block5: {
            FileOutputStream fout = null;
            try {
                try {
                    fout = new FileOutputStream(this.outputFolder + File.separator + "void.ttl");
                    RDFDataMgr.write((OutputStream)fout, (Model)voidModel, (Lang)Lang.TTL);
                }
                catch (Exception e) {
                    LOGGER.error("", (Throwable)e);
                    IOUtils.closeQuietly(fout);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fout);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fout);
        }
    }
}

