/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.analyzer.dump;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import org.aksw.simba.tapioca.extraction.Extractor;
import org.aksw.simba.tapioca.extraction.RDF2ExtractionStreamer;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.IOUtils;
import org.apache.jena.riot.RDFLanguages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDumpExtractorApplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDumpExtractorApplier.class);
    private static final String[][] FILE_ENDING_COMPRESSION_MAPPING = new String[][]{{".gz", "gz"}, {".bz2", "bzip2"}};
    protected ExecutorService executor = null;
    protected CompressorStreamFactory compStreamFactory = new CompressorStreamFactory();

    public AbstractDumpExtractorApplier(ExecutorService executor) {
        this.executor = executor;
    }

    protected boolean extractFromDump(String dump, Extractor ... extractors) {
        boolean bl;
        RDF2ExtractionStreamer streamer = this.executor != null ? new RDF2ExtractionStreamer(this.executor) : new RDF2ExtractionStreamer();
        FileInputStream in = null;
        try {
            in = new FileInputStream(dump);
            int compressionMethod = this.getCompressionMethod(dump);
            while (compressionMethod >= 0) {
                in = this.compStreamFactory.createCompressorInputStream(FILE_ENDING_COMPRESSION_MAPPING[compressionMethod][1], (InputStream)in);
                dump = dump.substring(0, dump.length() - FILE_ENDING_COMPRESSION_MAPPING[compressionMethod][0].length());
                compressionMethod = this.getCompressionMethod(dump);
            }
            bl = streamer.runExtraction((InputStream)in, "", RDFLanguages.resourceNameToLang((String)dump), extractors);
        }
        catch (Exception e) {
            try {
                LOGGER.error("Couldn't read dump file \"" + dump + "\". Ignoring this dump.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            return false;
        }
        IOUtils.closeQuietly((InputStream)in);
        return bl;
    }

    protected int getCompressionMethod(String fileName) {
        int i = 0;
        while (i < FILE_ENDING_COMPRESSION_MAPPING.length) {
            if (fileName.endsWith(FILE_ENDING_COMPRESSION_MAPPING[i][0])) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

