/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.analyzer;

import java.io.File;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.aksw.simba.tapioca.analyzer.dump.DumpLabelExtractionTask;
import org.aksw.simba.tapioca.analyzer.label.LabelExtractionUtils;
import org.aksw.simba.tapioca.analyzer.sparql.EndpointAnalyzingTask;
import org.aksw.simba.tapioca.analyzer.sparql.EndpointConfig;
import org.aksw.simba.tapioca.analyzer.sparql.SPARQLEndpointLabelExtractor;
import org.dice_research.topicmodeling.commons.io.StorageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointLabelExtractionTaskWithDumpBackup
extends DumpLabelExtractionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointAnalyzingTask.class);
    private EndpointConfig endpointCfg;
    private String cacheDirectory;
    private boolean analyzingEndpoint = true;

    public EndpointLabelExtractionTaskWithDumpBackup(EndpointConfig endpointCfg, File voidFile, File outputFile, String[] dumps, String cacheDirectory) {
        super(dumps, voidFile, outputFile);
        this.endpointCfg = endpointCfg;
        this.cacheDirectory = cacheDirectory;
    }

    public EndpointLabelExtractionTaskWithDumpBackup(EndpointConfig endpointCfg, File voidFile, File outputFile, String[] dumps, ExecutorService executor, String cacheDirectory) {
        super(dumps, voidFile, outputFile, executor);
        this.endpointCfg = endpointCfg;
        this.cacheDirectory = cacheDirectory;
    }

    @Override
    public void run() {
        block10: {
            LOGGER.info("Starting extraction from \"" + this.endpointCfg.uri + "\"...");
            try {
                if (this.outputFile.exists()) {
                    LOGGER.info("There already is a file for \"" + this.endpointCfg.uri + "\". Jumping over this endpoint.");
                    return;
                }
                Set<String> uris = LabelExtractionUtils.readUris(this.voidFile);
                if (uris == null) {
                    return;
                }
                try {
                    SPARQLEndpointLabelExtractor extractor = new SPARQLEndpointLabelExtractor(this.cacheDirectory);
                    String[][] labels = extractor.requestLabels(uris, this.endpointCfg);
                    if (labels != null) {
                        StorageHelper.storeToFileSavely((Serializable)labels, (String)this.outputFile.getAbsolutePath());
                        labels = null;
                        break block10;
                    }
                    LOGGER.error("Error while requesting the void information of \"" + this.endpointCfg.uri + "\". Trying to use the dump.");
                    super.run();
                }
                catch (Exception e) {
                    LOGGER.error("Error while requesting and storing the void information of \"" + this.endpointCfg.uri + "\".", (Throwable)e);
                }
            }
            finally {
                LOGGER.info("Finished extraction from \"" + this.endpointCfg.uri + "\"...");
            }
        }
    }

    @Override
    public String getProgress() {
        if (this.analyzingEndpoint) {
            return "analyzing endpoint...";
        }
        return super.getProgress();
    }
}

