/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.tapioca.analyzer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.aksw.simba.tapioca.analyzer.dump.DumpLoadingTask;
import org.aksw.simba.tapioca.analyzer.sparql.EndpointAnalyzingTask;
import org.aksw.simba.tapioca.analyzer.sparql.EndpointConfig;
import org.aksw.simba.tapioca.analyzer.sparql.SPARQLEndpointAnalyzer;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointAnalyzingTaskWithDumpBackup
extends DumpLoadingTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointAnalyzingTask.class);
    private EndpointConfig endpointCfg;
    private String cacheDirectory;
    private boolean analyzingEndpoint = true;

    public EndpointAnalyzingTaskWithDumpBackup(EndpointConfig endpointCfg, String datasetURI, File outputFolder, String[] dumps, String cacheDirectory) {
        super(datasetURI, outputFolder, dumps);
        this.endpointCfg = endpointCfg;
        this.cacheDirectory = cacheDirectory;
    }

    public EndpointAnalyzingTaskWithDumpBackup(EndpointConfig endpointCfg, String datasetURI, File outputFolder, String[] dumps, ExecutorService executor, String cacheDirectory) {
        super(datasetURI, outputFolder, dumps, executor);
        this.endpointCfg = endpointCfg;
        this.cacheDirectory = cacheDirectory;
    }

    @Override
    public void run() {
        block8: {
            LOGGER.info("Starting extraction from \"" + this.datasetURI + "\"...");
            SPARQLEndpointAnalyzer analyzer = new SPARQLEndpointAnalyzer(this.cacheDirectory);
            File outputFile = new File(String.valueOf(this.outputFolder.getAbsolutePath()) + File.separator + "void.ttl");
            try {
                if (outputFile.exists()) {
                    LOGGER.info("There already is a file for \"" + this.datasetURI + "\". Jumping over this endpoint.");
                    return;
                }
                try {
                    Model voidModel = analyzer.extractVoidInfo(this.endpointCfg);
                    if (voidModel != null) {
                        voidModel.setNsPrefix("void", "http://rdfs.org/ns/void#");
                        FileOutputStream fout = new FileOutputStream(outputFile);
                        RDFDataMgr.write((OutputStream)fout, (Model)voidModel, (RDFFormat)RDFFormat.TURTLE_PRETTY);
                        fout.close();
                        break block8;
                    }
                    LOGGER.error("Error while requesting the void information of \"" + this.datasetURI + "\". Trying to use the dump.");
                    super.run();
                }
                catch (Exception e) {
                    LOGGER.error("Error while requesting and storing the void information of \"" + this.datasetURI + "\".", (Throwable)e);
                }
            }
            finally {
                LOGGER.info("Finished extraction from \"" + this.datasetURI + "\"...");
            }
        }
    }

    @Override
    public String getProgress() {
        if (this.analyzingEndpoint) {
            return "analyzing endpoint...";
        }
        return super.getProgress();
    }
}

