/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.verbalizer;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.aksw.avatar.clustering.BorderFlowX;
import org.aksw.avatar.clustering.WeightedGraph;
import org.aksw.avatar.clustering.hardening.HardeningFactory;
import org.aksw.avatar.dataset.CachedDatasetBasedGraphGenerator;
import org.aksw.avatar.dataset.DatasetBasedGraphGenerator;
import org.aksw.avatar.exceptions.NoGraphAvailableException;
import org.aksw.avatar.rules.DateLiteralFilter;
import org.aksw.avatar.rules.NumericLiteralFilter;
import org.aksw.avatar.rules.ObjectMergeRule;
import org.aksw.avatar.rules.PredicateMergeRule;
import org.aksw.avatar.rules.SubjectMergeRule;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.sparql2nl.naturallanguagegeneration.SimpleNLGwithPostprocessing;
import org.aksw.triple2nl.gender.DictionaryBasedGenderDetector;
import org.aksw.triple2nl.gender.GenderDetector;
import org.aksw.triple2nl.gender.TypeAwareGenderDetector;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;
import org.apache.log4j.Logger;
import org.dllearner.kb.sparql.SparqlEndpoint;
import org.dllearner.utilities.MapUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLIndividual;
import simplenlg.features.Gender;
import simplenlg.features.NumberAgreement;
import simplenlg.framework.CoordinatedPhraseElement;
import simplenlg.framework.NLGElement;
import simplenlg.phrasespec.NPPhraseSpec;
import simplenlg.phrasespec.SPhraseSpec;
import simplenlg.realiser.english.Realiser;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLNamedIndividualImpl;

public class Verbalizer {
    private static final Logger logger = Logger.getLogger((String)Verbalizer.class.getName());
    private static String DEFAULT_CACHE_BASE_DIR = System.getProperty("java.io.tmpdir");
    private static final double DEFAULT_THRESHOLD = 0.4;
    private static final int DEFAULT_MAX_NUMBER_OF_SHOWN_VALUES_PER_PROPERTY = 5;
    private static final DatasetBasedGraphGenerator.Cooccurrence DEFAULT_COOCCURRENCE_TYPE = DatasetBasedGraphGenerator.Cooccurrence.PROPERTIES;
    private static final HardeningFactory.HardeningType DEFAULT_HARDENING_TYPE = HardeningFactory.HardeningType.SMALLEST;
    public SimpleNLGwithPostprocessing nlg;
    SparqlEndpoint endpoint;
    String language = "en";
    protected Realiser realiser;
    Map<Resource, String> labels;
    NumericLiteralFilter litFilter;
    TypeAwareGenderDetector gender;
    public Map<Resource, Collection<Triple>> resource2Triples;
    private QueryExecutionFactory qef;
    private String cacheDirectory = "cache/sparql";
    PredicateMergeRule pr;
    ObjectMergeRule or;
    SubjectMergeRule sr;
    public DatasetBasedGraphGenerator graphGenerator;
    int maxShownValuesPerProperty = 5;
    boolean omitContentInBrackets = true;

    public Verbalizer(QueryExecutionFactory qef, String cacheDirectory) {
        this.qef = qef;
        if (cacheDirectory == null) {
            cacheDirectory = DEFAULT_CACHE_BASE_DIR;
        }
        cacheDirectory = new File(cacheDirectory, "avatar-cache/sparql").getAbsolutePath();
        this.nlg = new SimpleNLGwithPostprocessing(qef, cacheDirectory, null);
        this.labels = new HashMap<Resource, String>();
        this.litFilter = new NumericLiteralFilter(qef, cacheDirectory);
        this.realiser = this.nlg.realiser;
        this.pr = new PredicateMergeRule(this.nlg.lexicon, this.nlg.nlgFactory, this.nlg.realiser);
        this.or = new ObjectMergeRule(this.nlg.lexicon, this.nlg.nlgFactory, this.nlg.realiser);
        this.sr = new SubjectMergeRule(this.nlg.lexicon, this.nlg.nlgFactory, this.nlg.realiser);
        this.gender = new TypeAwareGenderDetector(qef, (GenderDetector)new DictionaryBasedGenderDetector());
        this.graphGenerator = new CachedDatasetBasedGraphGenerator(qef, cacheDirectory);
    }

    public Verbalizer(SparqlEndpoint endpoint, String cacheDirectory) {
        this((QueryExecutionFactory)new QueryExecutionFactoryHttp(endpoint.getURL().toString(), (Collection)endpoint.getDefaultGraphURIs()), cacheDirectory);
    }

    public Verbalizer(SparqlEndpoint endpoint) {
        this(endpoint, DEFAULT_CACHE_BASE_DIR);
    }

    public void setPropertiesBlacklist(Set<String> blacklist) {
        this.graphGenerator.setPropertiesBlacklist(blacklist);
    }

    public void setPersonTypes(Set<String> personTypes) {
        this.gender.setPersonTypes(personTypes);
    }

    public void setOmitContentInBrackets(boolean omitContentInBrackets) {
        this.omitContentInBrackets = omitContentInBrackets;
    }

    public Set<Triple> getTriples(Resource r, Property p, boolean outgoing) {
        HashSet<Triple> result = new HashSet<Triple>();
        try {
            String q = outgoing ? "SELECT ?o where { <" + r.getURI() + "> <" + p.getURI() + "> ?o." + "?o rdfs:label []}" : "SELECT ?o where { ?o <" + p.getURI() + "> <" + r.getURI() + ">." + "?o rdfs:label []}";
            q = q + " LIMIT " + this.maxShownValuesPerProperty + 1;
            QueryExecution qe = this.qef.createQueryExecution(q);
            ResultSet results = qe.execSelect();
            if (results.hasNext()) {
                while (results.hasNext()) {
                    RDFNode n = results.next().get("o");
                    result.add(Triple.create((Node)r.asNode(), (Node)p.asNode(), (Node)n.asNode()));
                }
            }
            qe.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Set<org.aksw.avatar.clustering.Node> getSummaryProperties(OWLClass cls, double threshold, String namespace, DatasetBasedGraphGenerator.Cooccurrence cooccurrence) {
        HashSet properties = new HashSet();
        try {
            WeightedGraph wg = this.graphGenerator.generateGraph(cls, threshold, namespace, cooccurrence);
            return wg.getNodes().keySet();
        }
        catch (NoGraphAvailableException e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    public String realize(List<Set<org.aksw.avatar.clustering.Node>> properties, Resource resource, OWLClass nc) {
        List<NLGElement> elts = this.generateSentencesFromClusters(properties, resource, nc);
        return this.realize(elts);
    }

    public String realize(List<NLGElement> elts) {
        if (elts.isEmpty()) {
            return null;
        }
        String realization = "";
        for (NLGElement elt : elts) {
            realization = realization + this.realiser.realiseSentence(elt) + " ";
        }
        return realization.substring(0, realization.length() - 1);
    }

    public List<NLGElement> generateSentencesFromClusters(List<Set<org.aksw.avatar.clustering.Node>> clusters, Resource resource, OWLClass OWLClass2) {
        return this.generateSentencesFromClusters(clusters, resource, OWLClass2, false);
    }

    public List<NLGElement> generateSentencesFromClusters(List<Set<org.aksw.avatar.clustering.Node>> clusters, Resource resource, OWLClass namedClass, boolean replaceSubjects) {
        org.aksw.triple2nl.gender.Gender g = this.getGender(resource);
        List<NPPhraseSpec> subjects = this.generateSubjects(resource, namedClass, g);
        ArrayList<NLGElement> result = new ArrayList<NLGElement>();
        ArrayList<Object> allTriples = new ArrayList<Object>();
        DateLiteralFilter dateFilter = new DateLiteralFilter();
        for (Set<org.aksw.avatar.clustering.Node> propertySet : clusters) {
            Set<Object> triples = new HashSet();
            ArrayList buffer = new ArrayList();
            for (org.aksw.avatar.clustering.Node property : propertySet) {
                triples = this.getTriples(resource, ResourceFactory.createProperty((String)property.label), property.outgoing);
                this.litFilter.filter(triples);
                dateFilter.filter(triples);
                boolean subsetShown = false;
                if (triples.size() > this.maxShownValuesPerProperty) {
                    triples = this.getSubsetToShow(triples);
                    subsetShown = true;
                }
                List<SPhraseSpec> phraseSpecs = this.getPhraseSpecsFromTriples(triples, property.outgoing);
                buffer.addAll(this.or.apply(phraseSpecs, subsetShown));
                allTriples.addAll(triples);
            }
            List mergedElement = this.sr.apply(this.or.apply(buffer), g);
            result.addAll(mergedElement);
        }
        this.resource2Triples.put(resource, allTriples);
        ArrayList<NLGElement> phrases = new ArrayList<NLGElement>();
        if (replaceSubjects) {
            for (NLGElement phrase : result) {
                NLGElement replacedPhrase = this.replaceSubject(phrase, subjects, g);
                phrases.add(replacedPhrase);
            }
            return phrases;
        }
        return result;
    }

    private Set<Triple> getSubsetToShow(Set<Triple> triples) {
        HashSet<Triple> triplesToShow = new HashSet<Triple>(this.maxShownValuesPerProperty);
        for (Triple triple : this.sortByObjectPopularity(triples)) {
            if (triplesToShow.size() >= this.maxShownValuesPerProperty) continue;
            triplesToShow.add(triple);
        }
        return triplesToShow;
    }

    private List<Triple> sortByObjectPopularity(Set<Triple> triples) {
        ArrayList<Triple> orderedTriples = new ArrayList<Triple>();
        if (triples.iterator().next().getObject().isLiteral()) {
            orderedTriples.addAll(triples);
        } else {
            HashMap<Triple, Integer> triple2ObjectPopularity = new HashMap<Triple, Integer>();
            for (Triple triple : triples) {
                if (!triple.getObject().isURI()) continue;
                String query = "SELECT (COUNT(*) AS ?cnt) WHERE {<" + triple.getObject().getURI() + "> ?p ?o.}";
                QueryExecution qe = this.qef.createQueryExecution(query);
                try {
                    ResultSet rs = qe.execSelect();
                    int popularity = rs.next().getLiteral("cnt").getInt();
                    triple2ObjectPopularity.put(triple, popularity);
                    qe.close();
                }
                catch (Exception e) {
                    logger.warn((Object)("Execution of SPARQL query failed: " + e.getMessage() + "\n" + query));
                }
            }
            List sortedByValues = MapUtils.sortByValues(triple2ObjectPopularity);
            for (Map.Entry entry : sortedByValues) {
                Triple triple = (Triple)entry.getKey();
                orderedTriples.add(triple);
            }
        }
        return orderedTriples;
    }

    public Collection<Triple> getSummaryTriples(Resource resource) {
        return this.resource2Triples.get(resource);
    }

    public Collection<Triple> getSummaryTriples(OWLIndividual individual) {
        return this.getSummaryTriples(ResourceFactory.createResource((String)individual.toStringID()));
    }

    public List<NLGElement> generateSentencesFromTriples(Set<Triple> triples, boolean outgoing, org.aksw.triple2nl.gender.Gender g) {
        return this.applyMergeRules(this.getPhraseSpecsFromTriples(triples, outgoing), g);
    }

    public List<SPhraseSpec> getPhraseSpecsFromTriples(Set<Triple> triples, boolean outgoing) {
        ArrayList<SPhraseSpec> phrases = new ArrayList<SPhraseSpec>();
        for (Triple t : triples) {
            SPhraseSpec phrase = this.generateSimplePhraseFromTriple(t, outgoing);
            phrases.add(phrase);
        }
        return phrases;
    }

    public List<NLGElement> applyMergeRules(List<SPhraseSpec> triples, org.aksw.triple2nl.gender.Gender g) {
        List<Object> phrases = new ArrayList<SPhraseSpec>();
        phrases.addAll(triples);
        int newSize = phrases.size();
        int oldSize = phrases.size() + 1;
        if (newSize > 1) {
            while (newSize < oldSize) {
                oldSize = newSize;
                int orCount = this.or.isApplicable(phrases);
                int prCount = this.pr.isApplicable(phrases);
                if (prCount > 0 || orCount > 0) {
                    phrases = prCount > orCount ? this.pr.apply(phrases) : this.or.apply(phrases);
                }
                newSize = phrases.size();
            }
        }
        return this.sr.apply(phrases, g);
    }

    public SPhraseSpec generateSimplePhraseFromTriple(Triple triple) {
        return this.nlg.getNLForTriple(triple);
    }

    public SPhraseSpec generateSimplePhraseFromTriple(Triple triple, boolean outgoing) {
        return this.nlg.getNLForTriple(triple, outgoing);
    }

    public List<NLGElement> verbalize(OWLIndividual ind, OWLClass nc, String namespace, double threshold, DatasetBasedGraphGenerator.Cooccurrence cooccurrence, HardeningFactory.HardeningType hType) {
        return this.verbalize(Sets.newHashSet((Object[])new OWLIndividual[]{ind}), nc, namespace, threshold, cooccurrence, hType).get(ind);
    }

    public Map<OWLIndividual, List<NLGElement>> verbalize(Set<OWLIndividual> individuals, OWLClass nc, String namespace, double threshold, DatasetBasedGraphGenerator.Cooccurrence cooccurrence, HardeningFactory.HardeningType hType) {
        this.resource2Triples = new HashMap<Resource, Collection<Triple>>();
        try {
            WeightedGraph wg = this.graphGenerator.generateGraph(nc, threshold, namespace, cooccurrence);
            BorderFlowX bf = new BorderFlowX(wg);
            Set clusters = bf.cluster();
            List sortedPropertyClusters = HardeningFactory.getHardening((HardeningFactory.HardeningType)hType).harden(clusters, wg);
            HashMap<OWLIndividual, List<NLGElement>> verbalizations = new HashMap<OWLIndividual, List<NLGElement>>();
            for (OWLIndividual ind : individuals) {
                List<NLGElement> result = this.generateSentencesFromClusters(sortedPropertyClusters, ResourceFactory.createResource((String)ind.toStringID()), nc, true);
                Triple t = Triple.create((Node)ResourceFactory.createResource((String)ind.toStringID()).asNode(), (Node)ResourceFactory.createProperty((String)RDF.type.getURI()).asNode(), (Node)ResourceFactory.createResource((String)nc.toStringID()).asNode());
                Collections.reverse(result);
                result.add((NLGElement)this.generateSimplePhraseFromTriple(t));
                Collections.reverse(result);
                verbalizations.put(ind, result);
                this.resource2Triples.get(ResourceFactory.createResource((String)ind.toStringID())).add(t);
            }
            return verbalizations;
        }
        catch (NoGraphAvailableException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String summarize(OWLIndividual individual) {
        OWLClass cls = this.getMostSpecificType(individual);
        return this.summarize(individual, cls);
    }

    public String summarize(OWLIndividual individual, OWLClass nc) {
        return this.getSummary(individual, nc, 0.4, DEFAULT_COOCCURRENCE_TYPE, DEFAULT_HARDENING_TYPE);
    }

    public String getSummary(OWLIndividual individual, OWLClass nc, double threshold, DatasetBasedGraphGenerator.Cooccurrence cooccurrence, HardeningFactory.HardeningType hType) {
        List<NLGElement> elements = this.verbalize(individual, nc, null, threshold, cooccurrence, hType);
        String summary = this.realize(elements);
        summary = summary.replaceAll("\\s?\\((.*?)\\)", "");
        summary = summary.replace(" , among others,", ", among others,");
        return summary;
    }

    public Map<OWLIndividual, String> getSummaries(Set<OWLIndividual> individuals, OWLClass nc, String namespace, double threshold, DatasetBasedGraphGenerator.Cooccurrence cooccurrence, HardeningFactory.HardeningType hType) {
        HashMap<OWLIndividual, String> entity2Summaries = new HashMap<OWLIndividual, String>();
        Map<OWLIndividual, List<NLGElement>> verbalize = this.verbalize(individuals, nc, namespace, threshold, cooccurrence, hType);
        for (Map.Entry<OWLIndividual, List<NLGElement>> entry : verbalize.entrySet()) {
            OWLIndividual individual = entry.getKey();
            List<NLGElement> elements = entry.getValue();
            String summary = this.realize(elements);
            summary = summary.replaceAll("\\s?\\((.*?)\\)", "");
            summary = summary.replace(" , among others,", ", among others,");
            entity2Summaries.put(individual, summary);
        }
        return entity2Summaries;
    }

    private OWLClass getMostSpecificType(OWLIndividual ind) {
        logger.debug((Object)("Getting the most specific type of " + ind));
        String query = String.format("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nselect distinct ?type where { <%s> a ?type .?type rdfs:label [].filter not exists {?subtype ^a <%s> ; rdfs:subClassOf ?type .filter(?subtype != ?type)}}", ind.toStringID(), ind.toStringID());
        TreeSet<OWLClassImpl> types = new TreeSet<OWLClassImpl>();
        QueryExecution qe = this.qef.createQueryExecution(query);
        ResultSet rs = qe.execSelect();
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            if (!qs.get("type").isURIResource()) continue;
            types.add(new OWLClassImpl(IRI.create((String)qs.getResource("type").getURI())));
        }
        qe.close();
        return (OWLClass)types.first();
    }

    public List<NPPhraseSpec> generateSubjects(Resource resource, OWLClass resourceType, org.aksw.triple2nl.gender.Gender resourceGender) {
        ArrayList<NPPhraseSpec> result = new ArrayList<NPPhraseSpec>();
        result.add(this.nlg.getNPPhrase(resource.getURI(), false, false));
        NPPhraseSpec np = this.nlg.getNPPhrase(resourceType.toStringID(), false);
        np.addPreModifier("This");
        result.add(np);
        if (resourceGender.equals((Object)org.aksw.triple2nl.gender.Gender.MALE)) {
            result.add(this.nlg.nlgFactory.createNounPhrase((Object)"he"));
        } else if (resourceGender.equals((Object)org.aksw.triple2nl.gender.Gender.FEMALE)) {
            result.add(this.nlg.nlgFactory.createNounPhrase((Object)"she"));
        } else {
            result.add(this.nlg.nlgFactory.createNounPhrase((Object)"it"));
        }
        return result;
    }

    public org.aksw.triple2nl.gender.Gender getGender(Resource resource) {
        String label = this.realiser.realiseSentence((NLGElement)this.nlg.getNPPhrase(resource.getURI(), false, false));
        String firstToken = label.split(" ")[0];
        org.aksw.triple2nl.gender.Gender g = this.gender.getGender(resource.getURI(), firstToken);
        return g;
    }

    public void setMaxShownValuesPerProperty(int maxShownValuesPerProperty) {
        this.maxShownValuesPerProperty = maxShownValuesPerProperty;
    }

    protected NLGElement replaceSubject(NLGElement phrase, List<NPPhraseSpec> subjects, org.aksw.triple2nl.gender.Gender g) {
        SPhraseSpec sphrase;
        if (phrase instanceof SPhraseSpec) {
            sphrase = (SPhraseSpec)phrase;
        } else if (phrase instanceof CoordinatedPhraseElement) {
            sphrase = (SPhraseSpec)phrase.getChildren().get(0);
        } else {
            return phrase;
        }
        int index = (int)Math.floor(Math.random() * (double)subjects.size());
        Gender genderFeature = g.equals((Object)org.aksw.triple2nl.gender.Gender.MALE) ? Gender.MASCULINE : (g.equals((Object)org.aksw.triple2nl.gender.Gender.FEMALE) ? Gender.FEMININE : Gender.NEUTER);
        NLGElement currentSubject = sphrase.getSubject();
        if (currentSubject.hasFeature("specifier") && currentSubject.getFeatureAsElement("specifier").getFeatureAsBoolean("possessive").booleanValue()) {
            NPPhraseSpec newSubject = this.nlg.nlgFactory.createNounPhrase((Object)((NPPhraseSpec)currentSubject).getHead());
            NPPhraseSpec newSpecifier = this.nlg.nlgFactory.createNounPhrase((Object)subjects.get(index));
            newSpecifier.setFeature("possessive", true);
            newSubject.setSpecifier((Object)newSpecifier);
            if (index >= subjects.size() - 1) {
                newSpecifier.setFeature("gender", (Object)genderFeature);
                newSpecifier.setFeature("pronominal", true);
            }
            if (currentSubject.isPlural()) {
                newSubject.setPlural(true);
                newSpecifier.setFeature("number", (Object)NumberAgreement.SINGULAR);
            }
            sphrase.setSubject((Object)newSubject);
        } else {
            currentSubject.setFeature("pronominal", true);
            currentSubject.setFeature("gender", (Object)genderFeature);
        }
        return phrase;
    }

    public static void main(String[] args) throws IOException {
        OptionParser parser = new OptionParser(){
            {
                this.acceptsAll(Lists.newArrayList((Object[])new String[]{"e", "endpoint"}), "SPARQL endpoint URL to be used.").withRequiredArg().ofType(URL.class).required();
                this.acceptsAll(Lists.newArrayList((Object[])new String[]{"g", "graph"}), "URI of default graph for queries on SPARQL endpoint.").withRequiredArg().ofType(String.class);
                this.acceptsAll(Lists.newArrayList((Object[])new String[]{"i", "individual"}), "The URI of the entity to summarize.").withRequiredArg().ofType(URI.class).required();
                this.acceptsAll(Lists.newArrayList((Object[])new String[]{"c", "class"}), "Optionally, you can specify a class which is supposed to be the most common type of the entity to summarize.").withRequiredArg().ofType(URI.class);
                this.acceptsAll(Lists.newArrayList((Object[])new String[]{"p", "persontypes"}), "Optionally, you can specify the classes that denote persons in your knowledge base.").withRequiredArg().ofType(String.class);
                this.acceptsAll(Lists.newArrayList((Object[])new String[]{"cache"}), "Path to cache directory. If not set, the operating system temporary directory will be used.").withRequiredArg().defaultsTo((Object)System.getProperty("java.io.tmpdir"), (Object[])new String[0]);
                this.acceptsAll(Lists.newArrayList((Object[])new String[]{"h", "?"}), "show help").forHelp();
            }
        };
        parser.printHelpOn((OutputStream)System.out);
        OptionSet options = null;
        try {
            options = parser.parse(args);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage() + ". Use -? to get help.");
            System.exit(0);
        }
        if (options.has("?")) {
            parser.printHelpOn((OutputStream)System.out);
        }
        URL endpointURL = null;
        try {
            endpointURL = (URL)options.valueOf("endpoint");
        }
        catch (OptionException e) {
            System.out.println("The specified endpoint appears not be a proper URL.");
            System.exit(0);
        }
        String defaultGraphURI = null;
        if (options.has("g")) {
            try {
                defaultGraphURI = (String)options.valueOf("graph");
                URI.create(defaultGraphURI);
            }
            catch (OptionException e) {
                System.out.println("The specified graph appears not be a proper URI.");
                System.exit(0);
            }
        }
        SparqlEndpoint endpoint = new SparqlEndpoint(endpointURL, defaultGraphURI);
        String cacheDirectory = (String)options.valueOf("cache");
        Verbalizer v = new Verbalizer(endpoint, cacheDirectory);
        OWLNamedIndividualImpl ind = new OWLNamedIndividualImpl(IRI.create((String)options.valueOf("i").toString()));
        OWLClassImpl cls = new OWLClassImpl(IRI.create((URI)((URI)options.valueOf("c"))));
        if (options.has("p")) {
            List personTypes = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)((String)options.valueOf("p")));
            v.setPersonTypes(new HashSet<String>(personTypes));
        }
        String summary = v.summarize((OWLIndividual)ind, (OWLClass)cls);
        summary = summary.replaceAll("\\s?\\((.*?)\\)", "");
        summary = summary.replace(" , among others,", ", among others,");
    }
}

