/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.triple2nl.nlp.relation;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.aksw.simba.bengal.triple2nl.nlp.relation.Pattern;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;

public class BoaPatternSelector {
    private static SolrServer server;
    private static Double WORDNET_DISTANCE_BOOST_FACTOR;
    private static Double BOA_SCORE_BOOST_FACTOR;
    private static Double REVERB_BOOST_FACTOR;
    private static final List<String> BE_TOKENS;
    private static final String SOLR_INDEX = "sparql2nl";

    public static List<Pattern> getNaturalLanguageRepresentation(String propertyUri, int maxResults) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(BoaPatternSelector.querySolrIndex(propertyUri));
        Collections.sort(patterns, (pattern1, pattern2) -> {
            double x = pattern2.naturalLanguageScore - pattern1.naturalLanguageScore;
            if (x < 0.0) {
                return -1;
            }
            if (x == 0.0) {
                return 0;
            }
            return 1;
        });
        int i = 50;
        LinkedHashSet<Pattern> preResults = new LinkedHashSet<Pattern>();
        for (Pattern pattern : patterns) {
            if (preResults.size() >= i) break;
            if (!(pattern.naturalLanguageScore > 0.0)) continue;
            preResults.add(pattern);
        }
        ArrayList<Pattern> results = new ArrayList<Pattern>(preResults);
        Collections.sort(results, (pattern1, pattern2) -> {
            double x = pattern2.features.get("SUPPORT_NUMBER_OF_PAIRS_LEARNED_FROM") - pattern1.features.get("SUPPORT_NUMBER_OF_PAIRS_LEARNED_FROM");
            if (x < 0.0) {
                return -1;
            }
            if (x == 0.0) {
                return 0;
            }
            return 1;
        });
        return results.size() > maxResults ? results.subList(0, maxResults) : results;
    }

    private static boolean isSuitable(Pattern pattern) {
        ArrayList<String> wordTokensList = new ArrayList<String>(Arrays.asList(pattern.naturalLanguageRepresentation.split(" ")));
        ArrayList<String> posTagTokens = new ArrayList<String>(Arrays.asList(pattern.posTags.split(" ")));
        String[] wordTokens = pattern.naturalLanguageRepresentation.split(" ");
        String[] tagTokens = pattern.posTags.split(" ");
        for (int i = 0; i < tagTokens.length; ++i) {
            if (!wordTokens[i + 1].matches("(^\\p{Upper}.*|and)") && !tagTokens[i].matches("(''|``|,|-RRB-|-LRB-|WP)")) continue;
            wordTokensList.set(i + 1, null);
            posTagTokens.set(i, null);
        }
        if (wordTokens[wordTokens.length - 2].equals("the")) {
            wordTokens[wordTokens.length - 2] = null;
        }
        wordTokensList.removeAll(Arrays.asList("", null));
        posTagTokens.removeAll(Arrays.asList("", null));
        pattern.naturalLanguageRepresentation = Joiner.on((String)" ").join(wordTokensList);
        pattern.posTags = Joiner.on((String)" ").join(posTagTokens);
        wordTokensList.removeAll(BE_TOKENS);
        wordTokensList.remove("a");
        wordTokensList.remove("?D?");
        wordTokensList.remove("?R?");
        return posTagTokens.contains("VB") && wordTokensList.size() > 0;
    }

    private static Double calculateNaturalLanguageScore(Pattern pattern) {
        return REVERB_BOOST_FACTOR * pattern.features.get("REVERB") + WORDNET_DISTANCE_BOOST_FACTOR * pattern.features.get("WORDNET_DISTANCE") + BOA_SCORE_BOOST_FACTOR * pattern.boaScore;
    }

    private static Set<Pattern> querySolrIndex(String propertyUri) {
        HashMap<Integer, Pattern> patterns = new HashMap<Integer, Pattern>();
        try {
            SolrQuery query = new SolrQuery("uri:\"" + propertyUri + "\"");
            query.addField("REVERB");
            query.addField("WORDNET_DISTANCE");
            query.addField("SUPPORT_NUMBER_OF_PAIRS_LEARNED_FROM");
            query.addField("pos");
            query.addField("boa-score");
            query.addField("nlr-var");
            query.addField("nlr-no-var");
            query.setRows(Integer.valueOf(10000));
            QueryResponse response = server.query((SolrParams)query);
            SolrDocumentList docList = response.getResults();
            for (SolrDocument d : docList) {
                Pattern pattern = new Pattern();
                pattern.naturalLanguageRepresentation = (String)d.get((Object)"nlr-var");
                pattern.naturalLanguageRepresentationWithoutVariables = (String)d.get((Object)"nlr-no-var");
                pattern.features.put("REVERB", Double.valueOf((String)d.get((Object)"REVERB")));
                pattern.features.put("WORDNET_DISTANCE", Double.valueOf((String)d.get((Object)"WORDNET_DISTANCE")));
                pattern.features.put("SUPPORT_NUMBER_OF_PAIRS_LEARNED_FROM", Double.valueOf((String)d.get((Object)"SUPPORT_NUMBER_OF_PAIRS_LEARNED_FROM")));
                pattern.posTags = (String)d.get((Object)"pos");
                pattern.boaScore = Double.valueOf((String)d.get((Object)"boa-score"));
                pattern.naturalLanguageScore = BoaPatternSelector.calculateNaturalLanguageScore(pattern);
                if (!BoaPatternSelector.isSuitable(pattern)) continue;
                if (patterns.containsKey(pattern.hashCode())) {
                    Pattern p = (Pattern)patterns.get(pattern.hashCode());
                    p.features.put("REVERB", pattern.features.get("REVERB") + p.features.get("REVERB"));
                    p.features.put("WORDNET_DISTANCE", pattern.features.get("WORDNET_DISTANCE") + p.features.get("WORDNET_DISTANCE"));
                    p.features.put("SUPPORT_NUMBER_OF_PAIRS_LEARNED_FROM", pattern.features.get("SUPPORT_NUMBER_OF_PAIRS_LEARNED_FROM") + p.features.get("SUPPORT_NUMBER_OF_PAIRS_LEARNED_FROM"));
                    Pattern pattern2 = p;
                    Double.valueOf(pattern2.boaScore + pattern.boaScore);
                    pattern2.boaScore = pattern2.boaScore;
                    pattern2 = p;
                    Double.valueOf(pattern2.naturalLanguageScore + pattern.naturalLanguageScore);
                    pattern2.naturalLanguageScore = pattern2.naturalLanguageScore;
                    patterns.put(pattern.hashCode(), p);
                    continue;
                }
                patterns.put(pattern.hashCode(), pattern);
            }
        }
        catch (SolrServerException e) {
            System.out.println("Could not execute query: " + (Object)((Object)e));
            e.printStackTrace();
        }
        return new HashSet<Pattern>(patterns.values());
    }

    public static void main(String[] args) throws IOException {
        List<String> uris = Arrays.asList("http://dbpedia.org/property/accessioneudate", "http://dbpedia.org/property/awards", "http://dbpedia.org/property/borderingstates", "http://dbpedia.org/property/classis", "http://dbpedia.org/property/country", "http://dbpedia.org/property/currency", "http://dbpedia.org/property/currencyCode", "http://dbpedia.org/property/densityrank", "http://dbpedia.org/property/design", "http://dbpedia.org/property/designer", "http://dbpedia.org/property/elevationM", "http://dbpedia.org/property/foundation", "http://dbpedia.org/property/ground", "http://dbpedia.org/property/industry", "http://dbpedia.org/property/location", "http://dbpedia.org/property/locationCountry", "http://dbpedia.org/property/mineral", "http://dbpedia.org/property/museum", "http://dbpedia.org/property/numEmployees", "http://dbpedia.org/property/office", "http://dbpedia.org/property/officialLanguages", "http://dbpedia.org/property/populationTotal", "http://dbpedia.org/property/publisher", "http://dbpedia.org/property/rulingParty", "http://dbpedia.org/property/spouse", "http://dbpedia.org/property/starring", "http://dbpedia.org/property/title", "http://dbpedia.org/ontology/album", "http://dbpedia.org/ontology/areaCode", "http://dbpedia.org/ontology/author", "http://dbpedia.org/ontology/battle", "http://dbpedia.org/ontology/birthDate", "http://dbpedia.org/ontology/birthPlace", "http://dbpedia.org/ontology/capital", "http://dbpedia.org/ontology/child", "http://dbpedia.org/ontology/country", "http://dbpedia.org/ontology/creator", "http://dbpedia.org/ontology/crosses", "http://dbpedia.org/ontology/currency", "http://dbpedia.org/ontology/date", "http://dbpedia.org/ontology/deathCause", "http://dbpedia.org/ontology/deathDate", "http://dbpedia.org/ontology/deathPlace", "http://dbpedia.org/ontology/developer", "http://dbpedia.org/ontology/director", "http://dbpedia.org/ontology/elevation", "http://dbpedia.org/ontology/formationYear", "http://dbpedia.org/ontology/foundationPlace", "http://dbpedia.org/ontology/genre", "http://dbpedia.org/ontology/governmentType", "http://dbpedia.org/ontology/ground", "http://dbpedia.org/ontology/height", "http://dbpedia.org/ontology/highestPlace", "http://dbpedia.org/ontology/isPartOf", "http://dbpedia.org/ontology/keyPerson", "http://dbpedia.org/ontology/language", "http://dbpedia.org/ontology/largestCity", "http://dbpedia.org/ontology/leaderName", "http://dbpedia.org/ontology/league", "http://dbpedia.org/ontology/locatedInArea", "http://dbpedia.org/ontology/location", "http://dbpedia.org/ontology/numberOfEmployees", "http://dbpedia.org/ontology/numberOfEntrances", "http://dbpedia.org/ontology/officialLanguage", "http://dbpedia.org/ontology/orderInOffice", "http://dbpedia.org/ontology/owner", "http://dbpedia.org/ontology/producer", "http://dbpedia.org/ontology/programmingLanguage", "http://dbpedia.org/ontology/publisher", "http://dbpedia.org/ontology/seasonNumber", "http://dbpedia.org/ontology/series", "http://dbpedia.org/ontology/sourceCountry", "http://dbpedia.org/ontology/spokenIn", "http://dbpedia.org/ontology/spouse", "http://dbpedia.org/ontology/starring");
        for (String uri : uris) {
            List<Pattern> patterns = BoaPatternSelector.getNaturalLanguageRepresentation(uri, 1);
            if (patterns.size() > 0) {
                System.out.print(uri + ": ");
                for (Pattern p : patterns) {
                    System.out.println(p.naturalLanguageRepresentation);
                }
                continue;
            }
            System.out.println(uri + ": ---------------------------------");
        }
    }

    private static void createPropertyDistribution() throws IOException {
        Path filePath = Paths.get("resources/qald2-dbpedia-train.xml", new String[0]);
        String queryString = new String(Files.readAllBytes(filePath), Charset.forName("UTF-8"));
        HashMap<String, Integer> distribution = new HashMap<String, Integer>();
        Matcher matcher = java.util.regex.Pattern.compile("db[op]:\\p{Lower}\\w+\\s").matcher(queryString);
        while (matcher.find()) {
            String property = matcher.group();
            if (distribution.containsKey(property)) {
                distribution.put(property, (Integer)distribution.get(property) + 1);
                continue;
            }
            distribution.put(property, 1);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry entry : distribution.entrySet()) {
            result.add(entry.getValue() + ": " + (String)entry.getKey());
        }
        Collections.sort(result);
        for (String s : result) {
            System.out.println(s);
        }
    }

    static {
        WORDNET_DISTANCE_BOOST_FACTOR = 300000.0;
        BOA_SCORE_BOOST_FACTOR = 10000.0;
        REVERB_BOOST_FACTOR = 1000000.0;
        BE_TOKENS = Arrays.asList("am", "are", "is", "was", "were");
        server = new HttpSolrServer("http://dbpedia.aksw.org:8080/solr/sparql2nl");
    }
}

