/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.triple2nl.converter;

import org.aksw.simba.bengal.triple2nl.converter.IRIConverter;
import org.apache.commons.lang3.StringUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.util.SimpleIRIShortFormProvider;

public class SimpleIRIConverter
implements IRIConverter {
    private IRIShortFormProvider sfp = new SimpleIRIShortFormProvider();
    private boolean splitCamelCase = true;
    private boolean replaceUnderScores = true;
    private boolean toLowerCase = false;
    private boolean omitContentInBrackets = true;

    @Override
    public String convert(String iri) {
        String shortForm = this.sfp.getShortForm(IRI.create((String)iri));
        shortForm = this.normalize(shortForm);
        return shortForm;
    }

    @Override
    public String convert(String iri, boolean dereferenceIRI) {
        return this.convert(iri);
    }

    private String splitCamelCase(String s) {
        if (!s.matches(".*[aeiou].*")) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (String token : s.split(" ")) {
            String[] tokenSplit = StringUtils.splitByCharacterTypeCamelCase((String)token);
            String noVowels = "";
            for (String t : tokenSplit) {
                if (t.matches(".*[aeiou].*") || !StringUtils.isAllUpperCase((CharSequence)t)) {
                    if (!noVowels.isEmpty()) {
                        sb.append(noVowels).append(" ");
                        noVowels = "";
                    }
                    sb.append(t).append(" ");
                    continue;
                }
                noVowels = noVowels + t;
            }
            sb.append(noVowels);
        }
        return sb.toString().trim();
    }

    private String normalize(String s) {
        if (this.replaceUnderScores) {
            s = s.replace("_", " ");
        }
        if (this.splitCamelCase) {
            s = this.splitCamelCase(s);
        }
        if (this.toLowerCase) {
            s = s.toLowerCase();
        }
        if (this.omitContentInBrackets) {
            s = s.replaceAll("\\(.+?\\)", "").trim();
        }
        return s;
    }
}

