/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.triple2nl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.sf.extjwnl.dictionary.Dictionary;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.jena_sparql_api.model.QueryExecutionFactoryModel;
import org.aksw.simba.bengal.triple2nl.converter.DefaultIRIConverter;
import org.aksw.simba.bengal.triple2nl.converter.IRIConverter;
import org.aksw.simba.bengal.triple2nl.converter.LiteralConverter;
import org.aksw.simba.bengal.triple2nl.gender.DictionaryBasedGenderDetector;
import org.aksw.simba.bengal.triple2nl.gender.Gender;
import org.aksw.simba.bengal.triple2nl.gender.GenderDetector;
import org.aksw.simba.bengal.triple2nl.nlp.relation.BoaPatternSelector;
import org.aksw.simba.bengal.triple2nl.nlp.relation.Pattern;
import org.aksw.simba.bengal.triple2nl.nlp.stemming.PlingStemmer;
import org.aksw.simba.bengal.triple2nl.property.PropertyVerbalization;
import org.aksw.simba.bengal.triple2nl.property.PropertyVerbalizationType;
import org.aksw.simba.bengal.triple2nl.property.PropertyVerbalizer;
import org.aksw.triple2nl.util.GenericType;
import org.apache.commons.collections15.ListUtils;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.dllearner.kb.sparql.SparqlEndpoint;
import org.dllearner.reasoning.SPARQLReasoner;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import simplenlg.framework.CoordinatedPhraseElement;
import simplenlg.framework.DocumentElement;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGFactory;
import simplenlg.lexicon.Lexicon;
import simplenlg.phrasespec.NPPhraseSpec;
import simplenlg.phrasespec.SPhraseSpec;
import simplenlg.realiser.english.Realiser;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;

public class TripleConverter {
    private static final Logger logger = LoggerFactory.getLogger(TripleConverter.class);
    private static String DEFAULT_CACHE_BASE_DIR = System.getProperty("java.io.tmpdir");
    private static String DEFAULT_CACHE_DIR = DEFAULT_CACHE_BASE_DIR + "/triple2nl-cache";
    private NLGFactory nlgFactory;
    private Realiser realiser;
    private IRIConverter uriConverter;
    private LiteralConverter literalConverter;
    private PropertyVerbalizer pp;
    private SPARQLReasoner reasoner;
    private boolean determinePluralForm = false;
    private boolean considerLiteralLanguage = true;
    private boolean encapsulateStringLiterals = true;
    private boolean useAsWellAsCoordination = true;
    private boolean returnAsSentence = true;
    private boolean useGenderInformation = true;
    private GenderDetector genderDetector;

    public TripleConverter() {
        this((QueryExecutionFactory)new QueryExecutionFactoryModel(ModelFactory.createDefaultModel()), DEFAULT_CACHE_DIR, Lexicon.getDefaultLexicon());
    }

    public TripleConverter(SparqlEndpoint endpoint) {
        this(endpoint, DEFAULT_CACHE_DIR);
    }

    public TripleConverter(QueryExecutionFactory qef, String cacheDirectory, Dictionary wordnetDirectory) {
        this(qef, null, null, cacheDirectory, wordnetDirectory, null);
    }

    public TripleConverter(SparqlEndpoint endpoint, String cacheDirectory) {
        this(endpoint, cacheDirectory, null);
    }

    public TripleConverter(SparqlEndpoint endpoint, String cacheDirectory, Dictionary wordnetDirectory) {
        this((QueryExecutionFactory)new QueryExecutionFactoryHttp(endpoint.getURL().toString(), (Collection)endpoint.getDefaultGraphURIs()), null, null, cacheDirectory, wordnetDirectory, Lexicon.getDefaultLexicon());
    }

    public TripleConverter(SparqlEndpoint endpoint, String cacheDirectory, Dictionary wordnetDirectory, Lexicon lexicon) {
        this((QueryExecutionFactory)new QueryExecutionFactoryHttp(endpoint.getURL().toString(), (Collection)endpoint.getDefaultGraphURIs()), null, null, cacheDirectory, wordnetDirectory, lexicon);
    }

    public TripleConverter(QueryExecutionFactory qef, IRIConverter uriConverter, String cacheDirectory, Dictionary wordnetDirectory) {
        this(qef, null, uriConverter, cacheDirectory, wordnetDirectory, Lexicon.getDefaultLexicon());
    }

    public TripleConverter(QueryExecutionFactory qef, String cacheDirectory, Lexicon lexicon) {
        this(qef, null, null, cacheDirectory, null, lexicon);
    }

    public TripleConverter(QueryExecutionFactory qef, PropertyVerbalizer propertyVerbalizer, IRIConverter uriConverter, String cacheDirectory, Dictionary wordnetDirectory, Lexicon lexicon) {
        if (uriConverter == null) {
            uriConverter = new DefaultIRIConverter(qef, cacheDirectory);
        }
        this.uriConverter = uriConverter;
        if (propertyVerbalizer == null) {
            propertyVerbalizer = new PropertyVerbalizer(uriConverter, wordnetDirectory);
        }
        this.pp = propertyVerbalizer;
        if (lexicon == null) {
            lexicon = Lexicon.getDefaultLexicon();
        }
        this.nlgFactory = new NLGFactory(lexicon);
        this.realiser = new Realiser(lexicon);
        this.literalConverter = new LiteralConverter(uriConverter);
        this.literalConverter.setEncapsulateStringLiterals(this.encapsulateStringLiterals);
        this.reasoner = new SPARQLReasoner(qef);
        this.genderDetector = new DictionaryBasedGenderDetector();
    }

    public String convert(Triple t) {
        return this.convert(t, false);
    }

    public String convert(Triple t, boolean negated) {
        SPhraseSpec phrase = this.convertToPhrase(t, negated);
        String text = this.returnAsSentence ? this.realiser.realiseSentence((NLGElement)phrase) : this.realiser.realise((NLGElement)phrase).getRealisation();
        return text;
    }

    public String convert(List<Triple> triples) {
        CoordinatedPhraseElement typesConjunction = this.nlgFactory.createCoordinatedPhrase();
        List<Triple> typeTriples = triples.stream().filter(t -> t.predicateMatches(RDF.type.asNode())).collect(Collectors.toList());
        List otherTriples = ListUtils.subtract(triples, typeTriples);
        ArrayList typePhrases = this.convertToPhrases(typeTriples);
        if (typePhrases.size() > 1) {
            CoordinatedPhraseElement combinedObject = this.nlgFactory.createCoordinatedPhrase();
            if (this.useAsWellAsCoordination) {
                SPhraseSpec phrase1 = typePhrases.remove(typePhrases.size() - 1);
                SPhraseSpec phrase2 = typePhrases.get(typePhrases.size() - 1);
                CoordinatedPhraseElement combinedLastTwoObjects = this.nlgFactory.createCoordinatedPhrase((Object)phrase1.getObject(), (Object)phrase2.getObject());
                combinedLastTwoObjects.setConjunction("as well as");
                combinedLastTwoObjects.setFeature("raise_specifier", false);
                combinedLastTwoObjects.setFeature("specifier", (Object)"a");
                phrase2.setObject((Object)combinedLastTwoObjects);
            }
            Iterator<SPhraseSpec> iterator = typePhrases.iterator();
            SPhraseSpec representative = iterator.next();
            combinedObject.addCoordinate((Object)representative.getObject());
            while (iterator.hasNext()) {
                SPhraseSpec phrase = iterator.next();
                NLGElement object = phrase.getObject();
                combinedObject.addCoordinate((Object)object);
            }
            combinedObject.setFeature("raise_specifier", true);
            representative.setObject((Object)combinedObject);
            typePhrases = Lists.newArrayList((Object[])new SPhraseSpec[]{representative});
        }
        for (SPhraseSpec phrase : typePhrases) {
            typesConjunction.addCoordinate((Object)phrase);
        }
        CoordinatedPhraseElement othersConjunction = this.nlgFactory.createCoordinatedPhrase();
        List<SPhraseSpec> otherPhrases = this.convertToPhrases(otherTriples);
        if (typeTriples.isEmpty()) {
            othersConjunction.addCoordinate((Object)otherPhrases.remove(0));
        }
        otherPhrases.stream().forEach(p -> this.asPronoun(p.getSubject()));
        for (SPhraseSpec phrase : otherPhrases) {
            othersConjunction.addCoordinate((Object)phrase);
        }
        ArrayList<DocumentElement> sentences = new ArrayList<DocumentElement>();
        if (!typeTriples.isEmpty()) {
            sentences.add(this.nlgFactory.createSentence((NLGElement)typesConjunction));
        }
        if (!otherTriples.isEmpty()) {
            sentences.add(this.nlgFactory.createSentence((NLGElement)othersConjunction));
        }
        DocumentElement paragraph = this.nlgFactory.createParagraph(sentences);
        String realisation = this.realiser.realise((NLGElement)paragraph).getRealisation().trim();
        return realisation;
    }

    private void asPronoun(NLGElement el) {
        if (el.hasFeature("specifier")) {
            NLGElement specifier = el.getFeatureAsElement("specifier");
            if (specifier.hasFeature("possessive")) {
                specifier.setFeature("pronominal", true);
            }
        } else {
            el.setFeature("pronominal", true);
        }
    }

    public SPhraseSpec convertToPhrase(Triple t) {
        return this.convertToPhrase(t, false);
    }

    public SPhraseSpec convertToPhrase(Triple t, boolean negated) {
        return this.convertToPhrase(t, negated, false);
    }

    public SPhraseSpec convertToPhrase(Triple t, boolean negated, boolean reverse) {
        logger.debug("Verbalizing triple " + t);
        SPhraseSpec p = this.nlgFactory.createClause();
        Node subject = t.getSubject();
        Node predicate = t.getPredicate();
        Node object = t.getObject();
        if (predicate.isVariable()) {
            NLGElement subjectElement = this.processSubject(subject);
            p.setSubject((Object)subjectElement);
            p.setVerb((Object)("be related via " + predicate.toString() + " to"));
            NPPhraseSpec objectElement = this.processObject(object, false);
            p.setObject((Object)objectElement);
        } else {
            boolean objectIsClass = predicate.matches(RDF.type.asNode());
            NLGElement subjectElement = this.processSubject(subject);
            NPPhraseSpec objectElement = this.processObject(object, objectIsClass);
            PropertyVerbalization propertyVerbalization = this.pp.verbalize(predicate.getURI());
            String predicateAsString = propertyVerbalization.getVerbalizationText();
            if (objectIsClass) {
                p.setSubject((Object)subjectElement);
                p.setVerb((Object)"be");
                objectElement.setSpecifier((Object)"a");
                p.setObject((Object)objectElement);
            } else {
                PropertyVerbalizationType type = predicate.matches(RDFS.label.asNode()) ? PropertyVerbalizationType.NOUN : propertyVerbalization.getVerbalizationType();
                if (type == PropertyVerbalizationType.NOUN) {
                    subjectElement.setFeature("possessive", true);
                    NPPhraseSpec predicateNounPhrase = this.nlgFactory.createNounPhrase((Object)PlingStemmer.stem(predicateAsString));
                    predicateNounPhrase.setFeature("specifier", (Object)subjectElement);
                    if (this.considerLiteralLanguage && object.isLiteral() && object.getLiteralLanguage() != null && !object.getLiteralLanguage().isEmpty()) {
                        String languageTag = object.getLiteralLanguage();
                        String language = Locale.forLanguageTag(languageTag).getDisplayLanguage(Locale.ROOT);
                        predicateNounPhrase.setPreModifier(language);
                    }
                    p.setSubject((Object)predicateNounPhrase);
                    p.setVerb((Object)"be");
                    p.setObject((Object)objectElement);
                    boolean isPlural = this.determinePluralForm && this.usePluralForm(t);
                    predicateNounPhrase.setPlural(isPlural);
                    p.setPlural(isPlural);
                    if (reverse) {
                        subjectElement.setFeature("possessive", false);
                        p.setSubject((Object)subjectElement);
                        p.setVerbPhrase((NLGElement)this.nlgFactory.createVerbPhrase((Object)("be " + predicateAsString + " of")));
                        p.setObject((Object)objectElement);
                    }
                } else if (type == PropertyVerbalizationType.VERB) {
                    p.setSubject((Object)subjectElement);
                    p.setVerb((Object)this.pp.getInfinitiveForm(predicateAsString));
                    p.setObject((Object)objectElement);
                    p.setFeature("tense", (Object)propertyVerbalization.getTense());
                } else {
                    List<Pattern> l = BoaPatternSelector.getNaturalLanguageRepresentation(predicate.toString(), 1);
                    if (l.size() > 0) {
                        String boaPattern = l.get((int)0).naturalLanguageRepresentation;
                        if (boaPattern.startsWith("?R?")) {
                            p.setSubject((Object)subjectElement);
                            p.setObject((Object)objectElement);
                        } else {
                            p.setObject((Object)subjectElement);
                            p.setSubject((Object)objectElement);
                        }
                        p.setVerb((Object)BoaPatternSelector.getNaturalLanguageRepresentation((String)predicate.toString(), (int)1).get((int)0).naturalLanguageRepresentationWithoutVariables);
                    } else {
                        p.setSubject((Object)subjectElement);
                        p.setVerb((Object)("be related via \"" + predicateAsString + "\" to"));
                        p.setObject((Object)objectElement);
                    }
                }
            }
        }
        if (!negated && object.isLiteral() && object.getLiteralDatatype() != null && object.getLiteralDatatype().equals(XSDDatatype.XSDboolean)) {
            p.setObject(null);
            boolean bl = negated = (Boolean)object.getLiteralValue() == false;
        }
        if (negated) {
            p.setFeature("negated", negated);
        }
        return p;
    }

    public List<SPhraseSpec> convertToPhrases(Collection<Triple> triples) {
        ArrayList<SPhraseSpec> phrases = new ArrayList<SPhraseSpec>();
        for (Triple triple : triples) {
            phrases.add(this.convertToPhrase(triple));
        }
        return phrases;
    }

    public void setEncapsulateStringLiterals(boolean encapsulateStringLiterals) {
        this.literalConverter.setEncapsulateStringLiterals(encapsulateStringLiterals);
    }

    public void setDeterminePluralForm(boolean determinePluralForm) {
        this.determinePluralForm = determinePluralForm;
    }

    public void setConsiderLiteralLanguage(boolean considerLiteralLanguage) {
        this.considerLiteralLanguage = considerLiteralLanguage;
    }

    private boolean usePluralForm(Triple triple) {
        return triple.getObject().isVariable() && !this.reasoner.isFunctional((OWLObjectProperty)new OWLObjectPropertyImpl(IRI.create((String)triple.getPredicate().getURI()))) && !this.reasoner.getRange((OWLDataProperty)new OWLDataPropertyImpl(IRI.create((String)triple.getPredicate().getURI()))).asOWLDatatype().getIRI().equals((Object)OWL2Datatype.XSD_BOOLEAN.getIRI());
    }

    public void setReturnAsSentence(boolean returnAsSentence) {
        this.returnAsSentence = returnAsSentence;
    }

    public void setUseGenderInformation(boolean useGenderInformation) {
        this.useGenderInformation = useGenderInformation;
    }

    public void setGenderDetector(GenderDetector genderDetector) {
        this.genderDetector = genderDetector;
    }

    public NLGElement processNode(Node node) {
        NPPhraseSpec element;
        if (node.isVariable()) {
            element = this.processVarNode(node);
        } else if (node.isURI()) {
            element = this.processResourceNode(node);
        } else if (node.isLiteral()) {
            element = this.processLiteralNode(node);
        } else {
            throw new UnsupportedOperationException("Can not convert blank node.");
        }
        return element;
    }

    public NPPhraseSpec processClassNode(Node node, boolean plural) {
        NPPhraseSpec object;
        if (node.equals((Object)OWL.Thing.asNode())) {
            object = this.nlgFactory.createNounPhrase((Object)GenericType.ENTITY.getNlr());
        } else if (node.equals((Object)RDFS.Literal.asNode())) {
            object = this.nlgFactory.createNounPhrase((Object)GenericType.VALUE.getNlr());
        } else if (node.equals((Object)RDF.Property.asNode())) {
            object = this.nlgFactory.createNounPhrase((Object)GenericType.RELATION.getNlr());
        } else if (node.equals((Object)RDF.type.asNode())) {
            object = this.nlgFactory.createNounPhrase((Object)GenericType.TYPE.getNlr());
        } else {
            String label = this.uriConverter.convert(node.getURI());
            if (label != null) {
                label = PlingStemmer.stem(label);
                label = label.toLowerCase();
                object = this.nlgFactory.createNounPhrase((Object)this.nlgFactory.createInflectedWord((Object)label, LexicalCategory.NOUN));
            } else {
                object = this.nlgFactory.createNounPhrase((Object)GenericType.ENTITY.getNlr());
            }
        }
        object.setPlural(plural);
        return object;
    }

    public NPPhraseSpec processVarNode(Node varNode) {
        return this.nlgFactory.createNounPhrase((Object)this.nlgFactory.createWord((Object)varNode.toString(), LexicalCategory.NOUN));
    }

    public NPPhraseSpec processLiteralNode(Node node) {
        LiteralLabel lit = node.getLiteral();
        String literalText = this.literalConverter.convert(lit);
        NPPhraseSpec np = this.nlgFactory.createNounPhrase((Object)this.nlgFactory.createWord((Object)literalText, LexicalCategory.NOUN));
        np.setPlural(this.literalConverter.isPlural(lit));
        return np;
    }

    public NPPhraseSpec processResourceNode(Node node) {
        String s = this.uriConverter.convert(node.getURI());
        NLGElement word = this.nlgFactory.createWord((Object)s, LexicalCategory.NOUN);
        if (this.useGenderInformation) {
            Gender gender = this.genderDetector.getGender(s);
            if (gender == Gender.FEMALE) {
                word.setFeature("gender", (Object)simplenlg.features.Gender.FEMININE);
            } else if (gender == Gender.MALE) {
                word.setFeature("gender", (Object)simplenlg.features.Gender.MASCULINE);
            }
        }
        word.setFeature("proper", true);
        NPPhraseSpec np = this.nlgFactory.createNounPhrase((Object)word);
        return np;
    }

    private NLGElement processSubject(Node subject) {
        NPPhraseSpec element;
        if (subject.isVariable()) {
            element = this.processVarNode(subject);
        } else if (subject.isURI()) {
            element = this.processResourceNode(subject);
        } else if (subject.isLiteral()) {
            element = this.processLiteralNode(subject);
        } else {
            throw new UnsupportedOperationException("Can not convert " + subject);
        }
        return element;
    }

    private NPPhraseSpec processObject(Node object, boolean isClass) {
        NPPhraseSpec element;
        if (object.isVariable()) {
            element = this.processVarNode(object);
        } else if (object.isLiteral()) {
            element = this.processLiteralNode(object);
        } else if (object.isURI()) {
            element = isClass ? this.processClassNode(object, false) : this.processResourceNode(object);
        } else {
            throw new IllegalArgumentException("Can not convert blank node " + object + ".");
        }
        return element;
    }

    public NPPhraseSpec getNPPhrase(String uri, boolean plural, boolean isClass) {
        NPPhraseSpec object;
        if (uri.equals(OWL.Thing.getURI())) {
            object = this.nlgFactory.createNounPhrase((Object)GenericType.ENTITY.getNlr());
        } else if (uri.equals(RDFS.Literal.getURI())) {
            object = this.nlgFactory.createNounPhrase((Object)GenericType.VALUE.getNlr());
        } else if (uri.equals(RDF.Property.getURI())) {
            object = this.nlgFactory.createNounPhrase((Object)GenericType.RELATION.getNlr());
        } else if (uri.equals(RDF.type.getURI())) {
            object = this.nlgFactory.createNounPhrase((Object)GenericType.TYPE.getNlr());
        } else {
            String label = this.uriConverter.convert(uri);
            if (label != null) {
                if (isClass) {
                    label = PlingStemmer.stem(label);
                    label = label.toLowerCase();
                }
                object = this.nlgFactory.createNounPhrase((Object)this.nlgFactory.createInflectedWord((Object)label, LexicalCategory.NOUN));
            } else {
                object = this.nlgFactory.createNounPhrase((Object)GenericType.ENTITY.getNlr());
            }
        }
        object.setPlural(plural);
        return object;
    }
}

