/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.selector;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.aksw.simba.bengal.selector.AbstractSelector;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;

public class SimpleSummarySelector
extends AbstractSelector {
    private Set<String> sourceClasses;
    private List<Resource> resources;
    private Random r = new Random(20L);
    private int minSize = 1;
    private int maxSize = 5;

    public SimpleSummarySelector(Set<String> sourceClasses, Set<String> targetClasses, String endpoint, String graph, int minSize, int maxSize, long seed, boolean useSymmetricCbd) {
        super(targetClasses, endpoint, graph, useSymmetricCbd);
        this.sourceClasses = sourceClasses;
        this.resources = null;
        this.minSize = minSize;
        if (maxSize < minSize) {
            maxSize = minSize + 1;
        }
        this.maxSize = maxSize;
        this.r = new Random(seed);
    }

    public SimpleSummarySelector(Set<String> sourceClasses, Set<String> targetClasses, String endpoint, String graph) {
        super(targetClasses, endpoint, graph);
        this.sourceClasses = sourceClasses;
        this.resources = null;
    }

    @Override
    public List<Statement> getNextStatements() {
        int counter;
        List<Statement> statements;
        if (this.resources == null) {
            this.resources = this.getResources(this.sourceClasses);
        }
        if ((statements = this.getSummary(this.resources.get(counter = Math.abs(this.r.nextInt() % this.resources.size())))) == null) {
            return null;
        }
        HashSet<Statement> result = new HashSet<Statement>();
        int size = this.maxSize;
        if (size >= statements.size()) {
            return this.sortStatements(new HashSet<Statement>(statements));
        }
        while (result.size() < size) {
            counter = Math.abs(this.r.nextInt() % statements.size());
            result.add(statements.get(counter));
        }
        return this.sortStatements(result);
    }

    public static void main(String[] args) {
        HashSet<String> classes = new HashSet<String>();
        classes.add("<http://dbpedia.org/ontology/Person>");
        classes.add("<http://dbpedia.org/ontology/Place>");
        classes.add("<http://dbpedia.org/ontology/Organisation>");
        SimpleSummarySelector sss = new SimpleSummarySelector(classes, classes, "http://dbpedia.org/sparql", null);
        sss.getNextStatements();
        sss.getNextStatements();
    }
}

