/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.selector;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.aksw.simba.bengal.selector.AbstractSelector;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridTripleSelector
extends AbstractSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(HybridTripleSelector.class);
    private Set<String> sourceClasses;
    private List<Resource> resources;
    private Random r = new Random(20L);
    private int minSize = 1;
    private int maxSize = 5;

    public HybridTripleSelector(Set<String> sourceClasses, Set<String> targetClasses, String endpoint, String graph, int minSize, int maxSize, long seed) {
        super(targetClasses, endpoint, graph);
        this.sourceClasses = sourceClasses;
        this.resources = null;
        this.minSize = minSize;
        if (maxSize < minSize) {
            maxSize = minSize + 1;
        }
        this.maxSize = maxSize;
        this.r = new Random(seed);
    }

    public HybridTripleSelector(Set<String> sourceClasses, Set<String> targetClasses, String endpoint, String graph) {
        super(targetClasses, endpoint, graph);
        this.sourceClasses = sourceClasses;
        this.resources = null;
    }

    @Override
    public List<Statement> getNextStatements() {
        if (this.resources == null) {
            this.resources = this.getResources(this.sourceClasses);
        }
        int size = this.minSize + this.r.nextInt(this.maxSize - this.minSize + 1);
        ArrayList<Statement> result = new ArrayList<Statement>(size);
        int counter = Math.abs(this.r.nextInt() % this.resources.size());
        Resource currentResource = this.resources.get(counter);
        HashSet<Statement> alreadySeenStatements = new HashSet<Statement>();
        boolean madeAStepBackBefore = true;
        Resource oldResource = null;
        List<Statement> oldStatements = null;
        List<Statement> statements = null;
        boolean resourceChanged = true;
        int retries = 0;
        int maxRetries = 10;
        int statementsForThisResource = 0;
        int processedStatementsOfThisResource = 0;
        while (result.size() < size) {
            Statement statement;
            if (resourceChanged) {
                oldStatements = statements;
                statements = this.getSummary(currentResource);
                if (statements == null) {
                    LOGGER.error("Got an empty list of statements for the resource \"" + currentResource.getURI() + "\". Returning null.");
                    return null;
                }
                statementsForThisResource = statements.size();
                processedStatementsOfThisResource = Sets.intersection(new HashSet<Statement>(statements), alreadySeenStatements).size();
                if (processedStatementsOfThisResource == statementsForThisResource) {
                    if (!madeAStepBackBefore) {
                        madeAStepBackBefore = true;
                        statements = oldStatements;
                        currentResource = oldResource;
                        statementsForThisResource = statements.size();
                        processedStatementsOfThisResource = Sets.intersection(new HashSet<Statement>(statements), alreadySeenStatements).size();
                    } else {
                        LOGGER.info("Got stuck in a dead end. Returning the statements I selected so far.");
                        return result;
                    }
                }
                resourceChanged = false;
            }
            if (alreadySeenStatements.contains(statement = statements.get(counter = this.r.nextInt(statementsForThisResource)))) {
                if (++retries <= maxRetries) continue;
                LOGGER.warn("After {} retries I couldn't select a matching statement. Returning the statements I selected so far.", (Object)maxRetries);
                return result;
            }
            if (result.size() == size - 1) {
                result.add(statement);
                alreadySeenStatements.add(statement);
                continue;
            }
            if (statement.getObject().isResource()) {
                result.add(statement);
                alreadySeenStatements.add(statement);
                if (this.r.nextInt(statementsForThisResource) > ++processedStatementsOfThisResource) continue;
                oldResource = currentResource;
                currentResource = statement.getObject().asResource();
                resourceChanged = true;
                madeAStepBackBefore = false;
                retries = 0;
                processedStatementsOfThisResource = 0;
                continue;
            }
            result.add(statement);
            alreadySeenStatements.add(statement);
            ++processedStatementsOfThisResource;
        }
        System.out.println(result);
        return result;
    }
}

