/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.paraphrasing;

import com.carrotsearch.hppc.BitSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.aksw.gerbil.io.nif.impl.TurtleNIFParser;
import org.aksw.gerbil.io.nif.impl.TurtleNIFWriter;
import org.aksw.gerbil.transfer.nif.Document;
import org.aksw.gerbil.transfer.nif.Marking;
import org.aksw.gerbil.transfer.nif.MeaningSpan;
import org.aksw.gerbil.transfer.nif.data.DocumentImpl;
import org.aksw.gerbil.transfer.nif.data.NamedEntity;
import org.aksw.simba.bengal.paraphrasing.Paraphrasing;
import org.aksw.simba.bengal.utils.DocumentHelper;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.dllearner.kb.sparql.SparqlEndpoint;
import org.dllearner.kb.sparql.SparqlQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParaphasingNIF {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParaphasingNIF.class);
    private static final String FILENAME = "/Users/diegomoussallem/Desktop/BENGAL-master/bengal_path_1.ttl";

    public void replaceSubjectWithPronoun(Document document, String subjectUri) {
        MeaningSpan marking = DocumentHelper.searchFirstOccurrence(subjectUri, document);
        if (marking == null) {
            return;
        }
        String documentText = document.getText();
        String pronoun = null;
        int start = marking.getStartPosition();
        int length = marking.getLength();
        int end = start + length;
        boolean possessiveForm = false;
        if (documentText.charAt(end - 2) == '\'' && documentText.charAt(end - 1) == 's') {
            possessiveForm = true;
        } else if (end + 1 < documentText.length() && documentText.charAt(end) == '\'') {
            possessiveForm = true;
            length = documentText.charAt(end + 1) == 's' ? (length += 2) : ++length;
        }
        String type = this.getType(subjectUri);
        if (type != null) {
            if (type.equals("http://dbpedia.org/ontology/Person")) {
                String commentString = this.getGender(subjectUri);
                if (commentString.contains(" he ") || commentString.contains("He ") || commentString.contains(" his ")) {
                    pronoun = possessiveForm ? (start == 0 ? "His" : "his") : (start == 0 ? "He" : "he");
                } else if (commentString.contains(" she ") || commentString.contains("She ") || commentString.contains(" her ")) {
                    pronoun = possessiveForm ? (start == 0 ? "Her" : "her") : (start == 0 ? "She" : "she");
                }
            } else if (possessiveForm) {
                pronoun = start == 0 ? "Its" : "its";
            } else {
                String string = pronoun = start == 0 ? "It" : "it";
            }
        }
        if (pronoun == null) {
            return;
        }
        document.getMarkings().remove(marking);
        DocumentHelper.replaceText(document, start, length, pronoun);
    }

    private String getType(String uri) {
        if (uri.equals(RDF.type.getURI())) {
            return "type";
        }
        if (uri.equals(RDFS.label.getURI())) {
            return "label";
        }
        try {
            String labelQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX dbr: <http://dbpedia.org/resource/> PREFIX dbo: <http://dbpedia.org/ontology/> PREFIX owl: <http://www.w3.org/2002/07/owl#> SELECT  DISTINCT ?lcs WHERE { ?lcs ^rdf:type <" + uri + ">." + "?lcs rdfs:subClassOf ?x." + "?x rdfs:subClassOf owl:Thing." + "?lcs rdfs:label []." + "}";
            ResultSetRewindable results = new SparqlQuery(labelQuery, SparqlEndpoint.getEndpointDBpedia()).send();
            String label = null;
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                label = soln.getResource("lcs").toString();
            }
            return label;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getGender(String uri) {
        if (uri.equals(RDF.type.getURI())) {
            return "type";
        }
        if (uri.equals(RDFS.label.getURI())) {
            return "label";
        }
        try {
            String labelQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>PREFIX dbr: <http://dbpedia.org/resource/>PREFIX dbo: <http://dbpedia.org/ontology/>PREFIX owl: <http://www.w3.org/2002/07/owl#>SELECT  DISTINCT ?com WHERE { <" + uri + "> rdfs:comment ?com." + "FILTER (lang(?com) = 'en')." + "}";
            ResultSetRewindable results = new SparqlQuery(labelQuery, SparqlEndpoint.getEndpointDBpedia()).send();
            String label = null;
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                label = soln.getLiteral("com").getLexicalForm();
            }
            return label;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document replaceSubjectWithSurfaceForms(Document document) throws IOException {
        DocumentImpl newDoc = null;
        Paraphrasing service = new Paraphrasing();
        List originalNes = document.getMarkings(NamedEntity.class);
        Collections.sort(originalNes, service);
        String text = document.getText();
        List oldEntities = document.getMarkings(MeaningSpan.class);
        HashMap<MeaningSpan, String> entities = new HashMap<MeaningSpan, String>();
        for (MeaningSpan meaning : oldEntities) {
            entities.put(meaning, text.substring(meaning.getStartPosition(), meaning.getStartPosition() + meaning.getLength()));
        }
        BitSet blockedPositions = new BitSet((long)text.length());
        boolean count = false;
        block1: for (NamedEntity ne : originalNes) {
            String uri = ne.getUri().toString();
            String label = text.substring(ne.getStartPosition(), ne.getStartPosition() + ne.getLength());
            int pos = -ne.getLength();
            do {
                if ((pos = text.indexOf(label, pos + ne.getLength())) < 0) {
                    LOGGER.warn("The SufaceForm replacement changed one of the entities. Couldn't find the surface form \"{}\" in the text \"{}\". Returning the original document.", (Object)label, (Object)text);
                    continue block1;
                }
                if (pos > 0 && count) {
                    String newLabel = ParaphasingNIF.getSurfaceForm(uri);
                    if (newLabel.equals("")) continue block1;
                    String textSF = document.getText().replace(label, newLabel);
                    newDoc = new DocumentImpl(textSF, document.getDocumentURI());
                    BitSet currentPositions = new BitSet((long)textSF.length());
                    textSF = textSF.replace(label, newLabel);
                    newDoc.setText(textSF);
                    int newPos = textSF.indexOf(newLabel, ne.getStartPosition());
                    if (pos >= 0) {
                        currentPositions.clear();
                        currentPositions.set((long)pos, (long)(pos + label.length()));
                        if (BitSet.intersectionCount((BitSet)blockedPositions, (BitSet)currentPositions) == 0L) {
                            newDoc.addMarking((Marking)new NamedEntity(newPos, newLabel.length(), uri));
                            blockedPositions.or(currentPositions);
                            continue block1;
                        }
                    }
                    count = false;
                    continue block1;
                }
                count = true;
            } while (pos >= 0);
        }
        return newDoc;
    }

    public static String getSurfaceForm(String resource) throws IOException {
        try {
            Properties prop = new Properties();
            FileInputStream input = new FileInputStream("/Users/diegomoussallem/Desktop/BENGAL-master/src/main/resources/config/bengal.properties");
            prop.load(input);
            String surfaceFormTSV = prop.getProperty("surfaceForms");
            File file = new File(surfaceFormTSV);
            String label = "";
            BufferedReader br = new BufferedReader(new FileReader(file));
            while (br.ready()) {
                String[] line = br.readLine().split("\t");
                String subject = line[0];
                String object = line[1];
                if (!subject.equals(resource)) continue;
                label = object;
                break;
            }
            br.close();
            return label;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Document paraphrasingNIF(Document doc) throws IOException {
        Paraphrasing service = new Paraphrasing();
        String text = doc.getText();
        System.out.println(text);
        String paraphrases = service.paraphrase(text);
        DocumentImpl newDoc = new DocumentImpl(paraphrases, doc.getDocumentURI());
        List originalNes = doc.getMarkings(NamedEntity.class);
        Collections.sort(originalNes, service);
        BitSet blockedPositions = new BitSet((long)paraphrases.length());
        BitSet currentPositions = new BitSet((long)paraphrases.length());
        for (NamedEntity ne : originalNes) {
            String label = text.substring(ne.getStartPosition(), ne.getStartPosition() + ne.getLength());
            int pos = -ne.getLength();
            do {
                if ((pos = paraphrases.indexOf(label, pos + ne.getLength())) < 0) {
                    LOGGER.warn("The paraphrasing changed one of the entities. Couldn't find the surface form \"{}\" in the text \"{}\". Returning the original document.", (Object)label, (Object)paraphrases);
                    newDoc = null;
                    break;
                }
                currentPositions.clear();
                currentPositions.set((long)pos, (long)(pos + ne.getLength()));
            } while (BitSet.intersectionCount((BitSet)blockedPositions, (BitSet)currentPositions) > 0L);
            if (newDoc == null) continue;
            newDoc.addMarking((Marking)new NamedEntity(pos, ne.getLength(), ne.getUris()));
            blockedPositions.or(currentPositions);
        }
        return newDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int i;
        FileInputStream nif = new FileInputStream(FILENAME);
        TurtleNIFParser parser = new TurtleNIFParser();
        ListIterator iterator = parser.parseNIF((InputStream)nif).listIterator();
        ArrayList documents = new ArrayList();
        ArrayList<Document> documents2 = new ArrayList<Document>();
        ArrayList documents3 = new ArrayList();
        while (iterator.hasNext()) {
            documents.add(iterator.next());
        }
        System.out.println(documents.size());
        int count = 0;
        for (Document doc : documents) {
            Document newDoc = ParaphasingNIF.paraphrasingNIF(doc);
            ++count;
            if (newDoc != null) {
                LOGGER.info("Created document #" + count);
                newDoc.setDocumentURI("http://aksw.org/generated/" + count);
                documents2.add(newDoc);
                continue;
            }
            LOGGER.info("Created document without paraphrasing #" + count);
            doc.setDocumentURI("http://aksw.org/generated/" + count);
            documents2.add(doc);
        }
        String filePath = "B12_bengal_hybrid_object_10_paraphrased.ttl";
        TurtleNIFWriter writer = new TurtleNIFWriter();
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(filePath);
            for (i = 0; i < documents3.size(); ++i) {
                writer.writeNIF(documents3.subList(i, i + 1), (OutputStream)fout);
            }
        }
        catch (Exception e) {
            System.out.println(documents3.get(i));
            LOGGER.error("Error while writing the documents to file. Aborting.", (Throwable)e);
            System.out.println(documents3.get(i));
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception exception) {}
            }
        }
        System.out.println("Finished");
    }
}

