/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.verbalizer;

import com.carrotsearch.hppc.BitSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.aksw.gerbil.transfer.nif.Document;
import org.aksw.gerbil.transfer.nif.Marking;
import org.aksw.gerbil.transfer.nif.MeaningSpan;
import org.aksw.gerbil.transfer.nif.data.DocumentImpl;
import org.aksw.gerbil.transfer.nif.data.NamedEntity;
import org.aksw.simba.bengal.triple2nl.TripleConverter;
import org.aksw.simba.bengal.utils.DocumentHelper;
import org.aksw.simba.bengal.verbalizer.BVerbalizer;
import org.aksw.simba.bengal.verbalizer.NumberOfVerbalizedTriples;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.PropertyImpl;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.rdf.model.impl.StatementImpl;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.dllearner.kb.sparql.SparqlEndpoint;
import org.dllearner.kb.sparql.SparqlQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemWeb2NLVerbalizer
implements BVerbalizer,
Comparator<NamedEntity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SemWeb2NLVerbalizer.class);
    private static final HashSet<String> BLACKLISTED_PROPERTIES = new HashSet<String>(Arrays.asList("http://www.w3.org/2000/01/rdf-schema#comment", "http://www.w3.org/2000/01/rdf-schema#label", "http://dbpedia.org/ontology/abstract", "http://dbpedia.org/ontology/wikiPageExternalLink", "http://dbpedia.org/class/yago/Wikicat", "http://commons.wikimedia.org/wiki", "http://www.w3.org/2002/07/owl#sameAs", "http://dbpedia.org/ontology/thumbnail"));
    private TripleConverter converter;
    private SparqlEndpoint endpoint;
    private boolean usePronouns;
    private boolean useSurfaceForms;

    public SemWeb2NLVerbalizer(SparqlEndpoint endpoint) {
        this(endpoint, false, false);
    }

    public SemWeb2NLVerbalizer(SparqlEndpoint endpoint, boolean usePronouns, boolean useSurfaceForms) {
        this.endpoint = endpoint;
        this.usePronouns = usePronouns;
        this.useSurfaceForms = useSurfaceForms;
        this.converter = new TripleConverter(this.endpoint);
    }

    @Override
    public Document generateDocument(List<Statement> triples) {
        DocumentImpl document;
        ArrayList<DocumentImpl> subDocs = new ArrayList<DocumentImpl>(triples.size());
        Resource oldSubject = null;
        boolean SFchange = false;
        for (Statement s : triples) {
            Resource subject = s.getSubject();
            if (s.getObject().isAnon() || BLACKLISTED_PROPERTIES.contains(s.getPredicate().getURI())) continue;
            Triple t = Triple.create((Node)subject.asNode(), (Node)s.getPredicate().asNode(), (Node)s.getObject().asNode());
            document = new DocumentImpl(this.converter.convert(t).toString());
            if (this.annotateDocument((Document)document, s)) {
                if (this.usePronouns && subject.equals(oldSubject) && SFchange) {
                    this.replaceSubjectWithPronoun((Document)document, subject.getURI());
                }
                if (this.useSurfaceForms) {
                    try {
                        document = this.replaceSubjectWithSurfaceForms((Document)document, s);
                        SFchange = true;
                    }
                    catch (IOException iOException) {
                        LOGGER.error("Couldn't replace Subject by SF. Aborting.", (Throwable)iOException);
                    }
                }
                subDocs.add(document);
                oldSubject = subject;
                continue;
            }
            LOGGER.info("One of the triples couldn't be translated. It will be ignored. triple={}", (Object)s);
        }
        document = new DocumentImpl();
        StringBuilder textBuilder = new StringBuilder();
        for (Document document2 : subDocs) {
            if (textBuilder.length() > 0) {
                textBuilder.append(' ');
            }
            for (NamedEntity ne : document2.getMarkings(NamedEntity.class)) {
                ne.setStartPosition(ne.getStartPosition() + textBuilder.length());
                document.addMarking((Marking)ne);
            }
            textBuilder.append(document2.getText());
            textBuilder.append(' ');
        }
        document.setText(textBuilder.toString());
        document.addMarking((Marking)new NumberOfVerbalizedTriples(subDocs.size()));
        SFchange = false;
        return document;
    }

    private boolean annotateDocument(Document document, Statement s) {
        if (s.getObject().isResource()) {
            return this.annotateDocument(document, s.getSubject(), s.getObject().asResource());
        }
        return this.annotateDocument(document, s.getSubject());
    }

    public void replaceSubjectWithPronoun(Document document, String subjectUri) {
        MeaningSpan marking = DocumentHelper.searchFirstOccurrence(subjectUri, document);
        if (marking == null) {
            return;
        }
        String documentText = document.getText();
        String pronoun = null;
        int start = marking.getStartPosition();
        int length = marking.getLength();
        int end = start + length;
        boolean possessiveForm = false;
        if (documentText.charAt(end - 2) == '\'' && documentText.charAt(end - 1) == 's') {
            possessiveForm = true;
        } else if (end + 1 < documentText.length() && documentText.charAt(end) == '\'') {
            possessiveForm = true;
            length = documentText.charAt(end + 1) == 's' ? (length += 2) : ++length;
        }
        String type = this.getType(subjectUri);
        if (type != null) {
            if (type.equals("http://dbpedia.org/ontology/Person")) {
                String commentString = this.getGender(subjectUri);
                if (commentString.contains(" he ") || commentString.contains("He ") || commentString.contains(" his ")) {
                    pronoun = possessiveForm ? (start == 0 ? "His" : "his") : (start == 0 ? "He" : "he");
                } else if (commentString.contains(" she ") || commentString.contains("She ") || commentString.contains(" her ")) {
                    pronoun = possessiveForm ? (start == 0 ? "Her" : "her") : (start == 0 ? "She" : "she");
                }
            } else if (possessiveForm) {
                pronoun = start == 0 ? "Its" : "its";
            } else {
                String string = pronoun = start == 0 ? "It" : "it";
            }
        }
        if (pronoun == null) {
            return;
        }
        document.getMarkings().remove(marking);
        DocumentHelper.replaceText(document, start, length, pronoun);
    }

    private Document replaceSubjectWithSurfaceForms(Document document, Statement statements) throws IOException {
        MeaningSpan marking = DocumentHelper.searchFirstOccurrence(statements.getSubject().toString(), document);
        if (marking == null) {
            return document;
        }
        String oldText = document.getText();
        int start = marking.getStartPosition();
        int length = marking.getLength();
        int end = start + length;
        List oldEntities = document.getMarkings(MeaningSpan.class);
        HashMap<MeaningSpan, String> entities = new HashMap<MeaningSpan, String>();
        for (MeaningSpan meaning : oldEntities) {
            entities.put(meaning, oldText.substring(meaning.getStartPosition(), meaning.getStartPosition() + meaning.getLength()));
        }
        String oldLabel = oldText.substring(start, end);
        DocumentImpl newDoc = null;
        Map<String, String> labelsToUris = this.getLabelsForResources(statements);
        Object[] labels = labelsToUris.keySet().toArray(new String[labelsToUris.size()]);
        Arrays.sort(labels);
        BitSet blockedPositions = new BitSet((long)document.getText().length());
        block1: for (int i = 0; i < labels.length; ++i) {
            int pos;
            Object label = labels[i];
            if (((String)label).equals("")) {
                return document;
            }
            String uri = labelsToUris.get(label);
            String newText = document.getText().replace(oldLabel, (CharSequence)label);
            BitSet currentPositions = new BitSet((long)newText.length());
            newDoc = new DocumentImpl(newText, document.getDocumentURI());
            do {
                if ((pos = newText.indexOf((String)label, start)) < 0) continue;
                currentPositions.clear();
                currentPositions.set((long)pos, (long)(pos + ((String)label).length()));
                if (BitSet.intersectionCount((BitSet)blockedPositions, (BitSet)currentPositions) != 0L) continue;
                newDoc.addMarking((Marking)new NamedEntity(pos, ((String)label).length(), uri));
                blockedPositions.or(currentPositions);
                continue block1;
            } while (pos >= 0);
        }
        int position = 0;
        Iterator it = entities.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry pair = it.next();
            MeaningSpan span = (MeaningSpan)pair.getKey();
            String value = pair.getValue().toString();
            position = newDoc.getText().indexOf(value);
            if (position != -1) {
                newDoc.addMarking((Marking)new NamedEntity(position, value.length(), span.getUri()));
            }
            it.remove();
        }
        return newDoc;
    }

    private Map<String, String> getLabelsForResources(Statement statements) throws IOException {
        HashMap<String, String> labelsToUris = new HashMap<String, String>();
        String uri = statements.getSubject().getURI();
        String label = this.getSurfaceForm(uri);
        if (label != null) {
            labelsToUris.put(label, uri);
        }
        return labelsToUris;
    }

    private String getSurfaceForm(String resource) throws IOException {
        try {
            Properties prop = new Properties();
            FileInputStream input = new FileInputStream("/Users/diegomoussallem/Desktop/BENGAL-master/src/main/resources/config/bengal.properties");
            prop.load(input);
            String surfaceFormTSV = prop.getProperty("surfaceForms");
            File file = new File(surfaceFormTSV);
            String label = "";
            LOGGER.info("Start parsing: " + file);
            BufferedReader br = new BufferedReader(new FileReader(file));
            while (br.ready()) {
                String[] line = br.readLine().split("\t");
                String subject = line[0];
                String object = line[1];
                if (!subject.equals(resource)) continue;
                label = object;
                break;
            }
            br.close();
            LOGGER.info("SurfaceFormChanger worked");
            return label;
        }
        catch (Exception e) {
            LOGGER.error("Got exception from SurfaceFormChanger. Using the original document.", (Throwable)e);
            return "";
        }
    }

    private String getType(String uri) {
        if (uri.equals(RDF.type.getURI())) {
            return "type";
        }
        if (uri.equals(RDFS.label.getURI())) {
            return "label";
        }
        try {
            String labelQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX dbr: <http://dbpedia.org/resource/> PREFIX dbo: <http://dbpedia.org/ontology/> PREFIX owl: <http://www.w3.org/2002/07/owl#> SELECT  DISTINCT ?lcs WHERE { ?lcs ^rdf:type <" + uri + ">." + "?lcs rdfs:subClassOf ?x." + "?x rdfs:subClassOf owl:Thing." + "?lcs rdfs:label []." + "}";
            ResultSetRewindable results = new SparqlQuery(labelQuery, this.endpoint).send();
            String label = null;
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                label = soln.getResource("lcs").toString();
            }
            return label;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getGender(String uri) {
        if (uri.equals(RDF.type.getURI())) {
            return "type";
        }
        if (uri.equals(RDFS.label.getURI())) {
            return "label";
        }
        try {
            String labelQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>PREFIX dbr: <http://dbpedia.org/resource/>PREFIX dbo: <http://dbpedia.org/ontology/>PREFIX owl: <http://www.w3.org/2002/07/owl#>SELECT  DISTINCT ?com WHERE { <" + uri + "> rdfs:comment ?com." + "FILTER (lang(?com) = 'en')." + "}";
            ResultSetRewindable results = new SparqlQuery(labelQuery, this.endpoint).send();
            String label = null;
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                label = soln.getLiteral("com").getLexicalForm();
            }
            return label;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getEnglishLabel(String resource) {
        if (resource.equals(RDF.type.getURI())) {
            return "type";
        }
        if (resource.equals(RDFS.label.getURI())) {
            return "label";
        }
        try {
            String labelQuery = "SELECT ?label WHERE {<" + resource + "> " + "<http://www.w3.org/2000/01/rdf-schema#label> ?label. FILTER (lang(?label) = 'en')}";
            ResultSetRewindable results = new SparqlQuery(labelQuery, this.endpoint).send();
            String label = null;
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                label = soln.getLiteral("label").getLexicalForm();
            }
            return label;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean annotateDocument(Document document, Resource resource) {
        String label = this.getEnglishLabel(resource.getURI());
        if (label == null) {
            LOGGER.info("Couldn't find an English label for " + resource.toString() + ". Returning null.");
            return false;
        }
        String text = document.getText();
        int pos = text.indexOf(label);
        if (pos < 0) {
            LOGGER.info("Couldn't find the label \"{}\" inside the given text \"{}\". Returning false.", (Object)label, (Object)text);
        } else {
            document.addMarking((Marking)new NamedEntity(pos, label.length(), resource.getURI()));
        }
        return true;
    }

    private boolean annotateDocument(Document document, Resource subject, Resource object) {
        Resource r2;
        Resource r1;
        String label1 = this.getEnglishLabel(subject.getURI());
        if (label1 == null) {
            LOGGER.info("Couldn't find an English label for " + subject.toString() + ". Returning null.");
            return false;
        }
        String label2 = this.getEnglishLabel(object.getURI());
        if (label2 == null) {
            LOGGER.info("Couldn't find an English label for " + object.toString() + ". Returning null.");
            return false;
        }
        if (label1.length() > label2.length()) {
            r1 = subject;
            r2 = object;
        } else {
            String temp = label1;
            label1 = label2;
            label2 = temp;
            r2 = subject;
            r1 = object;
        }
        String text = document.getText();
        BitSet blockedPositions = new BitSet((long)text.length());
        int pos1 = text.indexOf(label1);
        if (pos1 < 0) {
            LOGGER.info("Couldn't find the label \"{}\" inside the given text \"{}\". Returning false.", (Object)label1, (Object)text);
        } else {
            document.addMarking((Marking)new NamedEntity(pos1, label1.length(), r1.getURI()));
            blockedPositions.set((long)pos1, (long)(pos1 + label1.length()));
        }
        int pos2 = -label2.length();
        do {
            if ((pos2 = text.indexOf(label2, pos2 + label2.length())) >= 0) continue;
            LOGGER.info("Couldn't find the label \"{}\" inside the given text \"{}\". Returning false.", (Object)label1, (Object)text);
            return false;
        } while (blockedPositions.get(pos2) || blockedPositions.get(pos2 + label2.length()));
        document.addMarking((Marking)new NamedEntity(pos2, label2.length(), r2.getURI()));
        return true;
    }

    public static void main(String[] args) {
        HashSet<String> classes = new HashSet<String>();
        classes.add("<http://dbpedia.org/ontology/Person>");
        classes.add("<http://dbpedia.org/ontology/Place>");
        classes.add("<http://dbpedia.org/ontology/Organisation>");
        SemWeb2NLVerbalizer verbalizer = new SemWeb2NLVerbalizer(SparqlEndpoint.getEndpointDBpedia(), true, true);
        List<Statement> stmts = Arrays.asList(new StatementImpl((Resource)new ResourceImpl("http://dbpedia.org/resource/Streaky_Bay,_South_Australia"), (Property)new PropertyImpl("http://dbpedia.org/property/fedgov"), (RDFNode)new ResourceImpl("http://dbpedia.org/resource/Division_of_Grey")), new StatementImpl((Resource)new ResourceImpl("http://dbpedia.org/resource/Streaky_Bay,_South_Australia"), (Property)new PropertyImpl("http://dbpedia.org/property/location"), (RDFNode)new ResourceImpl("http://dbpedia.org/resource/Adelaide")), new StatementImpl((Resource)new ResourceImpl("http://dbpedia.org/resource/Streaky_Bay,_South_Australia"), (Property)new PropertyImpl("http://dbpedia.org/ontology/country"), (RDFNode)new ResourceImpl("http://dbpedia.org/resource/Australia")));
        Document doc = verbalizer.generateDocument(stmts);
        System.out.println(doc);
    }

    @Override
    public int compare(NamedEntity n1, NamedEntity n2) {
        int diff = n1.getLength() - n2.getLength();
        if (diff < 0) {
            return 1;
        }
        if (diff > 0) {
            return -1;
        }
        return 0;
    }
}

