/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.verbalizer;

import com.carrotsearch.hppc.BitSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.aksw.gerbil.transfer.nif.Document;
import org.aksw.gerbil.transfer.nif.Marking;
import org.aksw.gerbil.transfer.nif.data.DocumentImpl;
import org.aksw.gerbil.transfer.nif.data.NamedEntity;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.delay.core.QueryExecutionFactoryDelay;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.simba.bengal.selector.ResourceComparator;
import org.aksw.simba.bengal.selector.StatementComparator;
import org.aksw.simba.bengal.triple2nl.converter.DefaultIRIConverter;
import org.aksw.simba.bengal.triple2nl.converter.IRIConverter;
import org.aksw.simba.bengal.verbalizer.Verbalizer;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.dllearner.kb.sparql.SparqlEndpoint;
import org.dllearner.kb.sparql.SparqlQuery;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.manchester.cs.owl.owlapi.OWLNamedIndividualImpl;

public class AvatarVerbalizer
implements Comparator<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AvatarVerbalizer.class);
    private static final int DELAY = 200;
    private static final long CACHE_TIME_TO_LIVE = 2678400000L;
    private static final String CACHE_DIRECTORY = "./cache";
    private Set<String> targetClasses;
    private boolean useSymmetricCbd = false;
    private Set<String> sourceClasses;
    private List<Resource> resources;
    private Random r;
    private IRIConverter uriConverter;
    protected Verbalizer verbalizer;
    protected QueryExecutionFactory qef;

    public static AvatarVerbalizer create(Set<String> sourceClasses, Set<String> targetClasses, String endpoint, String graph, long seed, boolean useSymmetricCbd) {
        try {
            QueryExecutionFactory qef = AvatarVerbalizer.initQueryExecution(endpoint, graph, CACHE_DIRECTORY);
            return new AvatarVerbalizer(sourceClasses, targetClasses, endpoint, graph, seed, useSymmetricCbd, qef);
        }
        catch (Exception e) {
            LOGGER.error("Couldn't create SPARQL query factory. Returning null.", (Throwable)e);
            return null;
        }
    }

    protected AvatarVerbalizer(Set<String> sourceClasses, Set<String> targetClasses, String endpoint, String graph, long seed, boolean useSymmetricCbd, QueryExecutionFactory qef) {
        this.useSymmetricCbd = useSymmetricCbd;
        this.targetClasses = targetClasses;
        this.sourceClasses = sourceClasses;
        this.resources = null;
        this.r = new Random(seed);
        this.verbalizer = new Verbalizer(SparqlEndpoint.getEndpointDBpedia(), CACHE_DIRECTORY);
        this.qef = qef;
        this.uriConverter = new DefaultIRIConverter(qef, CACHE_DIRECTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Statement> getSymmetricCBD(Resource res, Set<String> targetClasses) {
        Model m = ModelFactory.createDefaultModel();
        String sparqlQueryString = "";
        try (QueryExecution qexec = null;){
            Property p;
            Object qs;
            if (targetClasses != null) {
                if (targetClasses.isEmpty()) {
                    sparqlQueryString = "SELECT ?p ?o WHERE {<" + res + "> ?p ?o. ?o <http://www.w3.org/2000/01/rdf-schema#label> []. }";
                } else {
                    sparqlQueryString = "SELECT ?p ?o WHERE {";
                    sparqlQueryString = sparqlQueryString + " {<" + res + "> ?p ?o. ?o <http://www.w3.org/2000/01/rdf-schema#label> [].}";
                    for (String c : targetClasses) {
                        sparqlQueryString = sparqlQueryString + "{ ?o a " + c + ". ?o <http://www.w3.org/2000/01/rdf-schema#label> [].} UNION ";
                    }
                    sparqlQueryString = sparqlQueryString.substring(0, sparqlQueryString.length() - 6);
                    sparqlQueryString = sparqlQueryString + " }";
                }
            }
            qexec = this.qef.createQueryExecution(sparqlQueryString);
            ResultSet cbd = qexec.execSelect();
            while (cbd.hasNext()) {
                qs = cbd.nextSolution();
                p = m.createProperty(qs.get("p").asResource().getURI());
                if (qs.get("o").isLiteral()) {
                    m.add(res, p, (RDFNode)qs.getLiteral("o"));
                    continue;
                }
                m.add(res, p, (RDFNode)qs.getResource("o"));
            }
            qexec.close();
            if (targetClasses != null) {
                if (targetClasses.isEmpty()) {
                    sparqlQueryString = "SELECT ?p ?o WHERE {<" + res + "> ?p ?o. ?o <http://www.w3.org/2000/01/rdf-schema#label> [].}";
                } else {
                    sparqlQueryString = "SELECT ?p ?o WHERE {";
                    sparqlQueryString = sparqlQueryString + " {?o ?p <" + res + ">. ?o <http://www.w3.org/2000/01/rdf-schema#label> [].}";
                    for (String c : targetClasses) {
                        sparqlQueryString = sparqlQueryString + "{ ?o a " + c + ". ?o <http://www.w3.org/2000/01/rdf-schema#label> [].} UNION ";
                    }
                    sparqlQueryString = sparqlQueryString.substring(0, sparqlQueryString.length() - 6);
                    sparqlQueryString = sparqlQueryString + " }";
                }
            }
            qexec = this.qef.createQueryExecution(sparqlQueryString);
            cbd = qexec.execSelect();
            while (cbd.hasNext()) {
                qs = cbd.nextSolution();
                p = m.createProperty(qs.get("p").asResource().getURI());
                m.add(qs.getResource("o"), p, (RDFNode)res);
            }
        }
        return this.sortStatements(m.listStatements());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Statement> getCBD(Resource res, Set<String> targetClasses) {
        Model m = ModelFactory.createDefaultModel();
        String sparqlQueryString = "";
        try (QueryExecution qexec = null;){
            if (targetClasses != null) {
                if (targetClasses.isEmpty()) {
                    sparqlQueryString = "SELECT ?p ?o WHERE {<" + res + "> ?p ?o. ?o <http://www.w3.org/2000/01/rdf-schema#label> [].}";
                } else {
                    sparqlQueryString = "SELECT ?p ?o WHERE {";
                    sparqlQueryString = sparqlQueryString + " {<" + res + "> ?p ?o. ?o <http://www.w3.org/2000/01/rdf-schema#label> [].}";
                    for (String c : targetClasses) {
                        sparqlQueryString = sparqlQueryString + "{ ?o a " + c + ". ?o <http://www.w3.org/2000/01/rdf-schema#label> [].} UNION ";
                    }
                    sparqlQueryString = sparqlQueryString.substring(0, sparqlQueryString.length() - 6);
                    sparqlQueryString = sparqlQueryString + " }";
                }
            }
            qexec = this.qef.createQueryExecution(sparqlQueryString);
            ResultSet cbd = qexec.execSelect();
            while (cbd.hasNext()) {
                QuerySolution qs = cbd.nextSolution();
                Property p = m.createProperty(qs.get("p").asResource().getURI());
                if (qs.get("o").isLiteral()) {
                    m.add(res, p, (RDFNode)qs.getLiteral("o"));
                    continue;
                }
                m.add(res, p, (RDFNode)qs.getResource("o"));
            }
        }
        return this.sortStatements(m.listStatements());
    }

    protected List<Statement> sortStatements(StmtIterator stmtIterator) {
        ArrayList<Statement> result = new ArrayList<Statement>();
        while (stmtIterator.hasNext()) {
            result.add((Statement)stmtIterator.next());
        }
        Collections.sort(result, new StatementComparator());
        return result;
    }

    protected List<Statement> sortStatements(Set<Statement> statements) {
        ArrayList<Statement> result = new ArrayList<Statement>(statements);
        Collections.sort(result, new StatementComparator());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Resource> getResources(Set<String> classes) {
        String query = "";
        if (classes != null) {
            if (classes.isEmpty()) {
                query = "SELECT ?s WHERE {?s a ?x.} ORDER BY DESC(?s)";
            } else {
                query = "SELECT ?x WHERE {";
                for (String c : classes) {
                    query = query + "{ ?x a " + c + ". } UNION ";
                }
                query = query.substring(0, query.length() - 6);
                query = query + " {?x ?p ?y} ";
                for (String c : classes) {
                    query = query + "{ ?y a " + c + ". } UNION ";
                }
                query = query.substring(0, query.length() - 6);
                query = query + " }";
            }
        }
        Query sparqlQuery = QueryFactory.create((String)query, (Syntax)Syntax.syntaxARQ);
        ArrayList<Resource> result = new ArrayList<Resource>();
        try (QueryExecution qexec = null;){
            qexec = this.qef.createQueryExecution(sparqlQuery);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution solution = results.next();
                try {
                    Resource r = solution.getResource("x");
                    result.add(r);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.sortResources(result);
        return result;
    }

    protected void sortResources(List<Resource> resources) {
        Collections.sort(resources, new ResourceComparator());
    }

    protected List<Statement> getTriples(Resource r) {
        if (this.useSymmetricCbd) {
            return this.getSymmetricCBD(r, this.targetClasses);
        }
        return this.getCBD(r, this.targetClasses);
    }

    public Document nextDocument() {
        if (this.resources == null) {
            this.resources = this.getResources(this.sourceClasses);
        }
        DocumentImpl document = null;
        while (document == null) {
            int counter = Math.abs(this.r.nextInt() % this.resources.size());
            OWLNamedIndividualImpl ind = new OWLNamedIndividualImpl(IRI.create((String)this.resources.get(counter).getURI()));
            String text = this.verbalizer.summarize((OWLIndividual)ind);
            List<Statement> statements = this.getTriples(this.resources.get(counter));
            if (statements == null) continue;
            document = new DocumentImpl(text);
            Map<String, String> labelsToUris = this.getLabelsForResources(statements);
            String[] labels = labelsToUris.keySet().toArray(new String[labelsToUris.size()]);
            Arrays.sort(labels, this);
            BitSet blockedPositions = new BitSet((long)text.length());
            BitSet currentPositions = new BitSet((long)text.length());
            for (int i = 0; i < labels.length; ++i) {
                String label = labels[i];
                String uri = labelsToUris.get(label);
                int pos = -label.length();
                do {
                    if ((pos = text.indexOf(label, pos + label.length())) < 0) continue;
                    currentPositions.clear();
                    currentPositions.set((long)pos, (long)(pos + label.length()));
                    if (BitSet.intersectionCount((BitSet)blockedPositions, (BitSet)currentPositions) != 0L) continue;
                    document.addMarking((Marking)new NamedEntity(pos, label.length(), uri));
                    blockedPositions.or(currentPositions);
                } while (pos >= 0);
            }
        }
        return document;
    }

    private Map<String, String> getLabelsForResources(List<Statement> statements) {
        HashMap<String, String> labelsToUris = new HashMap<String, String>();
        for (Statement statement : statements) {
            String uri = statement.getSubject().getURI();
            String label = this.getEnglishLabel(uri);
            if (label != null) {
                labelsToUris.put(label, uri);
            }
            if ((label = this.uriConverter.convert(uri)) != null) {
                labelsToUris.put(label, uri);
            }
            if (!statement.getObject().isResource()) continue;
            uri = statement.getObject().asResource().getURI();
            label = this.getEnglishLabel(uri);
            if (label != null) {
                labelsToUris.put(label, uri);
            }
            if ((label = this.uriConverter.convert(uri)) == null) continue;
            labelsToUris.put(label, uri);
        }
        return labelsToUris;
    }

    private String getEnglishLabel(String resource) {
        if (resource.equals(RDF.type.getURI())) {
            return "type";
        }
        if (resource.equals(RDFS.label.getURI())) {
            return "label";
        }
        try {
            String labelQuery = "SELECT ?label WHERE {<" + resource + "> " + "<http://www.w3.org/2000/01/rdf-schema#label> ?label. FILTER (lang(?label) = 'en')}";
            ResultSetRewindable results = new SparqlQuery(labelQuery, SparqlEndpoint.getEndpointDBpedia()).send();
            String label = null;
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                label = soln.getLiteral("label").getLexicalForm();
            }
            return label;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int compare(String s1, String s2) {
        int diff = s1.length() - s2.length();
        if (diff < 0) {
            return 1;
        }
        if (diff > 0) {
            return -1;
        }
        return 0;
    }

    protected static QueryExecutionFactory initQueryExecution(String endpoint, String graph, String cacheDirectory) throws ClassNotFoundException, SQLException {
        QueryExecutionFactoryHttp qef = graph != null ? new QueryExecutionFactoryHttp(endpoint, graph) : new QueryExecutionFactoryHttp(endpoint);
        qef = new QueryExecutionFactoryDelay((QueryExecutionFactory)qef, 200L);
        return qef;
    }
}

