/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.utils;

import java.util.List;
import org.aksw.gerbil.transfer.nif.Document;
import org.aksw.gerbil.transfer.nif.MeaningSpan;
import org.aksw.gerbil.transfer.nif.Span;

public class DocumentHelper {
    public static MeaningSpan searchFirstOccurrence(String uri, Document document) {
        List entities = document.getMarkings(MeaningSpan.class);
        MeaningSpan result = null;
        for (MeaningSpan marking : entities) {
            if (!marking.containsUri(uri) || result != null && marking.getStartPosition() >= result.getStartPosition()) continue;
            result = marking;
        }
        return result;
    }

    public static void replaceText(Document document, int start, int length, String replacement) {
        if (start < 0) {
            throw new IllegalArgumentException("Negative start position (s=" + start + ").");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Negative length (l=" + length + ").");
        }
        int diff = replacement.length() - length;
        int end = start + length;
        String text = document.getText();
        if (end > text.length()) {
            throw new IllegalArgumentException("The given Span(s=" + start + ",l=" + length + ") is outside of the bounds of the document text (l=" + text.length() + ").");
        }
        if (diff != 0) {
            List spans = document.getMarkings(Span.class);
            for (Span span : spans) {
                if (span.getStartPosition() < end) continue;
                span.setStartPosition(span.getStartPosition() + diff);
            }
        }
        StringBuilder builder = new StringBuilder(text.length() + diff);
        builder.append(text.substring(0, start));
        builder.append(replacement);
        builder.append(text.substring(end));
        document.setText(builder.toString());
    }
}

