/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.triple2nl.util;

import java.util.ArrayList;
import java.util.List;
import net.sf.extjwnl.JWNLException;
import net.sf.extjwnl.data.IndexWord;
import net.sf.extjwnl.data.POS;
import net.sf.extjwnl.data.Pointer;
import net.sf.extjwnl.data.PointerType;
import net.sf.extjwnl.data.Synset;
import net.sf.extjwnl.data.Word;
import net.sf.extjwnl.dictionary.Dictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordNetUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(WordNetUtils.class);
    private Dictionary dict;

    public WordNetUtils() {
        try {
            this.dict = Dictionary.getDefaultResourceInstance();
        }
        catch (JWNLException e) {
            e.printStackTrace();
        }
    }

    public String getDerivedAdjective(String noun) {
        try {
            IndexWord nounIW = this.dict.lookupIndexWord(POS.NOUN, noun);
            List senses = nounIW.getSenses();
            Synset mainSense = (Synset)senses.get(0);
            List pointers = mainSense.getPointers(PointerType.DERIVATION);
            for (Pointer pointer : pointers) {
                Synset derivedSynset = pointer.getTargetSynset();
                if (derivedSynset.getPOS() == POS.ADJECTIVE) {
                    // empty if block
                }
                if (derivedSynset.getPOS() != POS.VERB) continue;
                System.out.println(derivedSynset);
            }
        }
        catch (JWNLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<String> getAllSynsets(String word) {
        ArrayList<String> synsets = new ArrayList<String>();
        try {
            IndexWord iw = this.dict.getIndexWord(POS.NOUN, word);
            if (iw != null) {
                for (Synset synset : iw.getSenses()) {
                    synsets.add("NOUN " + ((Word)synset.getWords().get(0)).getLemma());
                }
            }
            if ((iw = this.dict.getIndexWord(POS.VERB, word)) != null) {
                for (Synset synset : iw.getSenses()) {
                    synsets.add("VERB " + ((Word)synset.getWords().get(0)).getLemma());
                }
            }
        }
        catch (JWNLException e) {
            LOGGER.error("WordNet lookup failed.", (Throwable)e);
        }
        return synsets;
    }

    public static void main(String[] args) throws Exception {
        String[] nouns = new String[]{"female", "male", "person", "book", "actor"};
        WordNetUtils utils = new WordNetUtils();
        for (String noun : nouns) {
            System.out.println(noun + ":");
            System.out.println(utils.getDerivedAdjective(noun));
        }
    }
}

