/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.triple2nl.property;

import org.aksw.simba.bengal.triple2nl.property.PropertyVerbalizationType;
import simplenlg.features.Tense;

public class PropertyVerbalization {
    private PropertyVerbalizationType verbalizationType;
    private String propertyURI;
    private String propertyText;
    private String expandedVerbalization;
    private String posTags;
    private Tense tense = Tense.PRESENT;

    public PropertyVerbalization(String propertyURI, String propertyText, PropertyVerbalizationType verbalizationType) {
        this(propertyURI, propertyText, null, verbalizationType);
    }

    public PropertyVerbalization(String propertyURI, String propertyText, String posTags, PropertyVerbalizationType verbalizationType) {
        this.propertyURI = propertyURI;
        this.propertyText = propertyText;
        this.posTags = posTags;
        this.verbalizationType = verbalizationType;
        this.expandedVerbalization = propertyText;
    }

    public String getProperty() {
        return this.propertyURI;
    }

    public String getVerbalizationText() {
        return this.propertyText;
    }

    public String getExpandedVerbalizationText() {
        return this.expandedVerbalization;
    }

    public PropertyVerbalizationType getVerbalizationType() {
        return this.verbalizationType;
    }

    public Tense getTense() {
        return this.tense;
    }

    public void setTense(Tense tense) {
        this.tense = tense;
    }

    public void setVerbalizationType(PropertyVerbalizationType verbalizationType) {
        this.verbalizationType = verbalizationType;
    }

    public String getPOSTags() {
        return this.posTags;
    }

    public void setExpandedVerbalizationText(String expandedVerbalization) {
        this.expandedVerbalization = expandedVerbalization;
    }

    public boolean isNounType() {
        return this.verbalizationType == PropertyVerbalizationType.NOUN;
    }

    public boolean isVerbType() {
        return this.verbalizationType == PropertyVerbalizationType.VERB;
    }

    public boolean isUnspecifiedType() {
        return !this.isVerbType() && !this.isNounType();
    }

    public String toString() {
        return "URI:" + this.propertyURI + "\nText:" + this.propertyText + "\nExpanded Text:" + this.expandedVerbalization + "\nType: " + (Object)((Object)this.verbalizationType);
    }
}

