/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.triple2nl.converter;

import com.google.common.base.Joiner;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.stream.Collectors;
import org.aksw.simba.bengal.triple2nl.converter.DefaultIRIConverter;
import org.aksw.simba.bengal.triple2nl.converter.IRIConverter;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.IllegalDateTimeFieldException;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.XSDDateTime;
import org.apache.jena.datatypes.xsd.impl.RDFLangString;
import org.apache.jena.datatypes.xsd.impl.XSDAbstractDateTimeType;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.rdf.model.Literal;
import org.dllearner.kb.sparql.SparqlEndpoint;
import org.dllearner.utilities.OwlApiJenaUtils;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteralConverter {
    private static final Locale ENGLISH_LOCAL = Locale.UK;
    private static final Logger logger = LoggerFactory.getLogger(LiteralConverter.class);
    private IRIConverter iriConverter;
    private DateFormat dateFormat = DateFormat.getDateInstance(1, ENGLISH_LOCAL);
    private boolean encapsulateStringLiterals = true;

    public LiteralConverter(IRIConverter iriConverter) {
        this.iriConverter = iriConverter;
    }

    public String convert(OWLLiteral lit) {
        return this.convert(OwlApiJenaUtils.getLiteral((OWLLiteral)lit));
    }

    public String convert(Literal lit) {
        return this.convert(NodeFactory.createLiteral((String)lit.getLexicalForm(), (String)lit.getLanguage(), (RDFDatatype)lit.getDatatype()).getLiteral());
    }

    public String convert(LiteralLabel lit) {
        RDFDatatype dt = lit.getDatatype();
        String s = lit.getLexicalForm();
        if (dt == null || dt instanceof RDFLangString) {
            s = lit.getLexicalForm();
            s = s.replaceAll("_", " ");
            if (this.encapsulateStringLiterals) {
                s = '\"' + s + '\"';
            }
        } else if (dt instanceof XSDDatatype) {
            if (dt instanceof XSDAbstractDateTimeType) {
                s = this.convertDateLiteral(lit);
            } else if (this.encapsulateStringLiterals && dt.equals(XSDDatatype.XSDstring)) {
                s = '\"' + s + '\"';
            }
        } else {
            String text = this.iriConverter.convert(dt.getURI(), false).toLowerCase();
            String[] split = StringUtils.splitByCharacterTypeCamelCase((String)text.trim());
            String datatype = Joiner.on((String)" ").join((Iterable)Arrays.asList(split).stream().filter(str -> !str.trim().isEmpty()).collect(Collectors.toList()));
            s = lit.getLexicalForm() + " " + datatype;
        }
        return s;
    }

    private String convertDateLiteral(LiteralLabel lit) {
        RDFDatatype dt = lit.getDatatype();
        String s = lit.getLexicalForm();
        try {
            Object value = lit.getValue();
            if (value instanceof XSDDateTime) {
                Calendar calendar = ((XSDDateTime)value).asCalendar();
                s = dt.equals(XSDDatatype.XSDgMonth) ? calendar.getDisplayName(2, 2, ENGLISH_LOCAL) : (dt.equals(XSDDatatype.XSDgMonthDay) ? calendar.get(5) + calendar.getDisplayName(2, 2, ENGLISH_LOCAL) : (dt.equals(XSDDatatype.XSDgYearMonth) ? calendar.getDisplayName(2, 2, ENGLISH_LOCAL) + " " + calendar.get(1) : (dt.equals(XSDDatatype.XSDgYear) ? "" + calendar.get(1) : calendar.getDisplayName(2, 2, ENGLISH_LOCAL) + " " + calendar.get(5) + ", " + calendar.get(1))));
            }
        }
        catch (DatatypeFormatException | IllegalDateTimeFieldException e) {
            logger.error("Conversion of date literal " + lit + " failed. Reason: " + e.getMessage());
            try {
                DateTime time = ISODateTimeFormat.dateTimeParser().parseDateTime(lit.getLexicalForm());
                s = time.toString("MMMM dd, yyyy");
            }
            catch (Exception e1) {
                try {
                    DateTime time = ISODateTimeFormat.localDateParser().parseDateTime(lit.getLexicalForm());
                    s = time.toString("MMMM dd, yyyy");
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    DateTime time = ISODateTimeFormat.dateParser().parseDateTime(lit.getLexicalForm());
                    s = time.toString("MMMM dd, yyyy");
                }
            }
        }
        return s;
    }

    public boolean isPlural(LiteralLabel lit) {
        boolean singular = false;
        double value = 0.0;
        try {
            value = Integer.parseInt(lit.getLexicalForm());
            singular = value == 0.0;
        }
        catch (NumberFormatException e) {
            try {
                value = Double.parseDouble(lit.getLexicalForm());
                singular = value == 0.0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        boolean isPlural = lit.getDatatypeURI() != null && !(lit.getDatatype() instanceof RDFLangString) && !(lit.getDatatype() instanceof XSDDatatype) && !singular;
        return isPlural;
    }

    public void setEncapsulateStringLiterals(boolean encapsulateStringLiterals) {
        this.encapsulateStringLiterals = encapsulateStringLiterals;
    }

    public String getMonthName(int month) {
        return new DateFormatSymbols().getMonths()[month - 1];
    }

    public static void main(String[] args) {
        LiteralConverter conv = new LiteralConverter(new DefaultIRIConverter(SparqlEndpoint.getEndpointDBpediaLiveAKSW()));
        LiteralLabel lit = NodeFactory.createLiteral((String)"1869-06-27", null, (RDFDatatype)XSDDatatype.XSDdate).getLiteral();
        System.out.println(lit + " --> " + conv.convert(lit));
        lit = NodeFactory.createLiteral((String)"1914-01-01T00:00:00+02:00", null, (RDFDatatype)XSDDatatype.XSDgYear).getLiteral();
        System.out.println(lit + " --> " + conv.convert(lit));
        lit = NodeFactory.createLiteral((String)"--04", null, (RDFDatatype)XSDDatatype.XSDgMonth).getLiteral();
        System.out.println(lit + " --> " + conv.convert(lit));
    }
}

