/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.triple2nl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.simba.bengal.triple2nl.TripleConverter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.dllearner.kb.sparql.SparqlEndpoint;
import org.jgrapht.alg.ConnectivityInspector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import simplenlg.framework.CoordinatedPhraseElement;
import simplenlg.framework.DocumentElement;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGFactory;
import simplenlg.lexicon.Lexicon;
import simplenlg.phrasespec.SPhraseSpec;
import simplenlg.realiser.english.Realiser;

public class DocumentGenerator {
    private TripleConverter tripleConverter;
    private NLGFactory nlgFactory;
    private Realiser realiser;
    private boolean useAsWellAsCoordination = true;

    public DocumentGenerator(SparqlEndpoint endpoint, String cacheDirectory) {
        this(endpoint, cacheDirectory, Lexicon.getDefaultLexicon());
    }

    public DocumentGenerator(SparqlEndpoint endpoint, String cacheDirectory, Lexicon lexicon) {
        this((QueryExecutionFactory)new QueryExecutionFactoryHttp(endpoint.getURL().toString(), (Collection)endpoint.getDefaultGraphURIs()), cacheDirectory, lexicon);
    }

    public DocumentGenerator(QueryExecutionFactory qef, String cacheDirectory, Lexicon lexicon) {
        this.tripleConverter = new TripleConverter(qef, null, null, cacheDirectory, null, lexicon);
        this.nlgFactory = new NLGFactory(lexicon);
        this.realiser = new Realiser(lexicon);
    }

    public String generateDocument(Model model) {
        Set<Triple> triples = this.asTriples(model);
        return this.generateDocument(triples);
    }

    private Set<Triple> asTriples(Model model) {
        HashSet<Triple> triples = new HashSet<Triple>((int)model.size());
        StmtIterator iterator = model.listStatements();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            triples.add(statement.asTriple());
        }
        return triples;
    }

    public String generateDocument(Set<Triple> documentTriples) {
        DefaultDirectedGraph<Node, DefaultEdge> graph = this.asGraph(documentTriples);
        ConnectivityInspector connectivityInspector = new ConnectivityInspector(graph);
        List connectedNodes = connectivityInspector.connectedSets();
        for (Set nodes : connectedNodes) {
            System.out.println(nodes);
        }
        Map<Node, Collection<Triple>> subject2Triples = this.groupBySubject(documentTriples);
        subject2Triples = this.sort(documentTriples, subject2Triples);
        ArrayList<DocumentElement> sentences = new ArrayList<DocumentElement>();
        for (Map.Entry<Node, Collection<Triple>> entry : subject2Triples.entrySet()) {
            Node subject = entry.getKey();
            Collection<Triple> triples = entry.getValue();
            CoordinatedPhraseElement conjunction = this.nlgFactory.createCoordinatedPhrase();
            HashSet<Triple> typeTriples = new HashSet<Triple>();
            HashSet<Triple> otherTriples = new HashSet<Triple>();
            for (Triple triple : triples) {
                if (triple.predicateMatches(RDF.type.asNode())) {
                    typeTriples.add(triple);
                    continue;
                }
                otherTriples.add(triple);
            }
            ArrayList typePhrases = this.tripleConverter.convertToPhrases(typeTriples);
            if (typePhrases.size() > 1) {
                CoordinatedPhraseElement combinedObject = this.nlgFactory.createCoordinatedPhrase();
                if (this.useAsWellAsCoordination) {
                    SPhraseSpec phrase1 = typePhrases.remove(typePhrases.size() - 1);
                    SPhraseSpec phrase2 = typePhrases.get(typePhrases.size() - 1);
                    CoordinatedPhraseElement combinedLastTwoObjects = this.nlgFactory.createCoordinatedPhrase((Object)phrase1.getObject(), (Object)phrase2.getObject());
                    combinedLastTwoObjects.setConjunction("as well as");
                    combinedLastTwoObjects.setFeature("raise_specifier", false);
                    combinedLastTwoObjects.setFeature("specifier", (Object)"a");
                    phrase2.setObject((Object)combinedLastTwoObjects);
                }
                Iterator<SPhraseSpec> iterator = typePhrases.iterator();
                SPhraseSpec representative = iterator.next();
                combinedObject.addCoordinate((Object)representative.getObject());
                while (iterator.hasNext()) {
                    SPhraseSpec phrase = iterator.next();
                    NLGElement object = phrase.getObject();
                    combinedObject.addCoordinate((Object)object);
                }
                combinedObject.setFeature("raise_specifier", true);
                representative.setObject((Object)combinedObject);
                typePhrases = Lists.newArrayList((Object[])new SPhraseSpec[]{representative});
            }
            for (SPhraseSpec phrase : typePhrases) {
                conjunction.addCoordinate((Object)phrase);
            }
            String placeHolderToken = typeTriples.isEmpty() || otherTriples.size() == 1 ? "it" : "whose";
            Node placeHolder = NodeFactory.createURI((String)("http://sparql2nl.aksw.org/placeHolder/" + placeHolderToken));
            ArrayList<Triple> placeHolderTriples = new ArrayList<Triple>(otherTriples.size());
            Iterator iterator = otherTriples.iterator();
            if (typeTriples.isEmpty() && iterator.hasNext()) {
                placeHolderTriples.add((Triple)iterator.next());
            }
            while (iterator.hasNext()) {
                Triple triple = (Triple)iterator.next();
                Triple newTriple = Triple.create((Node)placeHolder, (Node)triple.getPredicate(), (Node)triple.getObject());
                placeHolderTriples.add(newTriple);
            }
            List<SPhraseSpec> otherPhrases = this.tripleConverter.convertToPhrases(placeHolderTriples);
            for (SPhraseSpec phrase : otherPhrases) {
                conjunction.addCoordinate((Object)phrase);
            }
            DocumentElement sentence = this.nlgFactory.createSentence((NLGElement)conjunction);
            sentences.add(sentence);
        }
        DocumentElement paragraph = this.nlgFactory.createParagraph(sentences);
        String paragraphText = this.realiser.realise((NLGElement)paragraph).getRealisation();
        return paragraphText;
    }

    private Map<Node, Collection<Triple>> sort(Set<Triple> documentTriples, Map<Node, Collection<Triple>> subject2Triples) {
        LinkedHashMap<Node, Collection<Triple>> sortedTriples = new LinkedHashMap<Node, Collection<Triple>>();
        HashMultimap outgoing = HashMultimap.create();
        HashMultimap incoming = HashMultimap.create();
        for (Node subject : subject2Triples.keySet()) {
            for (Triple triple : documentTriples) {
                if (triple.subjectMatches(subject)) {
                    outgoing.put((Object)subject, (Object)triple.getObject());
                    continue;
                }
                if (!triple.objectMatches(subject)) continue;
                incoming.put((Object)subject, (Object)triple.getSubject());
            }
        }
        Iterator<Map.Entry<Node, Collection<Triple>>> iterator = subject2Triples.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Node, Collection<Triple>> entry = iterator.next();
            Node subject = entry.getKey();
            if (incoming.containsKey((Object)subject)) continue;
            sortedTriples.put(subject, new HashSet<Triple>(entry.getValue()));
            iterator.remove();
        }
        sortedTriples.putAll(subject2Triples);
        return sortedTriples;
    }

    private Map<Node, Collection<Triple>> groupBySubject(Set<Triple> triples) {
        HashMultimap subject2Triples = HashMultimap.create();
        for (Triple triple : triples) {
            subject2Triples.put((Object)triple.getSubject(), (Object)triple);
        }
        return subject2Triples.asMap();
    }

    private DefaultDirectedGraph<Node, DefaultEdge> asGraph(Set<Triple> triples) {
        DefaultDirectedGraph graph = new DefaultDirectedGraph(DefaultEdge.class);
        for (Triple triple : triples) {
            if (triple.predicateMatches(RDF.type.asNode())) continue;
            graph.addVertex((Object)triple.getSubject());
            graph.addVertex((Object)triple.getObject());
            graph.addEdge((Object)triple.getSubject(), (Object)triple.getObject());
        }
        return graph;
    }

    public static void main(String[] args) throws Exception {
        String triples = "@prefix : <http://dbpedia.org/resource/> .@prefix dbo: <http://dbpedia.org/ontology/> .@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .:Albert_Einstein a dbo:Physican, dbo:Philosopher;dbo:birthPlace :Ulm;dbo:birthDate \"1879-03-14\"^^xsd:date ;dbo:studiedIn :Frankfurt .:Ulm a dbo:City;dbo:country :Germany;dbo:federalState :Baden_W\u00fcrttemberg .:Leipzig a dbo:City;dbo:country :Germany;dbo:federalState :Saxony .";
        Model model = ModelFactory.createDefaultModel();
        model.read((InputStream)new ByteArrayInputStream(triples.getBytes()), null, "TURTLE");
        DocumentGenerator gen = new DocumentGenerator(SparqlEndpoint.getEndpointDBpedia(), "cache");
        String document = gen.generateDocument(model);
        System.out.println(document);
    }
}

