/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.selector;

import java.util.Set;
import org.aksw.simba.bengal.selector.HybridTripleSelector;
import org.aksw.simba.bengal.selector.PathBasedTripleSelector;
import org.aksw.simba.bengal.selector.SimpleSummarySelector;
import org.aksw.simba.bengal.selector.TripleSelector;

public class TripleSelectorFactory {
    public TripleSelector create(SelectorType type, Set<String> sourceClasses, Set<String> targetClasses, String endpoint, String graph, int minSize, int maxSize, long seed) {
        switch (type) {
            case STAR: {
                return new SimpleSummarySelector(sourceClasses, targetClasses, endpoint, graph, minSize, maxSize, seed, false);
            }
            case SIM_STAR: {
                return new SimpleSummarySelector(sourceClasses, targetClasses, endpoint, graph, minSize, maxSize, seed, true);
            }
            case PATH: {
                return new PathBasedTripleSelector(sourceClasses, targetClasses, endpoint, graph, minSize, maxSize, seed);
            }
            case HYBRID: {
                return new HybridTripleSelector(sourceClasses, targetClasses, endpoint, graph, minSize, maxSize, seed);
            }
        }
        return null;
    }

    public static enum SelectorType {
        STAR,
        SIM_STAR,
        PATH,
        HYBRID;

    }
}

