/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.controller;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.aksw.gerbil.io.nif.impl.TurtleNIFParser;
import org.aksw.gerbil.io.nif.impl.TurtleNIFWriter;
import org.aksw.gerbil.transfer.nif.Document;
import org.aksw.simba.bengal.paraphrasing.ParaphraserImpl;
import org.aksw.simba.bengal.paraphrasing.Paraphrasing;
import org.aksw.simba.bengal.selector.TripleSelectorFactory;
import org.aksw.simba.bengal.verbalizer.AvatarVerbalizer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BengalController {
    private static final Logger LOGGER = LoggerFactory.getLogger(BengalController.class);
    private static final String NUMBEROFDOCS = "numberofdocs";
    private static final int DEFAULT_NUMBER_OF_DOCUMENTS = 100;
    private static final long SEED = 21L;
    private static final int MIN_SENTENCE = 1;
    private static final int MAX_SENTENCE = 5;
    private static final TripleSelectorFactory.SelectorType SELECTOR_TYPE = TripleSelectorFactory.SelectorType.HYBRID;
    private static final boolean USE_PARAPHRASING = true;
    private static final boolean USE_PRONOUNS = true;
    private static final boolean USE_SURFACEFORMS = true;
    private static final boolean USE_AVATAR = true;
    private static final boolean USE_ONLY_OBJECT_PROPERTIES = false;
    private static final long WAITING_TIME_BETWEEN_DOCUMENTS = 500L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String typeSubString = "";
        typeSubString = "summary";
        String corpusName = "bengal_" + typeSubString + "_" + "pronoun_" + "surface_" + "para_" + Integer.toString(100) + ".ttl";
        BengalController.generateCorpus(new HashMap<String, String>(), "http://dbpedia.org/sparql", corpusName);
        TurtleNIFParser parser = new TurtleNIFParser();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(corpusName);
            parser.parseNIF((InputStream)fin);
        }
        catch (FileNotFoundException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fin);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fin);
        }
        IOUtils.closeQuietly((InputStream)fin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateCorpus(Map<String, String> parameters, String endpoint, String corpusName) {
        int i;
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        HashSet<String> classes = new HashSet<String>();
        classes.add("<http://dbpedia.org/ontology/Person>");
        classes.add("<http://dbpedia.org/ontology/Place>");
        classes.add("<http://dbpedia.org/ontology/Organisation>");
        TripleSelectorFactory factory = new TripleSelectorFactory();
        Object tripleSelector = null;
        Object verbalizer = null;
        AvatarVerbalizer alernativeVerbalizer = null;
        alernativeVerbalizer = AvatarVerbalizer.create(classes, new HashSet<String>(), endpoint, null, 21L, false);
        if (alernativeVerbalizer == null) {
            return;
        }
        ParaphraserImpl paraphraser = null;
        Paraphrasing paraService = Paraphrasing.create();
        if (paraService == null) {
            LOGGER.error("Couldn't create paraphrasing service. Aborting.");
            return;
        }
        paraphraser = new ParaphraserImpl(paraService);
        int numberOfDocuments = 100;
        if (parameters.containsKey(NUMBEROFDOCS)) {
            try {
                numberOfDocuments = Integer.parseInt(parameters.get(NUMBEROFDOCS));
            }
            catch (Exception e) {
                LOGGER.error("Could not parse number of documents");
            }
        }
        Document document = null;
        ArrayList<Document> documents = new ArrayList<Document>();
        int counter = 0;
        while (documents.size() < numberOfDocuments) {
            document = alernativeVerbalizer.nextDocument();
            if (document != null && paraphraser != null) {
                try {
                    document = paraphraser.getParaphrase(document);
                }
                catch (Exception e) {
                    LOGGER.error("Got exception from paraphraser. Using the original document.", (Throwable)e);
                }
            }
            if (document == null) continue;
            LOGGER.info("Created document #" + counter);
            document.setDocumentURI("http://aksw.org/generated/" + counter);
            ++counter;
            documents.add(document);
            document = null;
        }
        String filePath = corpusName;
        TurtleNIFWriter writer = new TurtleNIFWriter();
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(filePath);
            for (i = 0; i < documents.size(); ++i) {
                writer.writeNIF(documents.subList(i, i + 1), (OutputStream)fout);
            }
        }
        catch (Exception e) {
            System.out.println(documents.get(i));
            LOGGER.error("Error while writing the documents to file. Aborting.", (Throwable)e);
            System.out.println(documents.get(i));
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

