/*
 * #%L
 * Triple2NL
 * %%
 * Copyright (C) 2015 Agile Knowledge Engineering and Semantic Web (AKSW)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
/**
 * 
 */
package org.aksw.simba.bengal.triple2nl.functionality;

import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.dllearner.reasoning.SPARQLReasoner;
import org.semanticweb.owlapi.model.IRI;

import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;

/**
 * @author Lorenz Buehmann
 *
 */
public class SPARQLFunctionalityDetector implements FunctionalityDetector {

	private SPARQLReasoner sparqlReasoner;

	public SPARQLFunctionalityDetector(QueryExecutionFactory qef) {
		sparqlReasoner = new SPARQLReasoner(qef);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.aksw.triple2nl.functionality.FunctionalityDetector#isFunctional(java.
	 * lang.String)
	 */
	@Override
	public boolean isFunctional(String uri) {
		try {
			return sparqlReasoner.isFunctional(new OWLObjectPropertyImpl(IRI.create(uri)));
		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;
	}

}
