/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.triple2nl.converter;

import com.google.common.net.UrlEscapers;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.log4j.Logger;

public class URIDereferencer {
    private static final Logger logger = Logger.getLogger((String)URIDereferencer.class.getName());
    private String contentType = "application/rdf+xml";
    private File cacheDirectory;
    private boolean useCache = true;
    private Lang cacheFileLanguage = Lang.TURTLE;
    private String cacheFileExtension = (String)this.cacheFileLanguage.getFileExtensions().get(0);

    public URIDereferencer(File cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
        this.useCache = cacheDirectory != null;
    }

    public URIDereferencer() {
        this(null);
    }

    public Model dereference(String uri) throws DereferencingFailedException {
        return this.dereference(URI.create(uri));
    }

    public Model dereference(URI uri) throws DereferencingFailedException {
        logger.debug((Object)("Dereferencing " + uri + "..."));
        Model model = null;
        if (this.useCache()) {
            model = this.loadFromDisk(uri);
        }
        if (model == null) {
            model = ModelFactory.createDefaultModel();
            try {
                URLConnection conn = uri.toURL().openConnection();
                conn.setRequestProperty("Accept", this.contentType);
                InputStream is = conn.getInputStream();
                model.read(is, null, RDFLanguages.contentTypeToLang((String)this.contentType).getLabel());
                is.close();
                if (this.useCache()) {
                    this.writeToDisk(uri, model);
                }
            }
            catch (IOException e) {
                throw new DereferencingFailedException(uri, e);
            }
        }
        logger.debug((Object)("Done. Got " + model.size() + " triples for " + uri));
        return model;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    private boolean useCache() {
        return this.useCache && this.cacheDirectory != null;
    }

    private File getCacheFile(URI uri) {
        String filename = UrlEscapers.urlPathSegmentEscaper().escape(uri.toString()) + "." + this.cacheFileExtension;
        File cacheFile = new File(this.cacheDirectory, filename);
        return cacheFile;
    }

    private Model loadFromDisk(URI uri) {
        File cachedFile = this.getCacheFile(uri);
        if (cachedFile.exists()) {
            Model model;
            Model model2 = ModelFactory.createDefaultModel();
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(cachedFile));
            try {
                model2.read((InputStream)is, null, this.cacheFileLanguage.getLabel());
                model = model2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error((Object)"Failed loading from disk.", (Throwable)e);
                }
            }
            ((InputStream)is).close();
            return model;
        }
        return null;
    }

    private void writeToDisk(URI uri, Model model) {
        logger.debug((Object)("Writing model for " + uri + "to disk."));
        File cacheFile = this.getCacheFile(uri);
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(cacheFile));){
            model.write((OutputStream)os, this.cacheFileLanguage.getLabel());
        }
        catch (IOException e) {
            logger.error((Object)"Could not write to disk.", (Throwable)e);
        }
    }

    class DereferencingFailedException
    extends Exception {
        private static final long serialVersionUID = -1830907519484713882L;

        public DereferencingFailedException(URI uri, Exception cause) {
            super("Dereferencing " + uri + " failed.", cause);
        }
    }
}

