/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.selector;

import com.carrotsearch.hppc.IntObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.aksw.simba.bengal.selector.ResourceComparator;
import org.aksw.simba.bengal.selector.StatementComparator;
import org.aksw.simba.bengal.selector.TripleSelector;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.sparql.engine.http.QueryEngineHTTP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSelector
implements TripleSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSelector.class);
    private Set<String> targetClasses;
    private String endpoint;
    private String graph;
    private boolean useSymmetricCbd = false;

    public AbstractSelector(Set<String> targetClasses, String endpoint, String graph) {
        this.targetClasses = targetClasses;
        this.endpoint = endpoint;
        this.graph = graph;
    }

    public AbstractSelector(Set<String> targetClasses, String endpoint, String graph, boolean useSymmetricCbd) {
        this.useSymmetricCbd = useSymmetricCbd;
        this.targetClasses = targetClasses;
        this.endpoint = endpoint;
        this.graph = graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Statement> getSymmetricCBD(Resource res, Set<String> targetClasses, String endpoint, String graph) {
        Model m = ModelFactory.createDefaultModel();
        String sparqlQueryString = "";
        try (QueryExecution qexec = null;){
            Property p;
            Object qs;
            if (targetClasses != null) {
                if (targetClasses.isEmpty()) {
                    sparqlQueryString = "SELECT ?p ?o WHERE {<" + res + "> ?p ?o. ?o <http://www.w3.org/2000/01/rdf-schema#label> [].FILTER ( !strstarts(str(?p), 'http://dbpedia.org/ontology/wikiPageWikiLink' ) )FILTER ( !strstarts(str(?p), 'http://www.w3.org/2002/07/owl#sameAs' ) )FILTER ( !strstarts(str(?p), 'http://dbpedia.org/ontology/wikiPageRedirects' ) )FILTER ( !strstarts(str(?p), 'http://dbpedia.org/property' ) )FILTER ( strstarts(str(?p), 'http://dbpedia.org/ontology' ) )FILTER ( strstarts(str(?o), 'http://dbpedia.org/resource' ) )FILTER ( !strstarts(str(?o), 'wiki' ) )}";
                } else {
                    sparqlQueryString = "SELECT ?p ?o WHERE {";
                    sparqlQueryString = sparqlQueryString + " {<" + res + "> ?p ?o. ?o  <http://www.w3.org/2000/01/rdf-schema#label> [].FILTER ( !strstarts(str(?p), 'http://dbpedia.org/ontology/wikiPageWikiLink' ) )FILTER ( !strstarts(str(?p), 'http://www.w3.org/2002/07/owl#sameAs' ) )FILTER ( !strstarts(str(?p), 'http://dbpedia.org/ontology/wikiPageRedirects' ) )FILTER ( !strstarts(str(?p), 'http://dbpedia.org/property' ) )FILTER ( strstarts(str(?p), 'http://dbpedia.org/ontology' ) )FILTER ( strstarts(str(?o), 'http://dbpedia.org/resource' ) )FILTER ( !strstarts(str(?o), 'wiki' ) )}";
                    for (String c : targetClasses) {
                        sparqlQueryString = sparqlQueryString + "{ ?o a " + c + ". } UNION ";
                    }
                    sparqlQueryString = sparqlQueryString.substring(0, sparqlQueryString.length() - 6);
                    sparqlQueryString = sparqlQueryString + " }";
                }
            }
            QueryFactory.create((String)sparqlQueryString);
            qexec = graph != null ? QueryExecutionFactory.sparqlService((String)endpoint, (String)sparqlQueryString, (String)graph) : QueryExecutionFactory.sparqlService((String)endpoint, (String)sparqlQueryString);
            ResultSet cbd = qexec.execSelect();
            while (cbd.hasNext()) {
                qs = cbd.nextSolution();
                p = m.createProperty(qs.get("p").asResource().getURI());
                if (qs.get("o").isLiteral()) {
                    m.add(res, p, (RDFNode)qs.getLiteral("o"));
                    continue;
                }
                m.add(res, p, (RDFNode)qs.getResource("o"));
            }
            qexec.close();
            if (targetClasses != null) {
                if (targetClasses.isEmpty()) {
                    sparqlQueryString = "SELECT ?p ?o WHERE {<" + res + "> ?p ?o. ?o <http://www.w3.org/2000/01/rdf-schema#label> [].FILTER ( !strstarts(str(?p), 'http://dbpedia.org/ontology/wikiPageWikiLink' ) )FILTER ( !strstarts(str(?p), 'http://www.w3.org/2002/07/owl#sameAs' ) )FILTER ( !strstarts(str(?p), 'http://dbpedia.org/ontology/wikiPageRedirects' ) )FILTER ( !strstarts(str(?p), 'http://dbpedia.org/property' ) )FILTER ( strstarts(str(?p), 'http://dbpedia.org/ontology' ) )FILTER ( strstarts(str(?o), 'http://dbpedia.org/resource' ) )FILTER ( !strstarts(str(?o), 'wiki' ) )}";
                } else {
                    sparqlQueryString = "SELECT ?p ?o WHERE {";
                    sparqlQueryString = sparqlQueryString + " {?o ?p <" + res + ">. ?o  <http://www.w3.org/2000/01/rdf-schema#label> [].FILTER ( !strstarts(str(?p), 'http://dbpedia.org/ontology/wikiPageWikiLink' ) )FILTER ( !strstarts(str(?p), 'http://www.w3.org/2002/07/owl#sameAs' ) )FILTER ( !strstarts(str(?p), 'http://dbpedia.org/ontology/wikiPageRedirects' ) )FILTER ( !strstarts(str(?p), 'http://dbpedia.org/property' ) )FILTER ( strstarts(str(?p), 'http://dbpedia.org/ontology' ) )FILTER ( strstarts(str(?o), 'http://dbpedia.org/resource' ) )FILTER ( !strstarts(str(?o), 'wiki' ) )}";
                    for (String c : targetClasses) {
                        sparqlQueryString = sparqlQueryString + "{ ?o a " + c + ". } UNION ";
                    }
                    sparqlQueryString = sparqlQueryString.substring(0, sparqlQueryString.length() - 6);
                    sparqlQueryString = sparqlQueryString + " }";
                }
            }
            QueryFactory.create((String)sparqlQueryString);
            qexec = graph != null ? QueryExecutionFactory.sparqlService((String)endpoint, (String)sparqlQueryString, (String)graph) : QueryExecutionFactory.sparqlService((String)endpoint, (String)sparqlQueryString);
            cbd = qexec.execSelect();
            while (cbd.hasNext()) {
                qs = cbd.nextSolution();
                p = m.createProperty(qs.get("p").asResource().getURI());
                m.add(qs.getResource("o"), p, (RDFNode)res);
            }
        }
        return this.sortStatements(m.listStatements());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Statement> getCBD(Resource res, Set<String> targetClasses, String endpoint, String graph) {
        Model m = ModelFactory.createDefaultModel();
        String sparqlQueryString = "";
        try (QueryExecution qexec = null;){
            if (targetClasses != null) {
                if (targetClasses.isEmpty()) {
                    sparqlQueryString = "SELECT ?p ?o WHERE {<" + res + "> ?p ?o. ?p  <http://www.w3.org/2000/01/rdf-schema#label> [].?o  <http://www.w3.org/2000/01/rdf-schema#label> [].FILTER ( !strstarts(str(?p), 'http://dbpedia.org/ontology/wikiPageWikiLink' ) )FILTER ( !strstarts(str(?p), 'http://www.w3.org/2002/07/owl#sameAs' ) )FILTER ( !strstarts(str(?p), 'http://dbpedia.org/ontology/wikiPageRedirects' ) )FILTER ( !strstarts(str(?p), 'http://dbpedia.org/property' ) )FILTER ( strstarts(str(?p), 'http://dbpedia.org/ontology' ) )FILTER ( strstarts(str(?o), 'http://dbpedia.org/resource' ) )FILTER ( !strstarts(str(?o), 'wiki' ) )}";
                } else {
                    sparqlQueryString = "SELECT ?p ?o WHERE {";
                    sparqlQueryString = sparqlQueryString + " {<" + res + "> ?p ?o. ?p  <http://www.w3.org/2000/01/rdf-schema#label> [].?o  <http://www.w3.org/2000/01/rdf-schema#label> [].FILTER ( !strstarts(str(?p), 'http://dbpedia.org/ontology/wikiPageWikiLink' ) )FILTER ( !strstarts(str(?p), 'http://www.w3.org/2002/07/owl#sameAs' ) )FILTER ( !strstarts(str(?p), 'http://dbpedia.org/ontology/wikiPageRedirects' ) )FILTER ( !strstarts(str(?p), 'http://dbpedia.org/property' ) )FILTER ( strstarts(str(?p), 'http://dbpedia.org/ontology' ) )FILTER ( strstarts(str(?o), 'http://dbpedia.org/resource' ) )FILTER ( !strstarts(str(?o), 'wiki' ) )}";
                    for (String c : targetClasses) {
                        sparqlQueryString = sparqlQueryString + "{ ?o a " + c + ". } UNION ";
                    }
                    sparqlQueryString = sparqlQueryString.substring(0, sparqlQueryString.length() - 6);
                    sparqlQueryString = sparqlQueryString + " }";
                }
            }
            QueryFactory.create((String)sparqlQueryString);
            qexec = graph != null ? QueryExecutionFactory.sparqlService((String)endpoint, (String)sparqlQueryString, (String)graph) : QueryExecutionFactory.sparqlService((String)endpoint, (String)sparqlQueryString);
            ResultSet cbd = qexec.execSelect();
            while (cbd.hasNext()) {
                QuerySolution qs = cbd.nextSolution();
                Property p = m.createProperty(qs.get("p").asResource().getURI());
                if (qs.get("o").isLiteral()) {
                    m.add(res, p, (RDFNode)qs.getLiteral("o"));
                    continue;
                }
                m.add(res, p, (RDFNode)qs.getResource("o"));
            }
        }
        return this.sortStatements(m.listStatements());
    }

    @Deprecated
    protected List<Statement> sortStatementsByHash(StmtIterator stmtIterator) {
        IntObjectOpenHashMap map = new IntObjectOpenHashMap();
        while (stmtIterator.hasNext()) {
            Statement s = (Statement)stmtIterator.next();
            map.put(s.hashCode(), (Object)s);
        }
        int[] keys = new int[map.assigned];
        int pos = 0;
        for (int i = 0; i < map.allocated.length; ++i) {
            if (!map.allocated[i]) continue;
            keys[pos] = map.keys[i];
            ++pos;
        }
        Arrays.sort(keys);
        ArrayList<Statement> result = new ArrayList<Statement>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            result.add((Statement)map.get(keys[i]));
        }
        return result;
    }

    protected List<Statement> sortStatements(StmtIterator stmtIterator) {
        ArrayList<Statement> result = new ArrayList<Statement>();
        while (stmtIterator.hasNext()) {
            result.add((Statement)stmtIterator.next());
        }
        Collections.sort(result, new StatementComparator());
        return result;
    }

    protected List<Statement> sortStatements(Set<Statement> statements) {
        ArrayList<Statement> result = new ArrayList<Statement>(statements);
        Collections.sort(result, new StatementComparator());
        return result;
    }

    @Deprecated
    protected List<Statement> sortStatementsByHash(Set<Statement> statements) {
        IntObjectOpenHashMap map = new IntObjectOpenHashMap(2 * statements.size());
        for (Statement s : statements) {
            map.put(s.hashCode(), (Object)s);
        }
        int[] keys = new int[map.assigned];
        int pos = 0;
        for (int i = 0; i < map.allocated.length; ++i) {
            if (!map.allocated[i]) continue;
            keys[pos] = map.keys[i];
            ++pos;
        }
        Arrays.sort(keys);
        ArrayList<Statement> result = new ArrayList<Statement>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            result.add((Statement)map.get(keys[i]));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Resource> getResources(Set<String> classes) {
        String query = "";
        if (classes != null) {
            if (classes.isEmpty()) {
                query = "SELECT ?s WHERE {?s a ?x} ORDER BY DESC(?s)";
            } else {
                query = "SELECT ?x WHERE {";
                for (String c : classes) {
                    query = query + "{ ?x a " + c + ". } UNION ";
                }
                query = query.substring(0, query.length() - 6);
                query = query + " {?x ?p ?y.} ";
                for (String c : classes) {
                    query = query + "{ ?y a " + c + ". } UNION ";
                }
                query = query.substring(0, query.length() - 6);
                query = query + " }";
            }
        }
        Query sparqlQuery = QueryFactory.create((String)query, (Syntax)Syntax.syntaxARQ);
        ArrayList<Resource> result = new ArrayList<Resource>();
        try (QueryEngineHTTP httpQuery = new QueryEngineHTTP(this.endpoint, sparqlQuery);){
            ResultSet results = httpQuery.execSelect();
            while (results.hasNext()) {
                QuerySolution solution = results.next();
                try {
                    Resource r = solution.getResource("x");
                    result.add(r);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.sortResources(result);
        return result;
    }

    @Deprecated
    protected void sortResourcesByHash(List<Resource> resources) {
        int i;
        IntObjectOpenHashMap map = new IntObjectOpenHashMap(2 * resources.size());
        for (Resource r : resources) {
            map.put(r.hashCode(), (Object)r);
        }
        int[] keys = new int[map.assigned];
        int pos = 0;
        for (i = 0; i < map.allocated.length; ++i) {
            if (!map.allocated[i]) continue;
            keys[pos] = map.keys[i];
            ++pos;
        }
        Arrays.sort(keys);
        resources.clear();
        for (i = 0; i < keys.length; ++i) {
            resources.add((Resource)map.get(keys[i]));
        }
    }

    protected void sortResources(List<Resource> resources) {
        Collections.sort(resources, new ResourceComparator());
    }

    protected List<Statement> getSummary(Resource r) {
        if (this.useSymmetricCbd) {
            return this.getSymmetricCBD(r, this.targetClasses, this.endpoint, this.graph);
        }
        return this.getCBD(r, this.targetClasses, this.endpoint, this.graph);
    }
}

