/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.selector;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.aksw.simba.bengal.selector.AbstractSelector;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathBasedTripleSelector
extends AbstractSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathBasedTripleSelector.class);
    private Set<String> sourceClasses;
    private List<Resource> resources;
    private Random r = new Random(20L);
    private int minSize = 1;
    private int maxSize = 5;

    public PathBasedTripleSelector(Set<String> sourceClasses, Set<String> targetClasses, String endpoint, String graph, int minSize, int maxSize, long seed) {
        super(targetClasses, endpoint, graph);
        this.sourceClasses = sourceClasses;
        this.resources = null;
        this.minSize = minSize;
        if (maxSize < minSize) {
            maxSize = minSize + 1;
        }
        this.maxSize = maxSize;
        this.r = new Random(seed);
    }

    public PathBasedTripleSelector(Set<String> sourceClasses, Set<String> targetClasses, String endpoint, String graph) {
        super(targetClasses, endpoint, graph);
        this.sourceClasses = sourceClasses;
        this.resources = null;
    }

    @Override
    public List<Statement> getNextStatements() {
        if (this.resources == null) {
            this.resources = this.getResources(this.sourceClasses);
        }
        int size = this.minSize + this.r.nextInt(this.maxSize - this.minSize + 1);
        ArrayList<Statement> result = new ArrayList<Statement>(size);
        HashSet<Resource> visitedResources = new HashSet<Resource>();
        int counter = Math.abs(this.r.nextInt() % this.resources.size());
        Resource currentResource = this.resources.get(counter);
        visitedResources.add(currentResource);
        List<Statement> statements = null;
        boolean resourceChanged = true;
        int retries = 0;
        int maxRetries = 10;
        while (result.size() < size) {
            if (resourceChanged) {
                statements = this.getSummary(currentResource);
                if (statements == null) {
                    return null;
                }
                if (statements.size() == 0) {
                    System.out.println(result);
                    return result;
                }
                resourceChanged = false;
            }
            counter = Math.abs(this.r.nextInt() % statements.size());
            Statement statement = statements.get(counter);
            if (result.size() == size - 1) {
                result.add(statement);
                continue;
            }
            if (statement.getObject().isResource() && !visitedResources.contains(statement.getObject().asResource())) {
                result.add(statement);
                currentResource = statement.getObject().asResource();
                visitedResources.add(currentResource);
                resourceChanged = true;
                continue;
            }
            if (++retries <= maxRetries) continue;
            LOGGER.warn("After {} retries I couldn't select a matching statement. Returning the statements I selected so far.", (Object)maxRetries);
            System.out.println(result);
            return result;
        }
        System.out.println(result);
        return result;
    }
}

