/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.paraphrasing;

import com.carrotsearch.hppc.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.aksw.gerbil.transfer.nif.Document;
import org.aksw.gerbil.transfer.nif.Marking;
import org.aksw.gerbil.transfer.nif.data.DocumentImpl;
import org.aksw.gerbil.transfer.nif.data.NamedEntity;
import org.aksw.simba.bengal.paraphrasing.ParaphraseService;
import org.aksw.simba.bengal.paraphrasing.Paraphraser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParaphraserImpl
implements Paraphraser,
Comparator<NamedEntity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Paraphraser.class);
    protected ParaphraseService service;

    public ParaphraserImpl(ParaphraseService service) {
        this.service = service;
    }

    @Override
    public Document getParaphrase(Document doc, String dictPath) {
        String text = doc.getText();
        String paraphrases = this.service.paraphrase(text, dictPath);
        if (paraphrases == null) {
            return doc;
        }
        DocumentImpl newDoc = new DocumentImpl(paraphrases, doc.getDocumentURI());
        List originalNes = doc.getMarkings(NamedEntity.class);
        Collections.sort(originalNes, this);
        BitSet blockedPositions = new BitSet((long)paraphrases.length());
        BitSet currentPositions = new BitSet((long)paraphrases.length());
        for (NamedEntity ne : originalNes) {
            String label = text.substring(ne.getStartPosition(), ne.getStartPosition() + ne.getLength());
            int pos = -ne.getLength();
            do {
                if ((pos = paraphrases.indexOf(label, pos + ne.getLength())) < 0) {
                    LOGGER.warn("The paraphrasing changed one of the entities. Couldn't find the surface form \"{}\" in the text \"{}\". Returning the original document.", (Object)label, (Object)paraphrases);
                    return doc;
                }
                currentPositions.clear();
                currentPositions.set((long)pos, (long)(pos + ne.getLength()));
            } while (BitSet.intersectionCount((BitSet)blockedPositions, (BitSet)currentPositions) > 0L);
            newDoc.addMarking((Marking)new NamedEntity(pos, ne.getLength(), ne.getUris()));
            blockedPositions.or(currentPositions);
        }
        return newDoc;
    }

    @Override
    public int compare(NamedEntity n1, NamedEntity n2) {
        int diff = n1.getLength() - n2.getLength();
        if (diff < 0) {
            return 1;
        }
        if (diff > 0) {
            return -1;
        }
        return 0;
    }
}

