/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.controller;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.aksw.gerbil.io.nif.impl.TurtleNIFParser;
import org.aksw.gerbil.io.nif.impl.TurtleNIFWriter;
import org.aksw.gerbil.transfer.nif.Document;
import org.aksw.simba.bengal.config.BengalRunConfig;
import org.aksw.simba.bengal.paraphrasing.ParaphraserImpl;
import org.aksw.simba.bengal.paraphrasing.Paraphrasing;
import org.aksw.simba.bengal.selector.TripleSelector;
import org.aksw.simba.bengal.selector.TripleSelectorFactory;
import org.aksw.simba.bengal.verbalizer.AvatarVerbalizer;
import org.aksw.simba.bengal.verbalizer.NumberOfVerbalizedTriples;
import org.aksw.simba.bengal.verbalizer.SemWeb2NLVerbalizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.jena.rdf.model.Statement;
import org.dllearner.kb.sparql.SparqlEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BengalController {
    private static final Logger LOGGER = LoggerFactory.getLogger(BengalController.class);
    protected static final Option HELP_OPT = Option.builder((String)"h").longOpt("help").required(false).hasArg(false).build();
    protected static final Options CLI_OPTS = new Options();
    protected static final HelpFormatter HELP_FORMATTER = new HelpFormatter();
    protected static final PrintWriter CONSOLE_WRITER = new PrintWriter(System.out);
    protected static final String APP_NAME = "Bengal";
    protected static final String PARAPHRASE_OPT = "pp";
    protected static final String PRONOUNS_OPT = "pr";
    protected static final String SURFACEFORMS_OPT = "sf";
    protected static final String ONLYOBJECTPROPS_OPT = "o";
    protected static final String NUMBEROFDOCUMENTS_OPT = "n";
    protected static final String SEEDS_OPT = "sd";
    protected static final String MINSENTENCE_OPT = "mns";
    protected static final String MAXSENTENCE_OPT = "mxs";
    protected static final String WAITTIME_OPT = "wt";
    protected static final String SPARQLENDPOINT_OPT = "se";
    protected static final String SELECTORTYPE_OPT = "st";
    protected static final String DICTPATH_OPT = "dp";
    protected static final String SFPATH_OPT = "sp";

    public static void main(String[] args) throws ParseException {
        if (BengalController.checkForHelp(args)) {
            HELP_FORMATTER.printHelp(APP_NAME, CLI_OPTS);
        } else {
            DefaultParser parser = new DefaultParser();
            try {
                CommandLine cmd = parser.parse(CLI_OPTS, args);
                BengalRunConfig runConfig = BengalController.generateConfigBean(cmd);
                BengalController.process(runConfig);
            }
            catch (MissingArgumentException | MissingOptionException me) {
                CONSOLE_WRITER.write(me.getMessage() + "\n");
                HELP_FORMATTER.printUsage(CONSOLE_WRITER, 80, APP_NAME, CLI_OPTS);
                CONSOLE_WRITER.flush();
            }
        }
    }

    protected static BengalRunConfig generateConfigBean(CommandLine cmd) {
        BengalRunConfig runConfig = new BengalRunConfig();
        if (cmd.hasOption(PARAPHRASE_OPT)) {
            runConfig.setUseParaphrasing(true);
        }
        if (cmd.hasOption(PRONOUNS_OPT)) {
            runConfig.setUsePronouns(true);
        }
        if (cmd.hasOption(SURFACEFORMS_OPT)) {
            runConfig.setUseSurfaceForms(true);
        }
        if (cmd.hasOption(ONLYOBJECTPROPS_OPT)) {
            runConfig.setUseOnlyObjectProps(true);
        }
        if (cmd.hasOption(NUMBEROFDOCUMENTS_OPT)) {
            runConfig.setNumberOfDocs(Integer.parseInt(cmd.getOptionValue(NUMBEROFDOCUMENTS_OPT)));
        }
        if (cmd.hasOption(SEEDS_OPT)) {
            runConfig.setSeed(Integer.parseInt(cmd.getOptionValue(SEEDS_OPT)));
        }
        if (cmd.hasOption(MINSENTENCE_OPT)) {
            runConfig.setMinSentence(Integer.parseInt(cmd.getOptionValue(MINSENTENCE_OPT)));
        }
        if (cmd.hasOption(MAXSENTENCE_OPT)) {
            runConfig.setMaxSentence(Integer.parseInt(cmd.getOptionValue(MAXSENTENCE_OPT)));
        }
        if (cmd.hasOption(WAITTIME_OPT)) {
            runConfig.setWaitTime(Long.parseLong(cmd.getOptionValue(WAITTIME_OPT)));
        }
        if (cmd.hasOption(SPARQLENDPOINT_OPT)) {
            runConfig.setSparqlEndPoint(cmd.getOptionValue(SPARQLENDPOINT_OPT));
        }
        if (cmd.hasOption(SELECTORTYPE_OPT)) {
            String selectorType = cmd.getOptionValue(SELECTORTYPE_OPT);
            if (selectorType.equals("summary")) {
                runConfig.setUseAvatars(true);
            }
            runConfig.setSelectorType(selectorType);
        }
        if (cmd.hasOption(DICTPATH_OPT)) {
            runConfig.setDictDirPath(cmd.getOptionValue(DICTPATH_OPT));
        }
        if (cmd.hasOption(SFPATH_OPT)) {
            runConfig.setSurfaceFormFilePath(cmd.getOptionValue(SFPATH_OPT));
        }
        return runConfig;
    }

    protected static boolean checkForHelp(String[] args) throws ParseException {
        boolean hasHelp = false;
        Options options = new Options();
        try {
            options.addOption(HELP_OPT);
            DefaultParser parser = new DefaultParser();
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption(HELP_OPT.getOpt())) {
                hasHelp = true;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return hasHelp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void process(BengalRunConfig runConfig) {
        String typeSubString = runConfig.getSelectorType();
        String corpusName = "bengal_" + typeSubString + "_" + (runConfig.isUsePronouns() ? "pronoun_" : "") + (runConfig.isUseSurfaceForms() ? "surface_" : "") + (runConfig.isUseParaphrasing() ? "para_" : "") + Integer.toString(runConfig.getNumberOfDocs()) + ".ttl";
        BengalController.generateCorpus(runConfig, corpusName);
        TurtleNIFParser parser = new TurtleNIFParser();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(corpusName);
            parser.parseNIF((InputStream)fin);
        }
        catch (FileNotFoundException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fin);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fin);
        }
        IOUtils.closeQuietly((InputStream)fin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateCorpus(BengalRunConfig runConfig, String corpusName) {
        int i;
        String endpoint = runConfig.getSqparqlEndPoint();
        HashSet<String> classes = new HashSet<String>();
        classes.add("<http://dbpedia.org/ontology/Person>");
        classes.add("<http://dbpedia.org/ontology/Place>");
        classes.add("<http://dbpedia.org/ontology/Organisation>");
        TripleSelectorFactory factory = new TripleSelectorFactory();
        TripleSelector tripleSelector = null;
        SemWeb2NLVerbalizer verbalizer = null;
        AvatarVerbalizer alernativeVerbalizer = null;
        if (runConfig.isUseAvatars()) {
            alernativeVerbalizer = AvatarVerbalizer.create(classes, runConfig.isUseOnlyObjectProps() ? classes : new HashSet<String>(), endpoint, null, runConfig.getSeed(), false);
            if (alernativeVerbalizer == null) {
                return;
            }
        } else {
            tripleSelector = factory.create(runConfig.getSelectorTypeEnum(), classes, runConfig.isUseOnlyObjectProps() ? classes : new HashSet<String>(), endpoint, null, runConfig.getMinSentence(), runConfig.getMaxSentence(), runConfig.getSeed());
            verbalizer = new SemWeb2NLVerbalizer(SparqlEndpoint.getEndpointDBpedia(), runConfig.isUsePronouns(), runConfig.isUseSurfaceForms());
        }
        ParaphraserImpl paraphraser = null;
        if (runConfig.isUseParaphrasing()) {
            Paraphrasing paraService = Paraphrasing.create();
            if (paraService != null) {
                paraphraser = new ParaphraserImpl(paraService);
            } else {
                LOGGER.error("Couldn't create paraphrasing service. Aborting.");
                return;
            }
        }
        int numberOfDocuments = runConfig.getNumberOfDocs();
        Document document = null;
        ArrayList<Document> documents = new ArrayList<Document>();
        int counter = 1;
        while (documents.size() < numberOfDocuments) {
            if (runConfig.isUseAvatars()) {
                document = alernativeVerbalizer.nextDocument();
            } else {
                List<Statement> triples = tripleSelector.getNextStatements();
                if (triples != null && triples.size() >= runConfig.getMinSentence()) {
                    List tripleCounts;
                    document = verbalizer.generateDocument(triples, runConfig.getSurfaceFormFilePath());
                    if (document != null && (tripleCounts = document.getMarkings(NumberOfVerbalizedTriples.class)).size() > 0 && ((NumberOfVerbalizedTriples)tripleCounts.get(0)).getNumberOfTriples() < runConfig.getMinSentence()) {
                        LOGGER.error("The generated document does not have enough verbalized triples. It will be discarded.");
                        document = null;
                    }
                    if (document != null && paraphraser != null) {
                        try {
                            document = paraphraser.getParaphrase(document, runConfig.getDictDirPath());
                        }
                        catch (Exception e) {
                            LOGGER.error("Got exception from paraphraser. Using the original document.", (Throwable)e);
                        }
                    }
                }
            }
            if (document != null) {
                LOGGER.info("Created document #" + counter);
                document.setDocumentURI("http://aksw.org/generated/" + counter);
                ++counter;
                documents.add(document);
                document = null;
            }
            try {
                if (runConfig.isUseAvatars()) continue;
                Thread.sleep(runConfig.getWaitTime());
            }
            catch (InterruptedException e) {}
        }
        String filePath = corpusName;
        TurtleNIFWriter writer = new TurtleNIFWriter();
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(filePath);
            for (i = 0; i < documents.size(); ++i) {
                writer.writeNIF(documents.subList(i, i + 1), (OutputStream)fout);
            }
        }
        catch (Exception e) {
            System.out.println(documents.get(i));
            LOGGER.error("Error while writing the documents to file. Aborting.", (Throwable)e);
            System.out.println(documents.get(i));
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    static {
        CLI_OPTS.addOption(PARAPHRASE_OPT, "paraphrase", false, "Use Paraphrasing");
        CLI_OPTS.addOption(PRONOUNS_OPT, "pronouns", false, "Use Pronouns");
        CLI_OPTS.addOption(SURFACEFORMS_OPT, "surfaceforms", false, "Use Surface-Forms");
        CLI_OPTS.addOption(ONLYOBJECTPROPS_OPT, "onlyobjectprops", false, "Use only object properties");
        CLI_OPTS.addOption(NUMBEROFDOCUMENTS_OPT, "numberofdocuments", true, "Number of documents, default: 1");
        CLI_OPTS.addOption(SEEDS_OPT, "seed", true, "Number of Seeds, default: Current System time in milliseconds");
        CLI_OPTS.addOption(MINSENTENCE_OPT, "minsentence", true, "Minimum number of sentences, default: 3");
        CLI_OPTS.addOption(MAXSENTENCE_OPT, "maxsentence", true, "Maximum number of sentences, default: 10");
        CLI_OPTS.addOption(WAITTIME_OPT, "waittime", true, "Wait time between documents in milliseconds, default: 500");
        CLI_OPTS.addOption(SPARQLENDPOINT_OPT, "sparqlendpoint", true, "Sparql Endpoint, default: http://dbpedia.org/sparql");
        CLI_OPTS.addRequiredOption(SELECTORTYPE_OPT, "selectortype", true, "Selector Type ('star', 'hybrid', 'path', 'sym' or 'summary')");
        CLI_OPTS.addOption(DICTPATH_OPT, "dictpath", true, "Path to Dictionary's directory, default: " + BengalRunConfig.DEF_DICT_PATH);
        CLI_OPTS.addOption(SFPATH_OPT, "surfaceformpath", true, "Path to Surface Forms file, default: " + BengalRunConfig.DEF_SURFACEFORM_PATH);
    }
}

