/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.triple2nl.util;

public enum PennTreebankTagSet {
    ADJECTIVE("JJ"),
    ADJECTIVE_COMPARATIVE((Object)((Object)ADJECTIVE) + "R"),
    ADJECTIVE_SUPERLATIVE((Object)((Object)ADJECTIVE) + "S"),
    ADVERB("RB"),
    ADVERB_COMPARATIVE((Object)((Object)ADVERB) + "R"),
    ADVERB_SUPERLATIVE((Object)((Object)ADVERB) + "S"),
    ADVERB_WH("W" + (Object)((Object)ADVERB)),
    CONJUNCTION_COORDINATING("CC"),
    CONJUNCTION_SUBORDINATING("IN"),
    CARDINAL_NUMBER("CD"),
    DETERMINER("DT"),
    DETERMINER_WH("W" + (Object)((Object)DETERMINER)),
    EXISTENTIAL_THERE("EX"),
    FOREIGN_WORD("FW"),
    LIST_ITEM_MARKER("LS"),
    NOUN("NN"),
    NOUN_PLURAL((Object)((Object)NOUN) + "S"),
    NOUN_PROPER_SINGULAR((Object)((Object)NOUN) + "P"),
    NOUN_PROPER_PLURAL((Object)((Object)NOUN) + "PS"),
    PREDETERMINER("PDT"),
    POSSESSIVE_ENDING("POS"),
    PRONOUN_PERSONAL("PRP"),
    PRONOUN_POSSESSIVE("PRP$"),
    PRONOUN_POSSESSIVE_WH("WP$"),
    PRONOUN_WH("WP"),
    PARTICLE("RP"),
    SYMBOL("SYM"),
    TO("TO"),
    INTERJECTION("UH"),
    VERB("VB"),
    VERB_PAST_TENSE((Object)((Object)VERB) + "D"),
    VERB_PARTICIPLE_PRESENT((Object)((Object)VERB) + "G"),
    VERB_PARTICIPLE_PAST((Object)((Object)VERB) + "N"),
    VERB_SINGULAR_PRESENT_NONTHIRD_PERSON((Object)((Object)VERB) + "P"),
    VERB_SINGULAR_PRESENT_THIRD_PERSON((Object)((Object)VERB) + "Z"),
    VERB_MODAL("MD"),
    S("S"),
    SBAR("SBAR"),
    SBARQ("SBARQ"),
    SINV("SINV"),
    SQ("SQ"),
    ADJECTIVE_PHRASE("ADJP"),
    ADVERB_PHRASE("ADVP"),
    NOUN_PHRASE("NP"),
    VERB_PHRASE("VP"),
    PREPOSITIONAL_PHRASE("PP"),
    FRAGMENT("FRAG"),
    SENTENCE_TERMINATOR(".");

    private final String tag;

    private PennTreebankTagSet(String tag) {
        this.tag = tag;
    }

    public String toString() {
        return this.getTag();
    }

    public String getTag() {
        return this.tag;
    }

    public static PennTreebankTagSet get(String value) {
        for (PennTreebankTagSet v : PennTreebankTagSet.values()) {
            if (!value.equals(v.getTag())) continue;
            return v;
        }
        throw new IllegalArgumentException("Unknown part of speech: '" + value + "'.");
    }
}

