/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.triple2nl.property;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import net.sf.extjwnl.JWNLException;
import net.sf.extjwnl.data.IndexWord;
import net.sf.extjwnl.data.POS;
import net.sf.extjwnl.data.Synset;
import net.sf.extjwnl.data.Word;
import net.sf.extjwnl.dictionary.Dictionary;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.simba.bengal.triple2nl.converter.DefaultIRIConverter;
import org.aksw.simba.bengal.triple2nl.converter.IRIConverter;
import org.aksw.simba.bengal.triple2nl.nlp.StanfordCoreNLPWrapper;
import org.aksw.simba.bengal.triple2nl.property.PropertyVerbalization;
import org.aksw.simba.bengal.triple2nl.property.PropertyVerbalizationType;
import org.aksw.simba.bengal.triple2nl.util.PennTreebankTagSet;
import org.aksw.simba.bengal.triple2nl.util.Preposition;
import org.apache.log4j.Logger;
import simplenlg.features.Tense;

public class PropertyVerbalizer {
    private static final Logger logger = Logger.getLogger(PropertyVerbalizer.class);
    private double threshold = 2.0;
    private Preposition preposition;
    private Dictionary database;
    private final String VERB_PATTERN = "^((VP)|(have NP)|(be NP P)|(be VP P)|(VP NP)).*";
    private StanfordCoreNLPWrapper pipeline;
    private boolean useLinguisticalAnalysis = true;
    private final List<String> auxiliaryVerbs = Lists.newArrayList((Object[])new String[]{"do", "have", "be", "shall", "can", "may"});
    private IRIConverter uriConverter;

    public PropertyVerbalizer(QueryExecutionFactory qef, String cacheDirectory, Dictionary wordnetDictionary) {
        this(new DefaultIRIConverter(qef, cacheDirectory), wordnetDictionary);
    }

    public PropertyVerbalizer(IRIConverter uriConverter, Dictionary wordnetDictionary) {
        this.uriConverter = uriConverter;
        try {
            this.database = wordnetDictionary == null ? Dictionary.getDefaultResourceInstance() : wordnetDictionary;
        }
        catch (JWNLException e) {
            throw new RuntimeException("Failed to create WordNet instance.", e);
        }
        this.preposition = new Preposition();
        Properties props = new Properties();
        props.put("annotators", "tokenize, ssplit, pos, lemma, parse");
        props.put("ssplit.isOneSentence", "true");
        this.pipeline = new StanfordCoreNLPWrapper((AnnotationPipeline)new StanfordCoreNLP(props));
    }

    public PropertyVerbalization verbalize(String propertyURI) {
        logger.debug((Object)("Getting lexicalization type for \"" + propertyURI + "\"..."));
        String propertyText = this.uriConverter.convert(propertyURI);
        propertyText = this.normalize(propertyText);
        PropertyVerbalization propertyVerbalization = this.getTypeByLinguisticAnalysis(propertyURI, propertyText);
        if (propertyVerbalization.getVerbalizationType() == PropertyVerbalizationType.UNSPECIFIED || propertyText.split(" ").length == 1) {
            logger.debug((Object)"...using WordNet-based analysis...");
            PropertyVerbalizationType verbalizationType = this.getTypeByWordnet(propertyText);
            propertyVerbalization.setVerbalizationType(verbalizationType);
        }
        this.computeExpandedVerbalization(propertyVerbalization);
        Tense tense = this.getTense(propertyText);
        propertyVerbalization.setTense(tense);
        logger.debug((Object)"Done.");
        return propertyVerbalization;
    }

    public PropertyVerbalizationType getTypeByWordnet(String property) {
        if (property.contains(" ")) {
            String[] split = property.split(" ");
            String lastToken = split[split.length - 1];
            if (this.preposition.isPreposition(lastToken)) {
                String firstToken = split[0];
                if (this.getTypeByWordnet(firstToken) == PropertyVerbalizationType.NOUN) {
                    return PropertyVerbalizationType.NOUN;
                }
                if (this.getTypeByWordnet(firstToken) == PropertyVerbalizationType.VERB) {
                    return PropertyVerbalizationType.VERB;
                }
            }
            if (this.getTypeByWordnet(lastToken) == PropertyVerbalizationType.NOUN) {
                return PropertyVerbalizationType.NOUN;
            }
            if (this.getTypeByWordnet(split[0]) == PropertyVerbalizationType.VERB) {
                return PropertyVerbalizationType.VERB;
            }
            return PropertyVerbalizationType.NOUN;
        }
        double score = this.getScore(property);
        if (score < 0.0) {
            return PropertyVerbalizationType.UNSPECIFIED;
        }
        if (score >= this.threshold) {
            return PropertyVerbalizationType.NOUN;
        }
        if (score < 1.0 / this.threshold) {
            return PropertyVerbalizationType.VERB;
        }
        return PropertyVerbalizationType.NOUN;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public void setUseLinguisticalAnalysis(boolean useLinguisticalAnalysis) {
        this.useLinguisticalAnalysis = useLinguisticalAnalysis;
    }

    public double getScore(String token) {
        logger.debug((Object)("Checking " + token));
        double nounCount = 0.0;
        double verbCount = 0.0;
        try {
            List words;
            List synsets;
            IndexWord iw = this.database.lookupIndexWord(POS.NOUN, token);
            if (iw != null) {
                synsets = iw.getSenses();
                for (Synset synset : synsets) {
                    words = synset.getWords();
                    for (Word word : words) {
                        nounCount += Math.log((double)word.getUseCount() + 1.0);
                    }
                }
            }
            if ((iw = this.database.lookupIndexWord(POS.VERB, token)) != null) {
                synsets = iw.getSenses();
                for (Synset synset : synsets) {
                    words = synset.getWords();
                    for (Word word : words) {
                        verbCount += Math.log((double)word.getUseCount() + 1.0);
                    }
                }
            }
            logger.debug((Object)("Noun count = " + nounCount));
            logger.debug((Object)("Verb count = " + verbCount));
        }
        catch (JWNLException e) {
            logger.error((Object)"WordNet lookup failed.", (Throwable)e);
        }
        if (verbCount == 0.0 && nounCount == 0.0) {
            return 1.0;
        }
        if (verbCount == 0.0) {
            return Double.MAX_VALUE;
        }
        if (nounCount == 0.0) {
            return 0.0;
        }
        return nounCount / verbCount;
    }

    public String getInfinitiveForm(String word) {
        String[] split = word.split(" ");
        String verb = split[0];
        if ((!verb.endsWith("ed") || split.length != 1) && (verb.endsWith("ed") || verb.endsWith("un") || verb.endsWith("wn") || verb.endsWith("en"))) {
            return "be " + word;
        }
        try {
            IndexWord iw = this.database.getIndexWord(POS.VERB, word);
            if (iw != null) {
                List synsets = iw.getSenses();
                double min = verb.length();
                String result = verb;
                for (Synset synset : synsets) {
                    for (Word w : synset.getWords()) {
                        if (!verb.contains(w.getLemma())) continue;
                        result = w.getLemma();
                        if (split.length > 1) {
                            for (int k = 1; k < split.length; ++k) {
                                result = result + " " + split[k];
                            }
                        }
                        return result;
                    }
                }
            }
        }
        catch (JWNLException e) {
            logger.error((Object)"WordNet lookup failed.", (Throwable)e);
        }
        return word;
    }

    private Tense getTense(String word) {
        String[] split = word.split(" ");
        String verb = split[0];
        if (verb.endsWith("ed") && split.length == 1) {
            return Tense.PAST;
        }
        return Tense.PRESENT;
    }

    private PropertyVerbalization getTypeByLinguisticAnalysis(String propertyURI, String propertyText) {
        logger.debug((Object)"...using linguistical analysis...");
        Annotation document = new Annotation(propertyText);
        this.pipeline.annotate(document);
        List sentences = (List)document.get(CoreAnnotations.SentencesAnnotation.class);
        String pattern = "";
        PropertyVerbalizationType verbalizationType = PropertyVerbalizationType.UNSPECIFIED;
        boolean firstTokenAuxiliary = false;
        for (CoreMap sentence : sentences) {
            List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            CoreLabel token = (CoreLabel)tokens.get(0);
            String word = (String)token.get(CoreAnnotations.TextAnnotation.class);
            String pos = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
            String lemma = token.getString(CoreAnnotations.LemmaAnnotation.class);
            firstTokenAuxiliary = this.auxiliaryVerbs.contains(lemma);
            pattern = lemma.equals("be") || word.equals("have") ? pattern + lemma.toUpperCase() : (pos.startsWith("N") ? pattern + "NP" : (pos.startsWith("V") ? pattern + "VP" : pattern + pos));
            if (tokens.size() > 1) {
                pattern = pattern + " ";
                for (int i = 1; i < tokens.size(); ++i) {
                    token = (CoreLabel)tokens.get(i);
                    pos = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                    pattern = pos.startsWith("N") ? pattern + "NP" : (pos.startsWith("V") ? pattern + "VP" : pattern + pos);
                    pattern = pattern + " ";
                }
            }
            Tree tree = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
            tree = tree.skipRoot();
            logger.debug((Object)("Parse tree:" + tree.pennString()));
            if (tree.value().matches(Joiner.on((char)'|').join((Iterable)Lists.newArrayList((Object[])new PennTreebankTagSet[]{PennTreebankTagSet.S, PennTreebankTagSet.SBAR, PennTreebankTagSet.SBARQ, PennTreebankTagSet.SINV, PennTreebankTagSet.FRAGMENT})))) {
                tree = tree.getChild(0);
            }
            boolean useDeterminer = false;
            if (tree.value().equals(PennTreebankTagSet.VERB_PHRASE.getTag())) {
                for (Tree child : tree.getChildrenAsList()) {
                    if (child.isPreTerminal()) continue;
                    if (!child.value().equals(PennTreebankTagSet.NOUN_PHRASE.getTag()) || child.getChild(0).value().equals(PennTreebankTagSet.DETERMINER.getTag())) break;
                    useDeterminer = true;
                    break;
                }
            }
            if (!useDeterminer) continue;
            String[] split = pattern.split(" ");
            pattern = split[0] + " DET " + Joiner.on((String)" ").join((Object[])Arrays.copyOfRange(split, 1, split.length));
        }
        pattern = pattern.trim();
        if (firstTokenAuxiliary) {
            verbalizationType = PropertyVerbalizationType.VERB;
        }
        if (pattern.matches("^((VP)|(have NP)|(be NP P)|(be VP P)|(VP NP)).*")) {
            logger.debug((Object)"...successfully determined type.");
            verbalizationType = PropertyVerbalizationType.VERB;
        }
        return new PropertyVerbalization(propertyURI, propertyText, pattern, verbalizationType);
    }

    private String normalize(String propertyText) {
        propertyText = propertyText.toLowerCase();
        return propertyText;
    }

    private void computeExpandedVerbalization(PropertyVerbalization propertyVerbalization) {
        String text;
        String expandedForm = text = propertyVerbalization.getVerbalizationText();
        String pos = propertyVerbalization.getPOSTags();
        if (pos.equals("VBN IN")) {
            expandedForm = "is " + text;
        } else if (pos.startsWith("BE DET")) {
            String[] split = text.split(" ");
            expandedForm = "is a " + Joiner.on((String)" ").join((Object[])Arrays.copyOfRange(text.split(" "), 1, split.length));
        }
        propertyVerbalization.setExpandedVerbalizationText(expandedForm);
    }

    public static void main(String[] args) throws Exception {
        PropertyVerbalizer pp = new PropertyVerbalizer((QueryExecutionFactory)new QueryExecutionFactoryHttp("http://dbpedia.org/sparql"), "cache", null);
        String propertyURI = "http://dbpedia.org/ontology/birthPlace";
        System.out.println(pp.verbalize(propertyURI));
        propertyURI = "http://dbpedia.org/ontology/birthPlace";
        System.out.println(pp.verbalize(propertyURI));
        propertyURI = "http://dbpedia.org/ontology/hasColor";
        System.out.println(pp.verbalize(propertyURI));
        propertyURI = "http://dbpedia.org/ontology/isHardWorking";
        System.out.println(pp.verbalize(propertyURI));
        propertyURI = "http://dbpedia.org/ontology/bornIn";
        System.out.println(pp.verbalize(propertyURI));
        propertyURI = "http://dbpedia.org/ontology/cross";
        System.out.println(pp.verbalize(propertyURI));
        propertyURI = "http://dbpedia.org/ontology/producedBy";
        System.out.println(pp.verbalize(propertyURI));
        propertyURI = "http://dbpedia.org/ontology/worksFor";
        System.out.println(pp.verbalize(propertyURI));
        propertyURI = "http://dbpedia.org/ontology/workedFor";
        System.out.println(pp.verbalize(propertyURI));
        propertyURI = "http://dbpedia.org/ontology/knownFor";
        System.out.println(pp.verbalize(propertyURI));
        propertyURI = "http://dbpedia.org/ontology/name";
        System.out.println(pp.verbalize(propertyURI));
        propertyURI = "http://dbpedia.org/ontology/isGoldMedalWinner";
        System.out.println(pp.verbalize(propertyURI));
    }
}

