/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.triple2nl.gender;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.simba.bengal.triple2nl.gender.Gender;
import org.aksw.simba.bengal.triple2nl.gender.GenderDetector;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.engine.http.QueryExceptionHTTP;
import org.apache.jena.web.HttpSC;
import org.dllearner.kb.sparql.SparqlEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeAwareGenderDetector
implements GenderDetector {
    private static final Logger logger = LoggerFactory.getLogger(TypeAwareGenderDetector.class);
    private QueryExecutionFactory qef;
    private GenderDetector genderDetector;
    private Set<String> personTypes = new HashSet<String>();
    private boolean useInference = true;

    public TypeAwareGenderDetector(QueryExecutionFactory qef, GenderDetector genderDetector) {
        this.qef = qef;
        this.genderDetector = genderDetector;
    }

    public TypeAwareGenderDetector(SparqlEndpoint endpoint, GenderDetector genderDetector) {
        this((QueryExecutionFactory)new QueryExecutionFactoryHttp(endpoint.getURL().toString(), (Collection)endpoint.getDefaultGraphURIs()), genderDetector);
    }

    public void setPersonTypes(Set<String> personTypes) {
        this.personTypes = personTypes;
        if (this.useInference) {
            HashSet<String> inferredTypes = new HashSet<String>();
            String queryTemplate = "select ?sub where{?sub <http://www.w3.org/2000/01/rdf-schema#subClassOf>* <%s>.}";
            for (String type : personTypes) {
                String query = String.format(queryTemplate, type);
                QueryExecution qe = this.qef.createQueryExecution(query);
                Throwable throwable = null;
                try {
                    ResultSet rs = qe.execSelect();
                    while (rs.hasNext()) {
                        inferredTypes.add(rs.next().getResource("sub").getURI());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (qe == null) continue;
                    if (throwable != null) {
                        try {
                            qe.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    qe.close();
                }
            }
            personTypes.addAll(inferredTypes);
        }
    }

    public Gender getGender(String uri, String label) {
        if (this.isPerson(uri)) {
            return this.genderDetector.getGender(label);
        }
        return Gender.UNKNOWN;
    }

    @Override
    public Gender getGender(String name) {
        return this.genderDetector.getGender(name);
    }

    private boolean isPerson(String uri) {
        if (this.personTypes.isEmpty()) {
            return true;
        }
        HashSet<String> types = new HashSet<String>();
        try {
            String query = "SELECT ?type WHERE {<" + uri + "> a ?type.}";
            try (QueryExecution qe = this.qef.createQueryExecution(query);){
                ResultSet rs = qe.execSelect();
                while (rs.hasNext()) {
                    types.add(rs.next().getResource("type").getURI());
                }
            }
        }
        catch (Exception e) {
            int code = ((QueryExceptionHTTP)e.getCause()).getResponseCode();
            logger.warn("SPARQL query execution failed: " + code + " - " + HttpSC.getCode((int)code).getMessage());
        }
        return !Sets.intersection(this.personTypes, types).isEmpty();
    }
}

