/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.triple2nl.gender;

import java.io.InputStream;
import org.aksw.simba.bengal.triple2nl.gender.GenderDictionary;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;

public class DBpediaGenderDictionary
extends GenderDictionary {
    public static String GENDER_FILE_LOCATION = "gender/dbpedia/genders_en.ttl";
    private static final String GENDER_PROPERTY = "http://xmlns.com/foaf/0.1/gender";
    private static final String VALUE_MALE = "male";
    private static final String VALUE_FEMALE = "female";

    public DBpediaGenderDictionary() {
        Model model = ModelFactory.createDefaultModel();
        Literal maleLit = model.createLiteral(VALUE_MALE, "en");
        Literal femaleLit = model.createLiteral(VALUE_FEMALE, "en");
        RDFDataMgr.read((Model)model, (InputStream)this.getClass().getClassLoader().getResourceAsStream(GENDER_FILE_LOCATION), (Lang)Lang.TURTLE);
        StmtIterator iter = model.listStatements(null, model.createProperty(GENDER_PROPERTY), (RDFNode)null);
        while (iter.hasNext()) {
            Statement st = (Statement)iter.next();
            Literal lit = st.getObject().asLiteral();
            if (lit.equals((Object)maleLit)) {
                this.male.add(st.getSubject().getURI());
                continue;
            }
            if (!lit.equals((Object)femaleLit)) continue;
            this.female.add(st.getSubject().getURI());
        }
    }
}

