/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.triple2nl.gender;

import edu.stanford.nlp.ie.machinereading.structure.MachineReadingAnnotations;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.GenderAnnotator;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import java.util.List;
import java.util.Properties;
import org.aksw.simba.bengal.triple2nl.gender.Gender;
import org.aksw.simba.bengal.triple2nl.gender.GenderDetector;
import org.aksw.triple2nl.nlp.StanfordCoreNLPWrapper;

public class CoreNLPGenderDetector
implements GenderDetector {
    private final StanfordCoreNLPWrapper pipeline;

    public CoreNLPGenderDetector(StanfordCoreNLPWrapper pipeline) {
        this.pipeline = pipeline;
        pipeline.addAnnotator((Annotator)new GenderAnnotator());
    }

    public CoreNLPGenderDetector() {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,ssplit,pos,parse,gender");
        props.put("ssplit.isOneSentence", "true");
        this.pipeline = new StanfordCoreNLPWrapper((AnnotationPipeline)new StanfordCoreNLP(props));
    }

    @Override
    public Gender getGender(String name) {
        Annotation document = new Annotation(name);
        this.pipeline.annotate(document);
        for (CoreMap sentence : (List)document.get(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                String gender = (String)token.get(MachineReadingAnnotations.GenderAnnotation.class);
                if (gender == null) continue;
                if (gender.equals("MALE")) {
                    return Gender.MALE;
                }
                if (!gender.equals("FEMALE")) continue;
                return Gender.FEMALE;
            }
        }
        return Gender.UNKNOWN;
    }
}

