/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.triple2nl.functionality;

import java.io.File;
import java.io.InputStream;
import java.util.Set;
import org.aksw.simba.bengal.triple2nl.functionality.FunctionalityDetector;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class StatisticalFunctionalityDetector
implements FunctionalityDetector {
    private OWLOntology ontology;
    private double threshold;
    private OWLDataFactory dataFactory;
    private final IRI confidencePropertyIRI = IRI.create((String)"http://www.dl-learner.org/ontologies/enrichment.owl#confidence");

    public StatisticalFunctionalityDetector(File ontologyFile, double threshold) {
        try {
            OWLOntologyManager man = OWLManager.createOWLOntologyManager();
            this.ontology = man.loadOntologyFromOntologyDocument(ontologyFile);
            this.dataFactory = man.getOWLDataFactory();
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
        }
        this.threshold = threshold;
    }

    public StatisticalFunctionalityDetector(InputStream is, double threshold) {
        try {
            OWLOntologyManager man = OWLManager.createOWLOntologyManager();
            this.ontology = man.loadOntologyFromOntologyDocument(is);
            this.dataFactory = man.getOWLDataFactory();
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
        }
        this.threshold = threshold;
    }

    @Override
    public boolean isFunctional(String iri) {
        Double confidence;
        Set axioms = this.ontology.getFunctionalDataPropertyAxioms((OWLDataPropertyExpression)this.dataFactory.getOWLDataProperty(IRI.create((String)iri)));
        if (!axioms.isEmpty() && (confidence = this.getConfidenceValue((OWLAxiom)axioms.iterator().next())) != null && confidence >= this.threshold) {
            return true;
        }
        axioms = this.ontology.getFunctionalObjectPropertyAxioms((OWLObjectPropertyExpression)this.dataFactory.getOWLObjectProperty(IRI.create((String)iri)));
        return !axioms.isEmpty() && (confidence = this.getConfidenceValue((OWLAxiom)axioms.iterator().next())) != null && confidence >= this.threshold;
    }

    private Double getConfidenceValue(OWLAxiom axiom) {
        Set annotations = axiom.getAnnotations(this.dataFactory.getOWLAnnotationProperty(this.confidencePropertyIRI));
        if (!annotations.isEmpty()) {
            OWLLiteral val = (OWLLiteral)((OWLAnnotation)annotations.iterator().next()).getValue();
            return val.parseDouble();
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        StatisticalFunctionalityDetector detector = new StatisticalFunctionalityDetector(new File("resources/dbpedia_functional_axioms.owl"), 0.9);
        System.out.println(detector.isFunctional("http://dbpedia.org/ontology/occupation"));
        System.out.println(detector.isFunctional("http://dbpedia.org/ontology/birthDate"));
        System.out.println(detector.isFunctional("http://dbpedia.org/ontology/populationTotal"));
    }
}

