/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.triple2nl.converter;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.jena_sparql_api.model.QueryExecutionFactoryModel;
import org.aksw.simba.bengal.triple2nl.converter.IRIConverter;
import org.aksw.simba.bengal.triple2nl.converter.URIDereferencer;
import org.apache.commons.collections15.map.LRUMap;
import org.apache.commons.lang.StringUtils;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.engine.http.QueryExceptionHTTP;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;
import org.apache.jena.web.HttpSC;
import org.dllearner.kb.sparql.SparqlEndpoint;
import org.dllearner.utilities.OwlApiJenaUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.util.SimpleIRIShortFormProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIRIConverter
implements IRIConverter {
    private static final Logger logger = LoggerFactory.getLogger(DefaultIRIConverter.class);
    private IRIShortFormProvider sfp = new SimpleIRIShortFormProvider();
    private LRUMap<String, String> uri2LabelCache = new LRUMap(200);
    private QueryExecutionFactory qef;
    private List<String> labelProperties = Lists.newArrayList((Object[])new String[]{"http://www.w3.org/2000/01/rdf-schema#label", "http://www.w3.org/2004/02/skos/core#prefLabel", "http://www.w3.org/2004/02/skos/core#altLabel", "http://xmlns.com/foaf/0.1/name"});
    private String language = "en";
    private boolean splitCamelCase = true;
    private boolean replaceUnderScores = true;
    private boolean toLowerCase = false;
    private boolean omitContentInBrackets = true;
    private URIDereferencer uriDereferencer;

    public DefaultIRIConverter(SparqlEndpoint endpoint, String cacheDirectory) {
        this((QueryExecutionFactory)new QueryExecutionFactoryHttp(endpoint.getURL().toString(), (Collection)endpoint.getDefaultGraphURIs()), cacheDirectory);
    }

    public DefaultIRIConverter(SparqlEndpoint endpoint) {
        this(endpoint, null);
    }

    public DefaultIRIConverter(QueryExecutionFactory qef) {
        this(qef, null);
    }

    public DefaultIRIConverter(QueryExecutionFactory qef, String cacheDirectory) {
        this.qef = qef;
        if (cacheDirectory == null) {
            cacheDirectory = System.getProperty("java.io.tmpdir") + "/triple2nl/cache";
        }
        cacheDirectory = cacheDirectory + "/dereferenced";
        try {
            Files.createDirectories(Paths.get(cacheDirectory, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error("Creation of folder + " + cacheDirectory + " failed.", (Throwable)e);
        }
        logger.warn("Using folder " + cacheDirectory + " as cache for IRI converter.");
        this.uriDereferencer = new URIDereferencer(new File(cacheDirectory));
    }

    public DefaultIRIConverter(Model model) {
        this((QueryExecutionFactory)new QueryExecutionFactoryModel(model));
    }

    public DefaultIRIConverter(OWLOntology ontology) {
        this(OwlApiJenaUtils.getModel((OWLOntology)ontology));
    }

    @Override
    public String convert(String iri) {
        return this.convert(iri, false);
    }

    @Override
    public String convert(String iri, boolean dereferenceURI) {
        if (iri.equals(RDF.type.getURI())) {
            return "type";
        }
        if (iri.equals(RDFS.label.getURI())) {
            return "label";
        }
        String label = (String)this.uri2LabelCache.get((Object)iri);
        if (label == null) {
            try {
                label = this.getLabelFromBuiltIn(iri);
            }
            catch (Exception e) {
                logger.error("Getting label for " + iri + " from knowledge base failed.", (Throwable)e);
            }
            if (label == null) {
                try {
                    label = this.getLabelFromKnowledgebase(iri);
                }
                catch (Exception e) {
                    logger.error("Getting label for " + iri + " from knowledge base failed.", (Throwable)e);
                }
            }
            if (dereferenceURI && label == null) {
                try {
                    label = this.getLabelFromLinkedData(iri);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("Dereferencing of " + iri + " failed.");
                }
            }
            if (label == null) {
                try {
                    label = this.sfp.getShortForm(IRI.create((String)URLDecoder.decode(iri, "UTF-8")));
                    label = this.normalize(label);
                }
                catch (UnsupportedEncodingException e) {
                    logger.error("Getting short form of " + iri + "failed.", (Throwable)e);
                }
            }
            if (label == null) {
                label = iri;
            }
        }
        this.uri2LabelCache.put((Object)iri, (Object)label);
        return label;
    }

    public void setLabelProperties(List<String> labelProperties) {
        this.labelProperties = labelProperties;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setSplitCamelCase(boolean splitCamelCase) {
        this.splitCamelCase = splitCamelCase;
    }

    public void setReplaceUnderScores(boolean replaceUnderScores) {
        this.replaceUnderScores = replaceUnderScores;
    }

    public void setOmitContentInBrackets(boolean omitContentInBrackets) {
        this.omitContentInBrackets = omitContentInBrackets;
    }

    public void setToLowerCase(boolean toLowerCase) {
        this.toLowerCase = toLowerCase;
    }

    private String getLabelFromBuiltIn(String uri) {
        try {
            IRI iri = IRI.create((String)URLDecoder.decode(uri, "UTF-8"));
            if (iri.isReservedVocabulary()) {
                String label = this.sfp.getShortForm(iri);
                if (uri.equals(XSD.nonNegativeInteger.getURI()) || uri.equals(XSD.integer.getURI()) || uri.equals(XSD.negativeInteger.getURI()) || uri.equals(XSD.decimal.getURI()) || uri.equals(XSD.xdouble.getURI()) || uri.equals(XSD.xfloat.getURI()) || uri.equals(XSD.xint.getURI()) || uri.equals(XSD.xshort.getURI()) || uri.equals(XSD.xbyte.getURI()) || uri.equals(XSD.xlong.getURI())) {
                    label = label + " value";
                }
                return label;
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Getting short form of " + uri + "failed.", (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getLabelFromKnowledgebase(String iri) {
        ParameterizedSparqlString query = new ParameterizedSparqlString("SELECT ?label WHERE {?s ?p1 ?o .optional {\t\t?s ?p ?label. \t\tFILTER (LANGMATCHES(LANG(?label),'" + this.language + "' ))\t}optional {     ?s ?p ?label   }} ORDER BY DESC(?label) LIMIT 1");
        query.setIri("s", iri);
        Iterator<String> iterator = this.labelProperties.iterator();
        while (iterator.hasNext()) {
            String labelProperty = iterator.next();
            query.setIri("p", labelProperty);
            try {
                QueryExecution qe = this.qef.createQueryExecution(query.toString());
                Throwable throwable = null;
                try {
                    ResultSet rs = qe.execSelect();
                    if (!rs.hasNext()) continue;
                    String string = rs.next().getLiteral("label").getLexicalForm();
                    return string;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (qe == null) continue;
                    if (throwable != null) {
                        try {
                            qe.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    qe.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                int code = -1;
                if (e.getCause() instanceof QueryExceptionHTTP) {
                    code = ((QueryExceptionHTTP)e.getCause()).getResponseCode();
                } else if (e instanceof QueryExceptionHTTP) {
                    code = ((QueryExceptionHTTP)e).getResponseCode();
                }
                logger.warn("Getting label of " + iri + " from SPARQL endpoint failed: " + code + " - " + HttpSC.getCode((int)code).getMessage());
            }
        }
        return null;
    }

    private String getLabelFromLinkedData(String iri) {
        logger.debug("Get label for " + iri + " from Linked Data...");
        try {
            Model model = this.uriDereferencer.dereference(iri);
            for (String labelProperty : this.labelProperties) {
                for (Statement st : model.listStatements(model.getResource(iri), model.getProperty(labelProperty), (RDFNode)null).toList()) {
                    Literal literal = st.getObject().asLiteral();
                    String language = literal.getLanguage();
                    if (language == null || !language.equals(this.language)) continue;
                    return literal.getLexicalForm();
                }
            }
        }
        catch (URIDereferencer.DereferencingFailedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private String normalize(String s) {
        if (this.replaceUnderScores) {
            s = s.replace("_", " ");
        }
        if (this.splitCamelCase) {
            s = DefaultIRIConverter.splitCamelCase(s);
        }
        if (this.toLowerCase) {
            s = s.toLowerCase();
        }
        if (this.omitContentInBrackets) {
            s = s.replaceAll("\\(.+?\\)", "").trim();
        }
        return s;
    }

    private static String splitCamelCase(String s) {
        StringBuilder sb = new StringBuilder();
        for (String token : s.split(" ")) {
            String[] split = StringUtils.splitByCharacterTypeCamelCase((String)token);
            ArrayDeque<String> list = new ArrayDeque<String>();
            for (int i = 0; i < split.length; ++i) {
                String s1 = split[i];
                if (i > 0 && s1.length() == 1 && !org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)s1)) {
                    list.add((String)list.pollLast() + s1);
                    continue;
                }
                list.add(s1);
            }
            sb.append(StringUtils.join(list, (char)' ')).append(" ");
        }
        return sb.toString().trim();
    }

    public static void main(String[] args) {
        DefaultIRIConverter converter = new DefaultIRIConverter(SparqlEndpoint.getEndpointDBpedia());
        String label = converter.convert("http://dbpedia.org/resource/Nuclear_Reactor_Technology");
        System.out.println(label);
        label = converter.convert("http://dbpedia.org/resource/Woodroffe_School");
        System.out.println(label);
        label = converter.convert("http://dbpedia.org/ontology/isBornIn", true);
        System.out.println(label);
        label = converter.convert("http://www.w3.org/2001/XMLSchema#integer");
        System.out.println(label);
    }
}

