/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.paraphrasing;

import com.carrotsearch.hppc.BitSet;
import edu.smu.tspell.wordnet.Synset;
import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.WordNetDatabase;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.aksw.gerbil.io.nif.impl.TurtleNIFWriter;
import org.aksw.gerbil.transfer.nif.Document;
import org.aksw.gerbil.transfer.nif.Marking;
import org.aksw.gerbil.transfer.nif.data.DocumentImpl;
import org.aksw.gerbil.transfer.nif.data.NamedEntity;
import org.aksw.simba.bengal.paraphrasing.ParaphraseService;
import org.aksw.simba.bengal.selector.SimpleSummarySelector;
import org.aksw.simba.bengal.verbalizer.SemWeb2NLVerbalizer;
import org.apache.jena.rdf.model.Statement;
import org.dllearner.kb.sparql.SparqlEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGFactory;
import simplenlg.lexicon.Lexicon;
import simplenlg.phrasespec.SPhraseSpec;
import simplenlg.realiser.english.Realiser;

public class Paraphrasing
implements ParaphraseService,
Comparator<NamedEntity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Paraphrasing.class);
    static String file = "/config/bengal.properties";
    public static Properties prop = new Properties();

    public static Paraphrasing create() {
        Paraphrasing service = null;
        service = new Paraphrasing();
        return service;
    }

    protected Paraphrasing() {
    }

    @Override
    public String paraphrase(String originalText, String dictPath) {
        try {
            Properties prop = new Properties();
            InputStream input = Paraphrasing.class.getResourceAsStream("/config/bengal.properties");
            prop.load(input);
            String wordnetPath = dictPath;
            Lexicon lexicon = Lexicon.getDefaultLexicon();
            NLGFactory nlgFactory = new NLGFactory(lexicon);
            Realiser realiser = new Realiser(lexicon);
            MaxentTagger tagger = new MaxentTagger("edu/stanford/nlp/models/pos-tagger/english-left3words/english-left3words-distsim.tagger");
            SPhraseSpec s = nlgFactory.createClause();
            String[] sentences = originalText.split(Pattern.quote(". "));
            for (int k = 0; k < sentences.length; ++k) {
                sentences[k] = sentences[k].replace(".", "");
            }
            int vSentences = 0;
            for (int i = 0; i < sentences.length; ++i) {
                try {
                    ++vSentences;
                    String[] Phrase = new String[100];
                    Phrase = sentences[i].split("\\s+");
                    String[] Pos2 = sentences[i].split("\\s+");
                    for (int k = 0; k < Pos2.length; ++k) {
                        Pos2[k] = tagger.tagString(Pos2[k]);
                    }
                    int value = 0;
                    int value2 = 0;
                    String pronoun = "none";
                    for (int k = 0; k < Pos2.length; ++k) {
                        if (Pos2[k].contains("PRP")) {
                            pronoun = Pos2[k];
                        }
                        if (Pos2[k].contains("_V") && value == 0) {
                            value = k;
                        }
                        if (!Pos2[k].contains("_NN ") || value2 != 0) continue;
                        value2 = k;
                    }
                    if (value2 > 0) {
                        Phrase[value2] = this.synWN(Phrase[value2], Pos2[value2], wordnetPath);
                    }
                    s.setVerb((Object)Phrase[value]);
                    String inf_verb = s.getVerb().toString().replace("WordElement[", "").replace(":VERB]", "");
                    if (!inf_verb.equals("be")) {
                        s.setVerb((Object)this.synWN(s.getVerb().toString().replace("WordElement[", "").replace(":VERB]", ""), Pos2[value], wordnetPath));
                    }
                    StringBuilder sb = new StringBuilder();
                    if (Phrase.length > 1) {
                        if (Pos2[0].contains(Phrase[0]) && Pos2[0].contains("PRP")) {
                            Phrase[0] = Phrase[0].toLowerCase();
                        }
                        sb.append(Phrase[0]);
                        for (int w = 1; w < value; ++w) {
                            sb.append(" ").append(Phrase[w]);
                        }
                    }
                    s.setSubject((Object)sb.toString());
                    StringBuilder sc = new StringBuilder();
                    if (Phrase.length > 1) {
                        sc.append(Phrase[value + 1]);
                        for (int z = value + 2; z < Phrase.length; ++z) {
                            sc.append(" ").append(Phrase[z]);
                        }
                    }
                    s.setObject((Object)sc.toString());
                    if (!inf_verb.equals("be")) {
                        s.setFeature("perfect", true);
                    }
                    if (!Pos2[value].equals(Pos2.length) && !Pos2[value + 1].contains("JJ")) {
                        s.setFeature("passive", true);
                    }
                    String output = realiser.realiseSentence((NLGElement)s);
                    String[] paraphraser = output.split("\\s+");
                    int find = 0;
                    int found = 0;
                    StringBuilder end = new StringBuilder();
                    if (paraphraser.length > 1) {
                        end.append(paraphraser[0]);
                        for (int z = 1; z < paraphraser.length; ++z) {
                            if (z == found || paraphraser[z].equals("been") && (inf_verb.equals("be") && ++find > 0 || !inf_verb.equals("be") && find > 1) || paraphraser[z].equals("by")) continue;
                            end.append(" ").append(paraphraser[z]);
                        }
                    }
                    sentences[i] = output = end.toString();
                    value = 0;
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Paraphrasing failed, error" + e);
                }
            }
            StringBuilder paraphrased = new StringBuilder();
            if (sentences.length >= 1) {
                paraphrased.append(sentences[0]);
                for (int z = 1; z < sentences.length; ++z) {
                    paraphrased.append(" ").append(sentences[z]);
                }
            }
            String output = paraphrased.toString();
            System.out.println("Paraphrased text:  " + output);
            return output;
        }
        catch (Exception e) {
            LOGGER.error("Exception from NLG. Returning null.", (Throwable)e);
            return originalText;
        }
    }

    public String synWN(String word, String tag, String wordnetPath) {
        System.setProperty("wordnet.database.dir", wordnetPath);
        WordNetDatabase database = WordNetDatabase.getFileInstance();
        Synset[] synsets = null;
        if (tag.contains("_V")) {
            synsets = database.getSynsets(word, SynsetType.VERB);
        } else if (tag.contains("_NN")) {
            synsets = database.getSynsets(word, SynsetType.NOUN);
        }
        String synonym = "";
        if (synsets.length > 0) {
            ArrayList<String> al = new ArrayList<String>();
            HashSet<String> hs = new HashSet<String>();
            for (int i = 0; i < synsets.length; ++i) {
                String[] wordForms = synsets[i].getWordForms();
                for (int j = 0; j < wordForms.length; ++j) {
                    al.add(wordForms[j]);
                }
            }
            hs.addAll(al);
            al.clear();
            al.addAll(hs);
            for (int j = 0; j < al.size(); ++j) {
                if (((String)al.get(j)).equals(word)) continue;
                synonym = (String)al.get(j);
                break;
            }
            if (synonym.equals("")) {
                return word;
            }
            return synonym;
        }
        return word;
    }

    @Override
    public int compare(NamedEntity n1, NamedEntity n2) {
        int diff = n1.getLength() - n2.getLength();
        if (diff < 0) {
            return 1;
        }
        if (diff > 0) {
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        HashSet<String> classes = new HashSet<String>();
        classes.add("<http://dbpedia.org/ontology/Person>");
        classes.add("<http://dbpedia.org/ontology/Place>");
        classes.add("<http://dbpedia.org/ontology/Organisation>");
        SimpleSummarySelector ts = new SimpleSummarySelector(classes, classes, "http://dbpedia.org/sparql", null);
        List<Statement> stmts = ts.getNextStatements();
        Document doc = new SemWeb2NLVerbalizer(SparqlEndpoint.getEndpointDBpedia()).generateDocument(stmts, prop.getProperty("surfaceForms"));
        Paraphrasing service = new Paraphrasing();
        String text = doc.getText();
        String paraphrases = service.paraphrase(text, prop.getProperty("dict"));
        DocumentImpl newDoc = new DocumentImpl(paraphrases, doc.getDocumentURI());
        List originalNes = doc.getMarkings(NamedEntity.class);
        Collections.sort(originalNes, service);
        BitSet blockedPositions = new BitSet((long)paraphrases.length());
        BitSet currentPositions = new BitSet((long)paraphrases.length());
        for (NamedEntity ne : originalNes) {
            String label = text.substring(ne.getStartPosition(), ne.getStartPosition() + ne.getLength());
            int pos = -ne.getLength();
            do {
                if ((pos = paraphrases.indexOf(label, pos + ne.getLength())) < 0) {
                    LOGGER.warn("The paraphrasing changed one of the entities. Couldn't find the surface form \"{}\" in the text \"{}\". Returning the original document.", (Object)label, (Object)paraphrases);
                }
                currentPositions.clear();
                try {
                    currentPositions.set((long)pos, (long)(pos + ne.getLength()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (BitSet.intersectionCount((BitSet)blockedPositions, (BitSet)currentPositions) > 0L);
            newDoc.addMarking((Marking)new NamedEntity(pos, ne.getLength(), ne.getUris()));
            blockedPositions.or(currentPositions);
        }
        ArrayList<DocumentImpl> documents = new ArrayList<DocumentImpl>();
        if (newDoc != null) {
            LOGGER.info("Created document #1");
            newDoc.setDocumentURI("http://aksw.org/generated/1");
            documents.add(newDoc);
        }
        String filePath = "Pharaphrasetest.ttl";
        TurtleNIFWriter writer = new TurtleNIFWriter();
        FileOutputStream fout = null;
        int i = 0;
        try {
            fout = new FileOutputStream(filePath);
            writer.writeNIF(documents.subList(i, i + 1), (OutputStream)fout);
        }
        catch (Exception e) {
            LOGGER.error("Error while writing the documents to file. Aborting.", (Throwable)e);
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception exception) {}
            }
        }
        System.out.println("Doc" + doc.toString());
        System.out.println("Paraphrased doc" + newDoc.toString());
    }

    static {
        try {
            prop.load(Paraphrasing.class.getResourceAsStream(file));
        }
        catch (IOException e) {
            LOGGER.warn("Couldn't load config file".concat(file));
        }
    }
}

