/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.simba.bengal.config;

import java.io.FileInputStream;
import java.util.Properties;
import org.aksw.simba.bengal.selector.TripleSelectorFactory;

public class BengalRunConfig {
    public static final Properties PROP = new Properties();
    public static final int DEFAULT_NUMBER_OF_DOCUMENTS = 1;
    public static final long DEF_SEED;
    public static final int DEF_MIN_SENTENCE = 3;
    public static final int DEF_MAX_SENTENCE = 10;
    public static final long DEF_WAITING_TIME_BETWEEN_DOCUMENTS = 500L;
    public static final String DEF_SPARQL_EP = "http://dbpedia.org/sparql";
    public static final String DEF_DICT_PATH;
    public static final String DEF_SURFACEFORM_PATH;
    private int numberOfDocs = 1;
    private long seed = DEF_SEED;
    private int minSentence = 3;
    private int maxSentence = 10;
    private long waitTime = 500L;
    private String sqparqlEndPoint = "http://dbpedia.org/sparql";
    private String selectorType;
    private boolean useParaphrasing = false;
    private boolean usePronouns = false;
    private boolean useSurfaceForms = false;
    private boolean useAvatars = false;
    private boolean useOnlyObjectProps = false;
    private String dictDirPath = DEF_DICT_PATH;
    private String surfaceFormFilePath = DEF_SURFACEFORM_PATH;

    public int getNumberOfDocs() {
        return this.numberOfDocs;
    }

    public void setNumberOfDocs(int defNumberOf) {
        this.numberOfDocs = defNumberOf;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public int getMinSentence() {
        return this.minSentence;
    }

    public void setMinSentence(int minSentence) {
        this.minSentence = minSentence;
    }

    public int getMaxSentence() {
        return this.maxSentence;
    }

    public void setMaxSentence(int maxSentence) {
        this.maxSentence = maxSentence;
    }

    public String getSelectorType() {
        return this.selectorType;
    }

    public void setSelectorType(String selectorType) {
        this.selectorType = selectorType;
    }

    public boolean isUseParaphrasing() {
        return this.useParaphrasing;
    }

    public void setUseParaphrasing(boolean useParaphrasing) {
        this.useParaphrasing = useParaphrasing;
    }

    public boolean isUsePronouns() {
        return this.usePronouns;
    }

    public void setUsePronouns(boolean usePronouns) {
        this.usePronouns = usePronouns;
    }

    public boolean isUseSurfaceForms() {
        return this.useSurfaceForms;
    }

    public void setUseSurfaceForms(boolean useSurfaceForms) {
        this.useSurfaceForms = useSurfaceForms;
    }

    public boolean isUseAvatars() {
        return this.useAvatars;
    }

    public void setUseAvatars(boolean useAvatars) {
        this.useAvatars = useAvatars;
    }

    public boolean isUseOnlyObjectProps() {
        return this.useOnlyObjectProps;
    }

    public void setUseOnlyObjectProps(boolean useOnlyObjectProps) {
        this.useOnlyObjectProps = useOnlyObjectProps;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
    }

    public TripleSelectorFactory.SelectorType getSelectorTypeEnum() {
        TripleSelectorFactory.SelectorType res = null;
        if (this.selectorType.matches("star")) {
            res = TripleSelectorFactory.SelectorType.STAR;
        } else if (this.selectorType.matches("hybrid")) {
            res = TripleSelectorFactory.SelectorType.HYBRID;
        } else if (this.selectorType.matches("path")) {
            res = TripleSelectorFactory.SelectorType.PATH;
        } else if (this.selectorType.matches("sym")) {
            res = TripleSelectorFactory.SelectorType.SIM_STAR;
        }
        return res;
    }

    public String getSqparqlEndPoint() {
        return this.sqparqlEndPoint;
    }

    public void setSparqlEndPoint(String sqparqlEndPoint) {
        this.sqparqlEndPoint = sqparqlEndPoint;
    }

    public String getDictDirPath() {
        return this.dictDirPath;
    }

    public void setDictDirPath(String dictDirPath) {
        this.dictDirPath = dictDirPath;
    }

    public String getSurfaceFormFilePath() {
        return this.surfaceFormFilePath;
    }

    public void setSurfaceFormFilePath(String surfaceFormFilePath) {
        this.surfaceFormFilePath = surfaceFormFilePath;
    }

    public String toString() {
        return "BengalRunConfig [numberOfDocs=" + this.numberOfDocs + ", seed=" + this.seed + ", minSentence=" + this.minSentence + ", maxSentence=" + this.maxSentence + ", waitTime=" + this.waitTime + ", sqparqlEndPoint=" + this.sqparqlEndPoint + ", selectorType=" + this.selectorType + ", useParaphrasing=" + this.useParaphrasing + ", usePronouns=" + this.usePronouns + ", useSurfaceForms=" + this.useSurfaceForms + ", useAvatars=" + this.useAvatars + ", useOnlyObjectProps=" + this.useOnlyObjectProps + ", dictDirPath=" + this.dictDirPath + ", surfaceFormFilePath=" + this.surfaceFormFilePath + "]";
    }

    static {
        try {
            FileInputStream input = new FileInputStream("src/main/resources/config/bengal.properties");
            PROP.load(input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DEF_SEED = System.currentTimeMillis();
        DEF_DICT_PATH = PROP.getProperty("dict");
        DEF_SURFACEFORM_PATH = PROP.getProperty("surfaceForms");
    }
}

