/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.validate.ws;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aksw.rdfunit.RDFUnitConfiguration;
import org.aksw.rdfunit.enums.TestCaseExecutionType;
import org.aksw.rdfunit.exceptions.TestCaseExecutionException;
import org.aksw.rdfunit.io.format.SerializationFormat;
import org.aksw.rdfunit.io.writer.RDFWriter;
import org.aksw.rdfunit.io.writer.RDFWriterException;
import org.aksw.rdfunit.io.writer.RDFWriterFactory;
import org.aksw.rdfunit.sources.Source;
import org.aksw.rdfunit.tests.TestSuite;
import org.aksw.rdfunit.validate.ParameterException;

public abstract class RDFUnitWebService
extends HttpServlet {
    public void init() throws ServletException {
        super.init();
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.handleRequestAndRespond(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.handleRequestAndRespond(httpServletRequest, httpServletResponse);
    }

    private void handleRequestAndRespond(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        RDFUnitConfiguration configuration = null;
        try {
            configuration = this.getConfiguration(httpServletRequest);
        }
        catch (ParameterException e) {
            String message = e.getMessage();
            if (message != null) {
                this.printMessage(httpServletResponse, message);
            }
            this.printHelpMessage(httpServletResponse);
            httpServletResponse.getWriter().close();
            return;
        }
        assert (configuration != null);
        Source dataset = configuration.getTestSource();
        TestSuite testSuite = this.getTestSuite(configuration, dataset);
        assert (testSuite != null);
        Model results = null;
        try {
            results = this.validate(configuration, dataset, testSuite);
        }
        catch (TestCaseExecutionException e) {
            // empty catch block
        }
        assert (results != null);
        try {
            this.writeResults(configuration, results, httpServletResponse);
        }
        catch (RDFWriterException e) {
            this.printMessage(httpServletResponse, e.getMessage());
        }
    }

    private void writeResults(RDFUnitConfiguration configuration, Model model, HttpServletResponse httpServletResponse) throws RDFWriterException, IOException {
        SerializationFormat serializationFormat = configuration.geFirstOutputFormat();
        if (serializationFormat == null) {
            throw new RDFWriterException("Invalid output format");
        }
        httpServletResponse.setContentType(serializationFormat.getHeaderType());
        RDFWriter RDFWriter2 = RDFWriterFactory.createWriterFromFormat((OutputStream)httpServletResponse.getOutputStream(), (SerializationFormat)serializationFormat, (TestCaseExecutionType)configuration.getTestCaseExecutionType());
        RDFWriter2.write(model);
    }

    protected abstract RDFUnitConfiguration getConfiguration(HttpServletRequest var1) throws ParameterException;

    protected abstract TestSuite getTestSuite(RDFUnitConfiguration var1, Source var2);

    protected abstract Model validate(RDFUnitConfiguration var1, Source var2, TestSuite var3) throws TestCaseExecutionException;

    protected abstract void printHelpMessage(HttpServletResponse var1) throws IOException;

    protected void printMessage(HttpServletResponse httpServletResponse, String message) throws IOException {
        httpServletResponse.setContentType("text/html");
        PrintWriter out = httpServletResponse.getWriter();
        out.println("<pre>" + message + "</pre>");
    }
}

