/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.validate.wrappers;

import com.hp.hpl.jena.rdf.model.Model;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.aksw.rdfunit.RDFUnit;
import org.aksw.rdfunit.Utils.CacheUtils;
import org.aksw.rdfunit.Utils.RDFUnitUtils;
import org.aksw.rdfunit.Utils.TestUtils;
import org.aksw.rdfunit.enums.TestCaseExecutionType;
import org.aksw.rdfunit.exceptions.TripleReaderException;
import org.aksw.rdfunit.io.RDFFirstSuccessReader;
import org.aksw.rdfunit.io.RDFModelReader;
import org.aksw.rdfunit.io.RDFReader;
import org.aksw.rdfunit.io.RDFReaderFactory;
import org.aksw.rdfunit.io.RDFStreamReader;
import org.aksw.rdfunit.sources.DumpTestSource;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.Source;
import org.aksw.rdfunit.tests.TestSuite;
import org.aksw.rdfunit.tests.executors.TestExecutor;
import org.aksw.rdfunit.tests.executors.TestExecutorFactory;
import org.aksw.rdfunit.tests.executors.monitors.SimpleTestExecutorMonitor;
import org.aksw.rdfunit.tests.executors.monitors.TestExecutorMonitor;
import org.aksw.rdfunit.tests.results.DatasetOverviewResults;

public class RDFUnitStaticWrapper {
    private static volatile RDFReader ontologyReader = null;
    private static volatile SchemaSource ontologySource = null;
    private static volatile TestSuite testSuite = null;
    private static volatile String ontologyURI = null;
    private static volatile String ontologyResourceURI = null;

    private RDFUnitStaticWrapper() {
    }

    public static void initWrapper(String _ontologyURI) {
        RDFUnitStaticWrapper.initWrapper(_ontologyURI, null);
    }

    public static void initWrapper(String _ontologyURI, String _ontologyResourceURI) {
        ontologyURI = _ontologyURI;
        ontologyResourceURI = _ontologyResourceURI;
    }

    private static RDFReader getOntologyReader() {
        if (ontologyReader == null) {
            if (ontologyURI == null && ontologyResourceURI == null) {
                throw new IllegalArgumentException("RDFUnitStaticWrapper was not initialized properly. Call initWrapper() once before any validation. ");
            }
            ArrayList<RDFReader> nifReaderList = new ArrayList<RDFReader>();
            if (ontologyResourceURI != null) {
                nifReaderList.add(RDFReaderFactory.createResourceReader((String)ontologyResourceURI));
            }
            nifReaderList.add(RDFReaderFactory.createDereferenceReader((String)ontologyURI));
            ontologyReader = new RDFFirstSuccessReader(nifReaderList);
        }
        return ontologyReader;
    }

    private static SchemaSource getOntologySource() {
        if (ontologySource == null) {
            ontologySource = new SchemaSource("custom", ontologyURI, RDFUnitStaticWrapper.getOntologyReader());
        }
        return ontologySource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TestSuite getTestSuite() {
        if (testSuite != null) return testSuite;
        Class<RDFUnitStaticWrapper> clazz = RDFUnitStaticWrapper.class;
        synchronized (RDFUnitStaticWrapper.class) {
            ArrayList manualTestCases;
            if (testSuite != null) return testSuite;
            SchemaSource ontologySource = RDFUnitStaticWrapper.getOntologySource();
            RDFStreamReader manualTestCaseReader = new RDFStreamReader(RDFUnitStaticWrapper.class.getResourceAsStream(CacheUtils.getSourceManualTestFile((String)"/org/aksw/rdfunit/tests/", (Source)ontologySource)));
            try {
                manualTestCases = TestUtils.instantiateTestsFromModel((Model)manualTestCaseReader.read());
            }
            catch (TripleReaderException e) {
                manualTestCases = new ArrayList();
            }
            RDFUnit rdfunit = new RDFUnit();
            try {
                rdfunit.initPatternsAndGenerators(RDFUnitUtils.getPatternsFromResource(), RDFUnitUtils.getAutoGeneratorsALLFromResource());
            }
            catch (TripleReaderException e) {
                testSuite = new TestSuite(manualTestCases);
                // ** MonitorExit[var0] (shouldn't be in output)
                return testSuite;
            }
            Collection autoTestCases = TestUtils.instantiateTestsFromAG((Collection)rdfunit.getAutoGenerators(), (Source)ontologySource);
            ArrayList allTestCases = new ArrayList();
            allTestCases.addAll(autoTestCases);
            allTestCases.addAll(manualTestCases);
            testSuite = new TestSuite(allTestCases);
            // ** MonitorExit[var0] (shouldn't be in output)
            return testSuite;
        }
    }

    public static Model validate(Model input) {
        return RDFUnitStaticWrapper.validate(input, TestCaseExecutionType.rlogTestCaseResult);
    }

    public static Model validate(Model input, TestCaseExecutionType executionType) {
        return RDFUnitStaticWrapper.validate(input, executionType, "custom");
    }

    public static Model validate(Model input, String inputURI) {
        return RDFUnitStaticWrapper.validate(input, TestCaseExecutionType.rlogTestCaseResult, inputURI);
    }

    public static Model validate(Model input, TestCaseExecutionType executionType, String inputURI) {
        DatasetOverviewResults overviewResults = new DatasetOverviewResults();
        return RDFUnitStaticWrapper.validate(input, executionType, inputURI, overviewResults);
    }

    public static Model validate(Model input, TestCaseExecutionType executionType, String inputURI, DatasetOverviewResults overviewResults) {
        boolean enableRDFUnitLogging = false;
        SimpleTestExecutorMonitor testExecutorMonitor = new SimpleTestExecutorMonitor(false);
        TestExecutor testExecutor = TestExecutorFactory.createTestExecutor((TestCaseExecutionType)executionType);
        testExecutor.addTestExecutorMonitor((TestExecutorMonitor)testExecutorMonitor);
        DumpTestSource modelSource = new DumpTestSource("custom", inputURI, (RDFReader)new RDFModelReader(input), Arrays.asList(RDFUnitStaticWrapper.getOntologySource()));
        testExecutor.execute((Source)modelSource, RDFUnitStaticWrapper.getTestSuite(), 0);
        overviewResults.set(testExecutorMonitor.getOverviewResults());
        return testExecutorMonitor.getModel();
    }

    public static Model validate(TestCaseExecutionType testCaseExecutionType, Source dataset, TestSuite testSuite) {
        boolean enableRDFUnitLogging = false;
        SimpleTestExecutorMonitor testExecutorMonitor = new SimpleTestExecutorMonitor(false);
        TestExecutor testExecutor = TestExecutorFactory.createTestExecutor((TestCaseExecutionType)testCaseExecutionType);
        testExecutor.addTestExecutorMonitor((TestExecutorMonitor)testExecutorMonitor);
        testExecutor.execute(dataset, testSuite, 0);
        return testExecutorMonitor.getModel();
    }
}

