/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.validate.cli;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.ArrayList;
import java.util.Arrays;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.model.QueryExecutionFactoryModel;
import org.aksw.rdfunit.RDFUnit;
import org.aksw.rdfunit.RDFUnitConfiguration;
import org.aksw.rdfunit.Utils.RDFUnitUtils;
import org.aksw.rdfunit.coverage.TestCoverageEvaluator;
import org.aksw.rdfunit.enums.TestCaseExecutionType;
import org.aksw.rdfunit.exceptions.TripleReaderException;
import org.aksw.rdfunit.exceptions.TripleWriterException;
import org.aksw.rdfunit.io.RDFFirstSuccessReader;
import org.aksw.rdfunit.io.RDFMultipleWriter;
import org.aksw.rdfunit.io.RDFReader;
import org.aksw.rdfunit.io.RDFStreamReader;
import org.aksw.rdfunit.io.RDFWriter;
import org.aksw.rdfunit.io.RDFWriterFactory;
import org.aksw.rdfunit.io.format.SerializationFormat;
import org.aksw.rdfunit.services.PrefixNSService;
import org.aksw.rdfunit.sources.Source;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.TestSuite;
import org.aksw.rdfunit.tests.executors.TestExecutor;
import org.aksw.rdfunit.tests.executors.TestExecutorFactory;
import org.aksw.rdfunit.tests.executors.monitors.SimpleTestExecutorMonitor;
import org.aksw.rdfunit.tests.executors.monitors.TestExecutorMonitor;
import org.aksw.rdfunit.tests.generators.TestGeneratorExecutor;
import org.aksw.rdfunit.validate.ParameterException;
import org.aksw.rdfunit.validate.utils.ValidateUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateCLI {
    private static final Logger log = LoggerFactory.getLogger(ValidateCLI.class);

    public static void main(String[] args) throws Exception {
        CommandLine commandLine = ValidateUtils.parseArguments(args);
        if (commandLine.hasOption("h")) {
            ValidateCLI.displayHelpAndExit();
        }
        String dataFolder = commandLine.getOptionValue("f", "../data/");
        RDFUnitUtils.fillSchemaServiceFromLOV();
        RDFUnitUtils.fillSchemaServiceFromFile((String)(dataFolder + "schemaDecl.csv"));
        RDFUnitConfiguration configuration = null;
        try {
            configuration = ValidateUtils.getConfigurationFromArguments(commandLine);
        }
        catch (ParameterException e) {
            String message = e.getMessage();
            if (message != null) {
                ValidateCLI.displayHelpAndExit(message);
            }
            ValidateCLI.displayHelpAndExit();
        }
        assert (configuration != null);
        if (!RDFUnitUtils.fileExists((String)configuration.getDataFolder())) {
            log.error("Path : " + configuration.getDataFolder() + " does not exists, use -f argument");
            System.exit(1);
        }
        RDFStreamReader patternReader_data = new RDFStreamReader(configuration.getDataFolder() + "patterns.ttl");
        RDFReader patternReader_resource = RDFUnitUtils.getPatternsFromResource();
        RDFFirstSuccessReader patternReader = new RDFFirstSuccessReader(Arrays.asList(patternReader_data, patternReader_resource));
        RDFStreamReader testGeneratorReader_data = new RDFStreamReader(configuration.getDataFolder() + "testAutoGenerators.ttl");
        RDFReader testGeneratorReader_resource = RDFUnitUtils.getAutoGeneratorsOWLFromResource();
        RDFFirstSuccessReader testGeneratorReader = new RDFFirstSuccessReader(Arrays.asList(testGeneratorReader_data, testGeneratorReader_resource));
        RDFUnit rdfunit = new RDFUnit();
        try {
            rdfunit.initPatternsAndGenerators((RDFReader)patternReader, (RDFReader)testGeneratorReader);
        }
        catch (TripleReaderException e) {
            ValidateCLI.displayHelpAndExit("Cannot read patterns and/or pattern generators");
        }
        Source dataset = configuration.getTestSource();
        TestGeneratorExecutor testGeneratorExecutor = new TestGeneratorExecutor(configuration.isAutoTestsEnabled(), configuration.isTestCacheEnabled(), configuration.isManualTestsEnabled());
        TestSuite testSuite = testGeneratorExecutor.generateTestSuite(configuration.getTestFolder(), dataset, rdfunit.getAutoGenerators());
        TestExecutor testExecutor = TestExecutorFactory.createTestExecutor((TestCaseExecutionType)configuration.getTestCaseExecutionType());
        if (testExecutor == null) {
            ValidateCLI.displayHelpAndExit("Cannot initialize test executor. Exiting");
        }
        SimpleTestExecutorMonitor testExecutorMonitor = new SimpleTestExecutorMonitor();
        testExecutor.addTestExecutorMonitor((TestExecutorMonitor)testExecutorMonitor);
        testExecutor.execute(dataset, testSuite, 0);
        String filename = "../data/results/" + dataset.getPrefix() + "." + configuration.getTestCaseExecutionType().toString();
        ArrayList<RDFWriter> outputWriters = new ArrayList<RDFWriter>();
        for (SerializationFormat serializationFormat : configuration.getOutputFormats()) {
            outputWriters.add(RDFWriterFactory.createWriterFromFormat((String)filename, (SerializationFormat)serializationFormat, (TestCaseExecutionType)configuration.getTestCaseExecutionType()));
        }
        RDFMultipleWriter resultWriter = new RDFMultipleWriter(outputWriters);
        try {
            resultWriter.write(testExecutorMonitor.getModel());
            log.info("Results stored in: " + filename + ".*");
        }
        catch (TripleWriterException e) {
            log.error("Cannot write tests to file: " + e.getMessage());
        }
        if (configuration.isCalculateCoverageEnabled()) {
            Model model = ModelFactory.createDefaultModel();
            PrefixNSService.setNSPrefixesInModel((Model)model);
            for (TestCase ut : testSuite.getTestCases()) {
                model.add(ut.getUnitTestModel());
            }
            TestCoverageEvaluator tce = new TestCoverageEvaluator();
            tce.calculateCoverage((QueryExecutionFactory)new QueryExecutionFactoryModel(model), dataset.getPrefix() + ".property.count", dataset.getPrefix() + ".class.count");
        }
    }

    private static void displayHelpAndExit(String errorMessage) {
        log.error(errorMessage);
        ValidateCLI.displayHelpAndExit();
    }

    private static void displayHelpAndExit() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("rdfunit", ValidateUtils.getCliOptions());
        System.exit(1);
    }
}

