/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.validate;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aksw.rdfunit.RDFUnit;
import org.aksw.rdfunit.RDFUnitConfiguration;
import org.aksw.rdfunit.Utils.RDFUnitUtils;
import org.aksw.rdfunit.enums.TestCaseExecutionType;
import org.aksw.rdfunit.exceptions.TripleReaderException;
import org.aksw.rdfunit.exceptions.TripleWriterException;
import org.aksw.rdfunit.io.DataReader;
import org.aksw.rdfunit.io.HTMLResultsWriter;
import org.aksw.rdfunit.sources.Source;
import org.aksw.rdfunit.tests.TestSuite;
import org.aksw.rdfunit.tests.executors.TestExecutor;
import org.aksw.rdfunit.tests.executors.TestExecutorFactory;
import org.aksw.rdfunit.tests.executors.monitors.SimpleTestExecutorMonitor;
import org.aksw.rdfunit.tests.executors.monitors.TestExecutorMonitor;
import org.aksw.rdfunit.tests.generators.TestGeneratorExecutor;
import org.aksw.rdfunit.validate.ParameterException;
import org.aksw.rdfunit.validate.ValidateUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateWS
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ValidateWS.class);
    private final String dataFolder = "data/";
    private final String testFolder = "data/tests/";
    private final DataReader patternReader = RDFUnitUtils.getPatternsFromResource();
    private final DataReader testGeneratorReader = RDFUnitUtils.getAutoGeneratorsFromResource();
    private final RDFUnit rdfunit = new RDFUnit();

    public void init() throws ServletException {
        RDFUnitUtils.fillSchemaServiceFromLOV();
        RDFUnitUtils.fillSchemaServiceFromFile((InputStream)ValidateWS.class.getResourceAsStream("/org/aksw/rdfunit/schemaDecl.csv"));
        try {
            this.rdfunit.initPatternsAndGenerators(this.patternReader, this.testGeneratorReader);
        }
        catch (TripleReaderException e) {
            log.error("Cannot read patterns and/or pattern generators");
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.handleRequestAndRespond(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.handleRequestAndRespond(httpServletRequest, httpServletResponse);
    }

    private void handleRequestAndRespond(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String[] arguments = ValidateWS.convertArgumentsToStringArray(httpServletRequest);
        CommandLine commandLine = null;
        try {
            commandLine = ValidateUtils.parseArguments(arguments);
        }
        catch (ParseException e) {
            e.printStackTrace();
            this.printMessage(httpServletResponse, "Error");
            return;
        }
        if (commandLine.hasOption("h")) {
            this.printHelpMessage(httpServletResponse);
            httpServletResponse.getWriter().close();
            return;
        }
        boolean printHelpAndReturn = false;
        RDFUnitConfiguration configuration = null;
        try {
            configuration = ValidateUtils.getConfigurationFromArguments(commandLine);
        }
        catch (ParameterException e) {
            String message = e.getMessage();
            if (message != null) {
                this.printMessage(httpServletResponse, message);
            }
            printHelpAndReturn = true;
        }
        assert (configuration != null);
        if (commandLine.hasOption("h")) {
            printHelpAndReturn = true;
        }
        if (printHelpAndReturn) {
            this.printHelpMessage(httpServletResponse);
            httpServletResponse.getWriter().close();
            return;
        }
        Source dataset = configuration.getTestSource();
        TestSuite testSuite = this.getTestSuite(configuration, dataset);
        TestExecutor testExecutor = TestExecutorFactory.createTestExecutor((TestCaseExecutionType)configuration.getResultLevelReporting());
        if (testExecutor == null) {
            this.printMessage(httpServletResponse, "Cannot initialize test executor. Exiting");
            httpServletResponse.getWriter().close();
            return;
        }
        SimpleTestExecutorMonitor testExecutorMonitor = new SimpleTestExecutorMonitor();
        testExecutor.addTestExecutorMonitor((TestExecutorMonitor)testExecutorMonitor);
        testExecutor.execute(dataset, testSuite, 0);
        httpServletResponse.setContentType("text/html");
        try {
            HTMLResultsWriter html = HTMLResultsWriter.create((TestCaseExecutionType)configuration.getResultLevelReporting(), (OutputStream)httpServletResponse.getOutputStream());
            html.write(testExecutorMonitor.getModel());
        }
        catch (TripleWriterException e) {
            log.error("Cannot write tests to file: " + e.getMessage());
        }
    }

    public void destroy() {
    }

    private synchronized TestSuite getTestSuite(RDFUnitConfiguration configuration, Source dataset) {
        TestGeneratorExecutor testGeneratorExecutor = new TestGeneratorExecutor(configuration.isTestCacheEnabled(), configuration.isManualTestsEnabled());
        return testGeneratorExecutor.generateTestSuite(configuration.getTestFolder(), dataset, this.rdfunit.getAutoGenerators());
    }

    private void printHelpMessage(HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(printWriter, 200, "/validate?", "<pre>", ValidateUtils.getCliOptions(), 0, 0, "</pre>");
    }

    private void printMessage(HttpServletResponse httpServletResponse, String message) throws IOException {
        httpServletResponse.setContentType("text/html");
        PrintWriter out = httpServletResponse.getWriter();
        out.println("<pre>" + message + "</pre>");
    }

    private static String[] convertArgumentsToStringArray(HttpServletRequest httpServletRequest) {
        String[] args = new String[httpServletRequest.getParameterMap().size() * 2];
        int x = 0;
        for (Object key : httpServletRequest.getParameterMap().keySet()) {
            String pname = (String)key;
            pname = pname.length() == 1 ? "-" + pname : "--" + pname;
            args[x++] = pname;
            args[x++] = httpServletRequest.getParameter((String)key);
        }
        return args;
    }
}

