/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.validate;

import com.hp.hpl.jena.rdf.model.Model;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.aksw.rdfunit.RDFUnit;
import org.aksw.rdfunit.Utils.CacheUtils;
import org.aksw.rdfunit.Utils.RDFUnitUtils;
import org.aksw.rdfunit.Utils.TestUtils;
import org.aksw.rdfunit.enums.TestCaseExecutionType;
import org.aksw.rdfunit.exceptions.TripleReaderException;
import org.aksw.rdfunit.io.DataFirstSuccessReader;
import org.aksw.rdfunit.io.DataModelReader;
import org.aksw.rdfunit.io.DataReader;
import org.aksw.rdfunit.io.DataReaderFactory;
import org.aksw.rdfunit.io.RDFStreamReader;
import org.aksw.rdfunit.sources.DumpSource;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.Source;
import org.aksw.rdfunit.tests.TestSuite;
import org.aksw.rdfunit.tests.executors.TestExecutor;
import org.aksw.rdfunit.tests.executors.TestExecutorFactory;
import org.aksw.rdfunit.tests.executors.monitors.SimpleTestExecutorMonitor;
import org.aksw.rdfunit.tests.executors.monitors.TestExecutorMonitor;

public class RDFUnitStaticWrapper {
    private static DataReader ontologyReader = null;
    private static TestSuite testSuite = null;
    private static String ontologyURI = null;
    private static String ontologyResourceURI = null;

    private RDFUnitStaticWrapper() {
    }

    public static void initWrapper(String _ontologyURI, String _ontologyResourceURI) {
        ontologyURI = _ontologyURI;
        ontologyResourceURI = _ontologyResourceURI;
    }

    private static DataReader getOntologyReader() {
        if (ontologyReader == null) {
            if (ontologyURI == null && ontologyResourceURI == null) {
                throw new IllegalArgumentException("RDFUnitStaticWrapper was not initialized properly. Call initWrapper() once before any validation. ");
            }
            ArrayList<Object> nifReaderList = new ArrayList<Object>();
            if (ontologyResourceURI != null) {
                nifReaderList.add(new RDFStreamReader(RDFUnitStaticWrapper.class.getResourceAsStream(ontologyResourceURI)));
            }
            nifReaderList.add(DataReaderFactory.createDereferenceReader((String)ontologyURI));
            ontologyReader = new DataFirstSuccessReader(nifReaderList);
        }
        return ontologyReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TestSuite getTestSuite() {
        if (testSuite != null) return testSuite;
        Class<RDFUnitStaticWrapper> clazz = RDFUnitStaticWrapper.class;
        synchronized (RDFUnitStaticWrapper.class) {
            ArrayList manualTestCases;
            if (testSuite != null) return testSuite;
            SchemaSource nifSchema = new SchemaSource("custom", ontologyURI, RDFUnitStaticWrapper.getOntologyReader());
            RDFStreamReader manualTestCaseReader = new RDFStreamReader(RDFUnitStaticWrapper.class.getResourceAsStream(CacheUtils.getSourceManualTestFile((String)"/org/aksw/rdfunit/tests/", (Source)nifSchema)));
            try {
                manualTestCases = TestUtils.instantiateTestsFromModel((Model)manualTestCaseReader.read());
            }
            catch (TripleReaderException e) {
                manualTestCases = new ArrayList();
            }
            RDFUnit rdfunit = new RDFUnit();
            try {
                rdfunit.initPatternsAndGenerators(RDFUnitUtils.getPatternsFromResource(), RDFUnitUtils.getAutoGeneratorsFromResource());
            }
            catch (TripleReaderException e) {
                testSuite = new TestSuite(manualTestCases);
                // ** MonitorExit[var0] (shouldn't be in output)
                return testSuite;
            }
            Collection autoTestCases = TestUtils.instantiateTestsFromAG((Collection)rdfunit.getAutoGenerators(), (Source)nifSchema);
            ArrayList allTestCases = new ArrayList();
            allTestCases.addAll(autoTestCases);
            allTestCases.addAll(manualTestCases);
            testSuite = new TestSuite(allTestCases);
            // ** MonitorExit[var0] (shouldn't be in output)
            return testSuite;
        }
    }

    public static Model validate(Model input) {
        return RDFUnitStaticWrapper.validate(input, TestCaseExecutionType.rlogTestCaseResult);
    }

    public static Model validate(Model input, TestCaseExecutionType executionType) {
        return RDFUnitStaticWrapper.validate(input, executionType, "custom");
    }

    public static Model validate(Model input, String inputURI) {
        return RDFUnitStaticWrapper.validate(input, TestCaseExecutionType.rlogTestCaseResult, inputURI);
    }

    public static Model validate(Model input, TestCaseExecutionType executionType, String inputURI) {
        boolean enableRDFUnitLogging = false;
        SimpleTestExecutorMonitor testExecutorMonitor = new SimpleTestExecutorMonitor(false);
        TestExecutor testExecutor = TestExecutorFactory.createTestExecutor((TestCaseExecutionType)executionType);
        testExecutor.addTestExecutorMonitor((TestExecutorMonitor)testExecutorMonitor);
        DumpSource modelSource = new DumpSource("custom", inputURI, (DataReader)new DataModelReader(input), Arrays.asList(new SchemaSource("custom", ontologyURI, RDFUnitStaticWrapper.getOntologyReader())));
        testExecutor.execute((Source)modelSource, RDFUnitStaticWrapper.getTestSuite(), 0);
        return testExecutorMonitor.getModel();
    }
}

