/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.utils;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;

public final class PrefixNSService {
    private PrefixNSService() {
    }

    public static String getNSFromPrefix(String prefix) {
        return (String)MapInstance.prefixNsBidiMap.get((Object)prefix);
    }

    public static String getPrefixFromNS(String namespace) {
        return (String)MapInstance.prefixNsBidiMap.getKey((Object)namespace);
    }

    public static void setNSPrefixesInModel(Model model) {
        model.setNsPrefixes(PrefixNSService.getPrefixMap());
    }

    public static String getSparqlPrefixDecl() {
        return DeclInstance.sparqlPrefixDecl;
    }

    public static String getURIFromAbbrev(String abbreviation) {
        String[] parts = abbreviation.split(":");
        if (parts.length == 2) {
            return PrefixNSService.getNSFromPrefix(parts[0]) + parts[1];
        }
        throw new IllegalArgumentException("Undefined prefix in " + abbreviation);
    }

    public static String getLocalName(String uri, String prefix) {
        String ns = PrefixNSService.getNSFromPrefix(prefix);
        if (ns != null) {
            return uri.replace(ns, "");
        }
        throw new IllegalArgumentException("Undefined prefix (" + prefix + ") in URI: " + uri);
    }

    private static Map<String, String> getPrefixMap() {
        return Collections.unmodifiableMap(MapInstance.prefixNsBidiMap);
    }

    private static class DeclInstance {
        private static final String sparqlPrefixDecl = DeclInstance.createSparqlPrefixes();

        private DeclInstance() {
        }

        private static String createSparqlPrefixes() {
            StringBuilder sparqlPrefixes = new StringBuilder();
            for (Map.Entry entry : MapInstance.prefixNsBidiMap.entrySet()) {
                sparqlPrefixes.append(" PREFIX ").append((String)entry.getKey()).append(": <").append((String)entry.getValue()).append("> \n");
            }
            return sparqlPrefixes.toString();
        }
    }

    private static final class MapInstance {
        private static final BidiMap<String, String> prefixNsBidiMap = MapInstance.createPrefixNsBidiMap();

        private MapInstance() {
        }

        private static BidiMap<String, String> createPrefixNsBidiMap() {
            DualHashBidiMap dualMap = new DualHashBidiMap();
            Model prefixModel = ModelFactory.createDefaultModel();
            try (InputStream is = PrefixNSService.class.getResourceAsStream("/org/aksw/rdfunit/prefixes.ttl");){
                prefixModel.read(is, null, "TURTLE");
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot read prefixes.ttl from resources", e);
            }
            Map prf = prefixModel.getNsPrefixMap();
            for (Map.Entry entry : prf.entrySet()) {
                dualMap.put(entry.getKey(), entry.getValue());
            }
            return dualMap;
        }
    }
}

