/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io.writer;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.rdfunit.io.IOUtils;
import org.aksw.rdfunit.io.writer.AbstractRDFWriter;
import org.aksw.rdfunit.io.writer.RDFWriter;
import org.aksw.rdfunit.io.writer.RDFWriterException;
import org.aksw.rdfunit.utils.PrefixNSService;

public class RDFFileWriter
extends AbstractRDFWriter
implements RDFWriter {
    private final String filename;
    private final String filetype;
    private final boolean skipIfExists;
    private final boolean createParentDirectories;
    private final boolean overwrite;

    public RDFFileWriter(String filename) {
        this(filename, "TURTLE", false, true, true);
    }

    public RDFFileWriter(String filename, String filetype) {
        this(filename, filetype, false, true, true);
    }

    public RDFFileWriter(String filename, boolean skipIfExists) {
        this(filename, "TURTLE", skipIfExists, true, true);
    }

    public RDFFileWriter(String filename, String filetype, boolean skipIfExists, boolean createParentDirectories, boolean overwrite) {
        this.filename = filename;
        this.filetype = filetype;
        this.skipIfExists = skipIfExists;
        this.createParentDirectories = createParentDirectories;
        this.overwrite = overwrite;
    }

    @Override
    public void write(QueryExecutionFactory qef) throws RDFWriterException {
        File parentF;
        File file = new File(this.filename);
        if (file.exists() && this.skipIfExists) {
            return;
        }
        if (file.exists() && !this.overwrite) {
            throw new RDFWriterException("Error writing file: File already exists and cannot overwrite");
        }
        if (this.createParentDirectories && (parentF = file.getParentFile()) != null && !parentF.exists() && !parentF.mkdirs()) {
            throw new RDFWriterException("Error writing file: Cannot create new directory structure for file: " + this.filename);
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            Model model = IOUtils.getModelFromQueryFactory(qef);
            PrefixNSService.setNSPrefixesInModel((Model)model);
            model.write((OutputStream)fos, this.filetype);
        }
        catch (Exception e) {
            throw new RDFWriterException("Error writing file: " + e.getMessage(), e);
        }
    }
}

