/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io.reader;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.aksw.rdfunit.io.reader.AbstractRDFReader;
import org.aksw.rdfunit.io.reader.RDFReader;
import org.aksw.rdfunit.io.reader.RDFReaderException;
import org.aksw.rdfunit.io.reader.RDFReaderFactory;

public class RDFDereferenceLimitReader
extends AbstractRDFReader
implements RDFReader {
    private final String uri;
    private final long limitInBytes;
    private final boolean strict;

    public RDFDereferenceLimitReader(String uri, long limitInBytes) {
        this(uri, limitInBytes, true);
    }

    public RDFDereferenceLimitReader(String uri, long limitInBytes, boolean strict) {
        this.uri = uri;
        this.limitInBytes = limitInBytes;
        this.strict = strict;
    }

    @Override
    public void read(Model model) throws RDFReaderException {
        long size = RDFDereferenceLimitReader.getUriSize(this.uri);
        if (size > this.limitInBytes || !this.strict || size < 0L) {
            throw new RDFReaderException("'" + this.uri + "' size (" + size + ") bigger than " + this.limitInBytes);
        }
        RDFReaderFactory.createDereferenceReader(this.uri).read(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getUriSize(String urlStr) {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlStr);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("HEAD");
            conn.getInputStream();
            long l = conn.getContentLengthLong();
            return l;
        }
        catch (IOException e) {
            long l = -1L;
            return l;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }
}

